/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import com.bc.ceres.core.ProgressMonitor;
import java.util.OptionalDouble;
import java.util.stream.DoubleStream;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.math.DoubleList;
import org.esa.snap.core.util.math.IndexValidator;

public class Range {
    private double min;
    private double max;

    public Range() {
    }

    public Range(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMinMax(double min, double max) {
        this.setMin(min);
        this.setMax(max);
    }

    public boolean isValid() {
        return Math.abs(this.max - this.min) < 1.0E-12;
    }

    public void aggregate(Object values, boolean unsigned, IndexValidator validator, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        Range range = Range.computeRangeGeneric(values, unsigned, validator, null, pm);
        this.setMax(Math.max(this.getMax(), range.getMax()));
        this.setMin(Math.min(this.getMin(), range.getMin()));
    }

    public static Range computeRangeByte(byte[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.Byte(values), validator, range, pm);
    }

    public static Range computeRangeUByte(byte[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.UByte(values), validator, range, pm);
    }

    public static Range computeRangeShort(short[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.Short(values), validator, range, pm);
    }

    public static Range computeRangeUShort(short[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.UShort(values), validator, range, pm);
    }

    public static Range computeRangeInt(int[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.Int(values), validator, range, pm);
    }

    public static Range computeRangeUInt(int[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.UInt(values), validator, range, pm);
    }

    public static Range computeRangeFloat(float[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.Float(values), validator, range, pm);
    }

    public static Range computeRangeDouble(double[] values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        return Range.computeRangeDouble(new DoubleList.Double(values), validator, range, pm);
    }

    public static Range computeRangeDouble(double[] values, Range range) {
        OptionalDouble min = DoubleStream.of(values).min();
        OptionalDouble max = DoubleStream.of(values).max();
        double minValue = Double.NaN;
        if (min.isPresent()) {
            minValue = min.getAsDouble();
        }
        double maxValue = Double.NaN;
        if (max.isPresent()) {
            maxValue = max.getAsDouble();
        }
        if (range == null) {
            range = new Range(minValue, maxValue);
        } else {
            range.min = minValue;
            range.max = maxValue;
        }
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Range computeRangeDouble(DoubleList values, IndexValidator validator, Range range, ProgressMonitor pm) {
        Guardian.assertNotNull("validator", validator);
        int n = values.getSize();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        pm.beginTask("Computing range ...", n);
        try {
            for (int i = 0; i < n; ++i) {
                double value;
                if (validator.validateIndex(i) && !Double.isNaN(value = values.getDouble(i)) && !Double.isInfinite(value)) {
                    if (value < min) {
                        min = value;
                    }
                    if (value > max) {
                        max = value;
                    }
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        if (range == null) {
            range = new Range(min, max);
        } else {
            range.setMinMax(min, max);
        }
        return range;
    }

    public static Range computeRangeGeneric(Object values, boolean unsigned, IndexValidator validator, Range range, ProgressMonitor pm) {
        Range result;
        Guardian.assertNotNull("validator", validator);
        if (values instanceof byte[]) {
            result = unsigned ? Range.computeRangeUByte((byte[])values, validator, range, pm) : Range.computeRangeByte((byte[])values, validator, range, pm);
        } else if (values instanceof short[]) {
            result = unsigned ? Range.computeRangeUShort((short[])values, validator, range, pm) : Range.computeRangeShort((short[])values, validator, range, pm);
        } else if (values instanceof int[]) {
            result = unsigned ? Range.computeRangeUInt((int[])values, validator, range, pm) : Range.computeRangeInt((int[])values, validator, range, pm);
        } else if (values instanceof float[]) {
            result = Range.computeRangeFloat((float[])values, validator, range, pm);
        } else if (values instanceof double[]) {
            result = Range.computeRangeDouble((double[])values, validator, range, pm);
        } else if (values instanceof DoubleList) {
            result = Range.computeRangeDouble((DoubleList)values, validator, range, pm);
        } else {
            if (values == null) {
                throw new IllegalArgumentException("values is null");
            }
            throw new IllegalArgumentException("values has an illegal type: " + values.getClass());
        }
        return result;
    }

    public String toString() {
        return this.getMin() + "," + this.getMax();
    }
}

