/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.math.Array;
import org.esa.snap.core.util.math.IntervalPartition;
import org.esa.snap.core.util.math.MatrixFactory;
import org.esa.snap.core.util.math.VectorLookupTable;

public class MatrixLookupTable {
    private final int m;
    private final int n;
    private final MatrixFactory matrixFactory;
    private final VectorLookupTable vectorLookupTable;

    public MatrixLookupTable(int m, int n, MatrixFactory matrixFactory, double[] values, IntervalPartition ... dimensions) {
        this(m, n, matrixFactory, new Array.Double(values), dimensions);
    }

    public MatrixLookupTable(int m, int n, MatrixFactory matrixFactory, float[] values, IntervalPartition ... dimensions) {
        this(m, n, matrixFactory, new Array.Float(values), dimensions);
    }

    public MatrixLookupTable(int m, int n, MatrixFactory matrixFactory, double[] values, double[] ... dimensions) {
        this(m, n, matrixFactory, values, IntervalPartition.createArray(dimensions));
    }

    public MatrixLookupTable(int m, int n, MatrixFactory matrixFactory, float[] values, float[] ... dimensions) {
        this(m, n, matrixFactory, values, IntervalPartition.createArray(dimensions));
    }

    private MatrixLookupTable(int m, int n, MatrixFactory matrixFactory, Array values, IntervalPartition ... dimensions) {
        this.m = m;
        this.n = n;
        this.matrixFactory = matrixFactory;
        this.vectorLookupTable = new VectorLookupTable(m * n, values, dimensions);
    }

    public MatrixLookupTable(int m, int n, MatrixFactory matrixFactory, VectorLookupTable vectorLookupTable) {
        this.m = m;
        this.n = n;
        this.matrixFactory = matrixFactory;
        this.vectorLookupTable = vectorLookupTable;
    }

    public final int getDimensionCount() {
        return this.vectorLookupTable.getDimensionCount();
    }

    public final IntervalPartition[] getDimensions() {
        return this.vectorLookupTable.getDimensions();
    }

    public final IntervalPartition getDimension(int i) {
        return this.vectorLookupTable.getDimension(i);
    }

    public final double[][] getValues(double ... coordinates) throws IllegalArgumentException {
        return this.matrixFactory.createMatrix(this.m, this.n, this.vectorLookupTable.getValues(coordinates));
    }
}

