/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

public class LogLinearTransform {
    private static final double FORCED_CHANGE_FACTOR = 1.0E-4;

    public static double getLinearValueUsingLinearWeight(double linearWeight, double min, double max) {
        if (linearWeight == 0.0) {
            return min;
        }
        if (linearWeight == 1.0) {
            return max;
        }
        double deltaNormalized = max - min;
        double linearValue = min + linearWeight * deltaNormalized;
        if (linearWeight > 0.0 && linearValue < min) {
            return min;
        }
        if (linearWeight < 1.0 && linearValue > max) {
            return max;
        }
        if (linearWeight < 0.0 && linearValue >= min) {
            return min - (max - min) * 1.0E-4;
        }
        if (linearWeight > 1.0 && linearValue <= max) {
            return max + (max - min) * 1.0E-4;
        }
        return linearValue;
    }

    public static double getLogarithmicValueUsingLinearWeight(double weight, double min, double max) {
        double linearValue = LogLinearTransform.getLinearValueUsingLinearWeight(weight, min, max);
        if (linearValue == min) {
            return min;
        }
        if (linearValue == max) {
            return max;
        }
        double b = Math.log(max / min) / (max - min);
        double a = min / Math.exp(b * min);
        double logValue = a * Math.exp(b * linearValue);
        if (linearValue > min && logValue < min) {
            return min;
        }
        if (linearValue < max && logValue > max) {
            return max;
        }
        if (linearValue < min && logValue >= min) {
            return min - (max - min) * 1.0E-4;
        }
        if (linearValue > max && logValue <= max) {
            return max + (max - min) * 1.0E-4;
        }
        return logValue;
    }

    public static double getLogarithmicValue(double linearValue, double min, double max) {
        if (linearValue == min) {
            return min;
        }
        if (linearValue == max) {
            return max;
        }
        double b = Math.log(max / min) / (max - min);
        double a = min / Math.exp(b * min);
        double logValue = a * Math.exp(b * linearValue);
        if (linearValue > min && logValue < min) {
            return min;
        }
        if (linearValue < max && logValue > max) {
            return max;
        }
        if (linearValue < min && logValue >= min) {
            return min - (max - min) * 1.0E-4;
        }
        if (linearValue > max && logValue <= max) {
            return max + (max - min) * 1.0E-4;
        }
        return logValue;
    }

    public static double getLinearValue(double linearWeight, double min, double max) {
        if (linearWeight == 0.0) {
            return min;
        }
        if (linearWeight == 1.0) {
            return max;
        }
        double deltaNormalized = max - min;
        double linearValue = min + linearWeight * deltaNormalized;
        if (linearWeight > 0.0 && linearValue < min) {
            return min;
        }
        if (linearWeight < 1.0 && linearValue > max) {
            return max;
        }
        if (linearWeight < 0.0 && linearValue >= min) {
            return min - (max - min) * 1.0E-4;
        }
        if (linearWeight > 1.0 && linearValue <= max) {
            return max + (max - min) * 1.0E-4;
        }
        return linearValue;
    }

    public static double getLinearWeightFromLogValue(double logValue, double min, double max) {
        if (logValue == min) {
            return 0.0;
        }
        if (logValue == max) {
            return 1.0;
        }
        double b = Math.log(max / min) / (max - min);
        double a = min / Math.exp(b * min);
        double linearWeight = (Math.log(logValue / a) / b - min) / (max - min);
        if (logValue > min && linearWeight < 0.0) {
            return 0.0;
        }
        if (logValue < max && linearWeight > 1.0) {
            return 1.0;
        }
        if (logValue < min && linearWeight >= 0.0) {
            return -1.0E-4;
        }
        if (logValue > max && linearWeight <= 1.0) {
            return 1.0001;
        }
        return linearWeight;
    }
}

