/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

public class LinearAlgebra {
    public static boolean isMatrix(double[][] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (double[] row : array) {
            if (row != null && row.length != 0) continue;
            return false;
        }
        for (int i = 1; i < array.length; ++i) {
            if (array[i].length == array[0].length) continue;
            return false;
        }
        return true;
    }

    public static boolean isMatrix(int rowCount, int colCount, double[][] array) {
        int m = Math.max(0, rowCount);
        int n = Math.max(0, colCount);
        if (array == null || array.length != m) {
            return false;
        }
        for (double[] row : array) {
            if (row != null && row.length == n) continue;
            return false;
        }
        return true;
    }

    public static double[] multiply(double[] b, double c) {
        int i = 0;
        while (i < b.length) {
            int n = i++;
            b[n] = b[n] * c;
        }
        return b;
    }

    public static double[] multiply(double[][] a, double[] b) {
        return LinearAlgebra.multiply(a, b, new double[a[0].length]);
    }

    public static double[] multiply(double[][] a, double[] b, double[] c) {
        for (int i = 0; i < a.length; ++i) {
            c[i] = LinearAlgebra.innerProduct(a[i], b);
        }
        return c;
    }

    public static double[] multiply(double[] b, double[][] a) {
        return LinearAlgebra.multiply(b, a, new double[a[0].length]);
    }

    public static double[] multiply(double[] b, double[][] a, double[] c) {
        for (int j = 0; j < a[0].length; ++j) {
            c[j] = LinearAlgebra.innerProduct(b, a, j);
        }
        return c;
    }

    public static double[] multiplyAndSubtract(double[] b, double[][] a, double s) {
        return LinearAlgebra.multiplyAndSubtract(b, a, s, new double[a[0].length]);
    }

    public static double[] multiplyAndSubtract(double[] b, double[][] a, double s, double[] c) {
        for (int j = 0; j < a[0].length; ++j) {
            c[j] = LinearAlgebra.innerProduct(b, a, j) - s;
        }
        return c;
    }

    public static double innerProduct(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i];
        }
        return sum;
    }

    public static double innerProduct(double[] a, double[][] b, int j) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i][j];
        }
        return sum;
    }

    public static double innerProduct(double[][] a, double[][] b, int i, int j) {
        return LinearAlgebra.innerProduct(a[i], b, j);
    }

    public static double[][] outerProduct(double[] a, double[] b) {
        return LinearAlgebra.outerProduct(a, b, new double[a.length][b.length]);
    }

    public static double[][] outerProduct(double[] a, double[] b, double[][] c) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                c[i][j] = a[i] * b[j];
            }
        }
        return c;
    }

    public static double[][] multiply(double[][] a, double[][] b) {
        return LinearAlgebra.multiply(a, b, new double[a.length][b[0].length]);
    }

    public static double[][] multiply(double[][] a, double[][] b, double[][] c) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b[0].length; ++j) {
                c[i][j] = LinearAlgebra.innerProduct(a, b, i, j);
            }
        }
        return c;
    }

    public static double[][] subtract(double[][] a, double[] b, double[] c) {
        int m = b.length;
        int n = c.length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray = a[i];
                int n2 = j;
                dArray[n2] = dArray[n2] - b[i] * c[j];
            }
        }
        return a;
    }
}

