/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.math.SingularMatrixException;

public class LinEqSysSolver {
    public static boolean gauss(double[][] a, double[] c, double[] x, int n, double eps) throws SingularMatrixException {
        int j;
        double t;
        int i;
        for (int k = 0; k < n - 1; ++k) {
            if (!LinEqSysSolver.pivotize(a, c, k, n, eps)) {
                throw new SingularMatrixException();
            }
            i = k + 1;
            while (i < n) {
                t = -a[i][k] / a[k][k];
                for (j = k + 1; j < n; ++j) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + t * a[k][j];
                }
                int n3 = i++;
                c[n3] = c[n3] + t * c[k];
            }
        }
        for (i = 0; i < n; ++i) {
            x[i] = 0.0;
        }
        x[n - 1] = c[n - 1] / a[n - 1][n - 1];
        for (i = n - 2; i >= 0; --i) {
            t = 0.0;
            for (j = i + 1; j < n; ++j) {
                t += a[i][j] * x[j];
            }
            int n4 = i;
            x[n4] = x[n4] + (c[i] - t) / a[i][i];
        }
        return true;
    }

    public static boolean gauss_debug(double[][] a, double[] c, double[] x, int n, double eps) {
        Debug.trace("LinEqSysSolver: before gauss() call");
        Debug.trace("LinEqSysSolver: a", a);
        Debug.trace("LinEqSysSolver: c", c);
        Debug.trace("LinEqSysSolver: coeffs", x);
        boolean success = LinEqSysSolver.gauss(a, c, x, n, eps);
        Debug.trace("LinEqSysSolver: after gauss() call");
        Debug.trace("LinEqSysSolver: a", a);
        Debug.trace("LinEqSysSolver: c", c);
        Debug.trace("LinEqSysSolver: coeffs", x);
        return success;
    }

    public static boolean pivotize(double[][] a, double[] c, int k, int n, double eps) {
        double t;
        int pivot = k;
        double maxa = LinEqSysSolver.abs(a[k][k]);
        for (int i = k + 1; i < n; ++i) {
            t = LinEqSysSolver.abs(a[i][k]);
            if (!(t > maxa)) continue;
            pivot = i;
            maxa = t;
        }
        boolean success = true;
        if (pivot != k) {
            for (int j = k; j < n - 1; ++j) {
                t = a[pivot][j];
                a[pivot][j] = a[k][j];
                a[k][j] = t;
            }
            t = c[pivot];
            c[pivot] = c[k];
            c[k] = t;
        } else if (maxa <= eps) {
            success = false;
        }
        return success;
    }

    private static double abs(double x) {
        return x < 0.0 ? -x : x;
    }
}

