/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.math.Array;

public class IntervalPartition {
    private final double[] sequence;
    private final int monotonicity;

    public IntervalPartition(double ... sequence) {
        this(new Array.Double(sequence));
    }

    public IntervalPartition(float ... sequence) {
        this(new Array.Float(sequence));
    }

    private IntervalPartition(Array sequence) {
        if (sequence.getLength() < 2) {
            throw new IllegalArgumentException("sequence.length < 2");
        }
        this.monotonicity = IntervalPartition.ensureStrictMonotonicity(sequence);
        this.sequence = new double[sequence.getLength()];
        sequence.copyTo(0, this.sequence, 0, this.sequence.length);
    }

    public static IntervalPartition[] createArray(double[] ... sequences) {
        if (sequences.length == 0) {
            throw new IllegalArgumentException("sequences.length == 0");
        }
        IntervalPartition[] partitions = new IntervalPartition[sequences.length];
        for (int i = 0; i < partitions.length; ++i) {
            partitions[i] = new IntervalPartition(sequences[i]);
        }
        return partitions;
    }

    public static IntervalPartition[] createArray(float[] ... sequences) {
        if (sequences.length == 0) {
            throw new IllegalArgumentException("sequences.length == 0");
        }
        IntervalPartition[] partitions = new IntervalPartition[sequences.length];
        for (int i = 0; i < partitions.length; ++i) {
            partitions[i] = new IntervalPartition(sequences[i]);
        }
        return partitions;
    }

    public final int getCardinal() {
        return this.sequence.length;
    }

    public final double get(int i) {
        return this.sequence[i];
    }

    public final double[] getSequence() {
        return (double[])this.sequence.clone();
    }

    public final double getMax() {
        return this.monotonicity > 0 ? this.sequence[this.sequence.length - 1] : this.sequence[0];
    }

    public final double getMin() {
        return this.monotonicity > 0 ? this.sequence[0] : this.sequence[this.sequence.length - 1];
    }

    public final double getMesh() {
        double mesh = 0.0;
        for (int i = 1; i < this.sequence.length; ++i) {
            double length = Math.abs(this.sequence[i] - this.sequence[i - 1]);
            if (!(length > mesh)) continue;
            mesh = length;
        }
        return mesh;
    }

    static int ensureStrictMonotonicity(Array sequence) throws IllegalArgumentException {
        int monotonicity = 0;
        for (int i = 1; i < sequence.getLength(); ++i) {
            if (sequence.getValue(i - 1) < sequence.getValue(i)) {
                ++monotonicity;
            } else if (sequence.getValue(i - 1) > sequence.getValue(i)) {
                --monotonicity;
            }
            if (Math.abs(monotonicity) == i) continue;
            throw new IllegalArgumentException("sequence is not strictly monotonous");
        }
        return monotonicity;
    }

    public final int getMonotonicity() {
        return this.monotonicity;
    }
}

