/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.math.Approximator;
import org.esa.snap.core.util.math.FXY;

public class FXYSum {
    public static final FXY[] FXY_LINEAR = new FXY[]{FXY.ONE, FXY.X, FXY.Y};
    public static final FXY[] FXY_BI_LINEAR = new FXY[]{FXY.ONE, FXY.X, FXY.Y, FXY.XY};
    public static final FXY[] FXY_QUADRATIC = new FXY[]{FXY.ONE, FXY.X, FXY.Y, FXY.X2, FXY.XY, FXY.Y2};
    public static final FXY[] FXY_BI_QUADRATIC = new FXY[]{FXY.ONE, FXY.X, FXY.Y, FXY.X2, FXY.XY, FXY.Y2, FXY.X2Y, FXY.XY2, FXY.X2Y2};
    public static final FXY[] FXY_CUBIC = new FXY[]{FXY.ONE, FXY.X, FXY.Y, FXY.X2, FXY.XY, FXY.Y2, FXY.X3, FXY.X2Y, FXY.XY2, FXY.Y3};
    public static final FXY[] FXY_BI_CUBIC = new FXY[]{FXY.ONE, FXY.X, FXY.Y, FXY.X2, FXY.XY, FXY.Y2, FXY.X3, FXY.X2Y, FXY.XY2, FXY.Y3, FXY.X3Y, FXY.X2Y2, FXY.XY3, FXY.X3Y2, FXY.X2Y3, FXY.X3Y3};
    public static final FXY[] FXY_4TH = new FXY[]{FXY.ONE, FXY.X, FXY.Y, FXY.X2, FXY.XY, FXY.Y2, FXY.X3, FXY.X2Y, FXY.XY2, FXY.Y3, FXY.X4, FXY.X3Y, FXY.X2Y2, FXY.XY3, FXY.Y4};
    public static final FXY[] FXY_BI_4TH = new FXY[]{FXY.ONE, FXY.X, FXY.Y, FXY.X2, FXY.XY, FXY.Y2, FXY.X3, FXY.X2Y, FXY.XY2, FXY.Y3, FXY.X4, FXY.X3Y, FXY.X2Y2, FXY.XY3, FXY.Y4, FXY.X4Y, FXY.X3Y2, FXY.X2Y3, FXY.XY4, FXY.X4Y2, FXY.X3Y3, FXY.X2Y4, FXY.X4Y3, FXY.X3Y4, FXY.X4Y4};
    private final FXY[] _f;
    private final double[] _c;
    private final int _order;
    private double[] _errorStatistics;

    public static FXYSum createFXYSum(int order, double[] coefficients) {
        FXYSum sum;
        switch (order) {
            case 1: {
                if (coefficients.length == 3) {
                    sum = new Linear(coefficients);
                    break;
                }
                sum = null;
                break;
            }
            case 2: {
                if (coefficients.length == 4) {
                    sum = new BiLinear(coefficients);
                    break;
                }
                if (coefficients.length == 6) {
                    sum = new Quadric(coefficients);
                    break;
                }
                sum = null;
                break;
            }
            case 3: {
                if (coefficients.length == 10) {
                    sum = new Cubic(coefficients);
                    break;
                }
                sum = null;
                break;
            }
            case 4: {
                if (coefficients.length == 9) {
                    sum = new BiQuadric(coefficients);
                    break;
                }
                sum = null;
                break;
            }
            case 6: {
                if (coefficients.length == 16) {
                    sum = new BiCubic(coefficients);
                    break;
                }
                sum = null;
                break;
            }
            default: {
                sum = null;
            }
        }
        return sum;
    }

    public static FXYSum createCopy(FXYSum fxySum) {
        double[] coefficients = new double[fxySum.getCoefficients().length];
        System.arraycopy(fxySum.getCoefficients(), 0, coefficients, 0, coefficients.length);
        FXYSum fxySumCopy = new FXYSum(fxySum.getFunctions(), fxySum.getOrder(), coefficients);
        return fxySumCopy;
    }

    public FXYSum(FXY[] functions) {
        this(functions, -1);
    }

    public FXYSum(FXY[] functions, int order) {
        this(functions, order, null);
    }

    public FXYSum(FXY[] functions, int order, double[] coefficients) {
        if (functions == null || functions.length == 0) {
            throw new IllegalArgumentException("'functions' is null or empty");
        }
        this._f = functions;
        if (coefficients == null) {
            this._c = new double[functions.length];
        } else {
            if (functions.length != coefficients.length) {
                throw new IllegalArgumentException("'functions.length' != 'coefficients.length'");
            }
            this._c = coefficients;
        }
        this._order = order;
    }

    public final int getNumTerms() {
        return this._f.length;
    }

    public final FXY[] getFunctions() {
        return this._f;
    }

    public final double[] getCoefficients() {
        return this._c;
    }

    public int getOrder() {
        return this._order;
    }

    public double getRootMeanSquareError() {
        return this._errorStatistics[0];
    }

    public double getMaxError() {
        return this._errorStatistics[1];
    }

    public double computeZ(double x, double y) {
        return FXYSum.computeZ(this._f, this._c, x, y);
    }

    public static double computeZ(FXY[] f, double[] c, double x, double y) {
        int n = f.length;
        double z = 0.0;
        for (int i = 0; i < n; ++i) {
            z += c[i] * f[i].f(x, y);
        }
        return z;
    }

    public void approximate(double[][] data, int[] indices) {
        Approximator.approximateFXY(data, indices, this._f, this._c);
        this._errorStatistics = Approximator.computeErrorStatistics(data, indices, this._f, this._c);
    }

    public String createCFunctionCode(String fname, String x, String y) {
        StringBuffer sb = new StringBuffer(256 + this.getNumTerms() * 10);
        this.appendCFunctionCodeStart(fname, x, y, sb);
        this.appendCFunctionCodeBody(fname, x, y, sb);
        this.appendCFunctionCodeEnd(fname, x, y, sb);
        return sb.toString();
    }

    protected void appendCFunctionCodeStart(String fname, String x, String y, StringBuffer sb) {
        double[] c = this.getCoefficients();
        sb.append("double " + fname + "(double " + x + ", double " + y + ") {\n");
        sb.append("    static double c[" + c.length + "] = {\n");
        for (int i = 0; i < c.length; ++i) {
            sb.append("        ");
            sb.append(c[i]);
            sb.append(i < c.length - 1 ? ",\n" : "};\n");
        }
    }

    protected void appendCFunctionCodeBody(String fname, String x, String y, StringBuffer sb) {
        sb.append("    return\n");
        FXY[] funcs = this.getFunctions();
        for (int i = 0; i < funcs.length; ++i) {
            FXY func = funcs[i];
            sb.append("    c[" + i + "] * ");
            this.appendCFunctionCodePart(sb, func.getCCodeExpr(), x, y);
            sb.append(i < funcs.length - 1 ? " +\n" : ";\n");
        }
    }

    protected void appendCFunctionCodeEnd(String fname, String x, String y, StringBuffer sb) {
        sb.append("}\n");
    }

    protected void appendCFunctionCodePart(StringBuffer sb, String part, String x, String y) {
        sb.append(part.replaceAll("x", x).replaceAll("y", y));
    }

    public static final class BiCubic
    extends FXYSum {
        public BiCubic() {
            super(FXY_BI_CUBIC, 6);
        }

        public BiCubic(double[] coefficients) {
            super(FXY_BI_CUBIC, 6, coefficients);
        }

        @Override
        public double computeZ(double x, double y) {
            double[] c = this.getCoefficients();
            return c[0] + (c[1] + (c[3] + (c[6] + (c[10] + (c[13] + c[15] * y) * y) * y) * x + (c[7] + (c[11] + c[14] * y) * y) * y) * x + (c[4] + (c[8] + c[12] * y) * y) * y) * x + (c[2] + (c[5] + c[9] * y) * y) * y;
        }
    }

    public static final class Cubic
    extends FXYSum {
        public Cubic() {
            super(FXY_CUBIC, 3);
        }

        public Cubic(double[] coefficients) {
            super(FXY_CUBIC, 3, coefficients);
        }

        @Override
        public double computeZ(double x, double y) {
            double[] c = this.getCoefficients();
            return c[0] + (c[1] + (c[3] + c[6] * x + c[7] * y) * x + (c[4] + c[8] * y) * y) * x + (c[2] + (c[5] + c[9] * y) * y) * y;
        }
    }

    public static final class BiQuadric
    extends FXYSum {
        public BiQuadric() {
            super(FXY_BI_QUADRATIC, 4);
        }

        public BiQuadric(double[] coefficients) {
            super(FXY_BI_QUADRATIC, 4, coefficients);
        }

        @Override
        public double computeZ(double x, double y) {
            double[] c = this.getCoefficients();
            return c[0] + (c[1] + (c[3] + (c[6] + c[8] * y) * y) * x + (c[4] + c[7] * y) * y) * x + (c[2] + c[5] * y) * y;
        }
    }

    public static final class Quadric
    extends FXYSum {
        public Quadric() {
            super(FXY_QUADRATIC, 2);
        }

        public Quadric(double[] coefficients) {
            super(FXY_QUADRATIC, 2, coefficients);
        }

        @Override
        public double computeZ(double x, double y) {
            double[] c = this.getCoefficients();
            return c[0] + (c[1] + c[3] * x + c[4] * y) * x + (c[2] + c[5] * y) * y;
        }
    }

    public static final class BiLinear
    extends FXYSum {
        public BiLinear() {
            super(FXY_BI_LINEAR, 2);
        }

        public BiLinear(double[] coefficients) {
            super(FXY_BI_LINEAR, 2, coefficients);
        }

        @Override
        public double computeZ(double x, double y) {
            double[] c = this.getCoefficients();
            return c[0] + (c[1] + c[3] * y) * x + c[2] * y;
        }
    }

    public static final class Linear
    extends FXYSum {
        public Linear() {
            super(FXY_LINEAR, 1);
        }

        public Linear(double[] coefficients) {
            super(FXY_LINEAR, 1, coefficients);
        }

        @Override
        public double computeZ(double x, double y) {
            double[] c = this.getCoefficients();
            return c[0] + c[1] * x + c[2] * y;
        }
    }
}

