/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.ProductIOPlugIn;
import org.esa.snap.core.util.StringUtils;

public class SnapFileFilter
extends FileFilter {
    private String formatName;
    private String[] extensions;
    private String description;

    public SnapFileFilter() {
    }

    public SnapFileFilter(String formatName, String extension, String description) {
        this(formatName, StringUtils.toStringArray(extension, ","), description);
    }

    public SnapFileFilter(String formatName, String[] extensions, String description) {
        this.setFormatName(formatName);
        this.setExtensions(extensions);
        this.setDescription(description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapFileFilter that = (SnapFileFilter)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!Arrays.equals(this.extensions, that.extensions)) {
            return false;
        }
        return !(this.formatName != null ? !this.formatName.equals(that.formatName) : that.formatName != null);
    }

    public int hashCode() {
        int result = this.formatName != null ? this.formatName.hashCode() : 0;
        result = 31 * result + (this.extensions != null ? Arrays.hashCode(this.extensions) : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.length > 0;
    }

    public String getDefaultExtension() {
        return this.hasExtensions() ? this.getExtensions()[0] : null;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        if (extensions != null) {
            ArrayList<Object> extensionList = new ArrayList<Object>();
            for (String extension : extensions) {
                if (extension.startsWith(".")) {
                    extensionList.add(extension);
                    continue;
                }
                if (extension.trim().length() <= 0) continue;
                extensionList.add("." + extension);
            }
            this.extensions = extensionList.toArray(new String[extensionList.size()]);
        } else {
            this.extensions = null;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (this.hasExtensions() && !description.endsWith(")")) {
            StringBuilder sb = new StringBuilder(description);
            sb.append(" (");
            for (int i = 0; i < this.extensions.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("*");
                if (this.extensions[i] == null) continue;
                sb.append(this.extensions[i]);
            }
            sb.append(")");
            this.description = sb.toString();
        } else {
            this.description = description;
        }
    }

    public boolean checkExtension(File file) {
        return file != null && this.checkExtension(file.getName());
    }

    public boolean checkExtension(String filename) {
        return SnapFileFilter.checkExtensions(filename, this.extensions);
    }

    public static boolean checkExtensions(String filename, String[] extensions) {
        if (filename != null) {
            filename = filename.toLowerCase();
            for (String extension : extensions) {
                if (!filename.endsWith(extension = extension.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (!this.hasExtensions()) {
            return true;
        }
        if (file.isDirectory()) {
            return true;
        }
        return this.checkExtension(file);
    }

    public boolean isCompoundDocument(File dir) {
        return false;
    }

    public FileSelectionMode getFileSelectionMode() {
        return FileSelectionMode.FILES_ONLY;
    }

    public static <T extends ProductIOPlugIn> List<SnapFileFilter> getSortedFileFilters(Iterator<T> pluginIterator) {
        HashSet<SnapFileFilter> fileFilterSet = new HashSet<SnapFileFilter>();
        while (pluginIterator.hasNext()) {
            SnapFileFilter productFileFilter = ((ProductIOPlugIn)pluginIterator.next()).getProductFileFilter();
            if (productFileFilter == null) continue;
            fileFilterSet.add(productFileFilter);
        }
        ArrayList<SnapFileFilter> fileFilterList = new ArrayList<SnapFileFilter>(fileFilterSet);
        Collections.sort(fileFilterList, (bff1, bff2) -> bff1.getDescription().compareTo(bff2.getDescription()));
        return fileFilterList;
    }

    public static enum FileSelectionMode {
        FILES_ONLY(0),
        DIRECTORIES_ONLY(1),
        FILES_AND_DIRECTORIES(2);

        private final int value;

        private FileSelectionMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

