/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.grid.isin;

import org.esa.snap.core.util.grid.isin.IsinDef;
import org.esa.snap.core.util.grid.isin.IsinForward;
import org.esa.snap.core.util.grid.isin.IsinInverse;
import org.esa.snap.core.util.grid.isin.IsinPoint;
import org.esa.snap.core.util.grid.isin.PGS_GCT_Init;
import org.esa.snap.core.util.grid.isin.ProjectionParam;

class Tile {
    private static final double MAP_EPS2 = 0.0275;
    private long nl;
    private long ns;
    private long nl_tile;
    private long ns_tile;
    private long nl_offset;
    private long ns_offset;
    private long nl_p;
    private long ns_p;
    private double siz_x;
    private double siz_y;
    private double inv_siz_x;
    private double inv_siz_y;
    private double ul_x;
    private double ul_y;
    private IsinForward forward;
    private IsinInverse inverse;

    Tile() {
    }

    void setNl(long nl) {
        this.nl = nl;
    }

    long getNl() {
        return this.nl;
    }

    void setNs(long ns) {
        this.ns = ns;
    }

    long getNs() {
        return this.ns;
    }

    void setNl_tile(long nl_tile) {
        this.nl_tile = nl_tile;
    }

    long getNl_tile() {
        return this.nl_tile;
    }

    void setNs_tile(long ns_tile) {
        this.ns_tile = ns_tile;
    }

    long getNs_tile() {
        return this.ns_tile;
    }

    void setNl_offset(long nl_offset) {
        this.nl_offset = nl_offset;
    }

    long getNl_offset() {
        return this.nl_offset;
    }

    void setNs_offset(long ns_offset) {
        this.ns_offset = ns_offset;
    }

    long getNs_offset() {
        return this.ns_offset;
    }

    void setNl_p(long nl_p) {
        this.nl_p = nl_p;
    }

    long getNl_p() {
        return this.nl_p;
    }

    void setNs_p(long ns_p) {
        this.ns_p = ns_p;
    }

    long getNs_p() {
        return this.ns_p;
    }

    void setSiz_x(double siz_x) {
        this.siz_x = siz_x;
    }

    double getSiz_x() {
        return this.siz_x;
    }

    void setSiz_y(double siz_y) {
        this.siz_y = siz_y;
    }

    double getSiz_y() {
        return this.siz_y;
    }

    void setUl_x(double ul_x) {
        this.ul_x = ul_x;
    }

    double getUl_x() {
        return this.ul_x;
    }

    void setUl_y(double ul_y) {
        this.ul_y = ul_y;
    }

    double getUl_y() {
        return this.ul_y;
    }

    void init(ProjectionParam params) {
        double[] projParam = new double[13];
        projParam[0] = params.sphere;
        int pixel_size_ratio = 0;
        switch (params.projection) {
            case ISIN_K: {
                long nrow_half = 10800L;
                projParam[8] = (double)nrow_half * 2.0;
                projParam[10] = 1.0;
                pixel_size_ratio = 1;
                break;
            }
            case ISIN_H: {
                long nrow_half = 21600L;
                projParam[8] = (double)nrow_half * 2.0;
                projParam[10] = 1.0;
                pixel_size_ratio = 2;
                break;
            }
            case ISIN_Q: {
                long nrow_half = 43200L;
                projParam[8] = (double)nrow_half * 2.0;
                projParam[10] = 1.0;
                pixel_size_ratio = 4;
            }
        }
        this.nl = params.nl_grid * pixel_size_ratio;
        this.ns = params.ns_grid * pixel_size_ratio;
        this.nl_tile = params.nl_tile * pixel_size_ratio;
        this.ns_tile = params.ns_tile * pixel_size_ratio;
        this.nl_offset = 0L;
        this.ns_offset = 0L;
        this.nl_p = this.nl;
        this.ns_p = this.ns;
        this.siz_y = this.siz_x = params.pixel_size / (double)pixel_size_ratio;
        this.inv_siz_x = 1.0 / this.siz_x;
        this.inv_siz_y = 1.0 / this.siz_y;
        this.ul_x = params.ul_xul + 0.5 * this.siz_x;
        this.ul_y = params.ul_yul - 0.5 * this.siz_y;
        this.forward = PGS_GCT_Init.forward(projParam);
        this.inverse = PGS_GCT_Init.reverse(projParam);
    }

    IsinPoint forwardTileImage(double lon, double lat) {
        IsinPoint transformed = this.forward.transform(new IsinPoint(lon, lat));
        IsinPoint invMapped = this.invMap(transformed);
        return this.invPix(invMapped);
    }

    IsinPoint inverseTileImage(double x, double y, int tileH, int tileV) {
        IsinPoint mapTiledPoint = new IsinPoint(x, y, tileH, tileV);
        IsinPoint globalMapPoint = this.fwdPix(mapTiledPoint);
        IsinPoint globalTiledPoint = this.fwdMap(globalMapPoint);
        return this.inverse.transform(globalTiledPoint);
    }

    IsinPoint forwardGlobalMap(double lon, double lat) {
        return this.forward.transform(new IsinPoint(lon, lat));
    }

    IsinPoint inverseGlobalMap(double x, double y) {
        return this.inverse.transform(new IsinPoint(x, y));
    }

    static IsinDef getIsinDef(long nrow_half, double sphere) {
        double half_pi = 1.5707963267948966;
        IsinDef isinDef = new IsinDef();
        isinDef.nrow_half = nrow_half;
        isinDef.nrow = 2L * nrow_half;
        isinDef.sphere_inv = 1.0 / sphere;
        isinDef.ang_size_inv = (double)isinDef.nrow / Math.PI;
        isinDef.icol_cen = new long[(int)nrow_half];
        isinDef.ncol_inv = new double[(int)isinDef.nrow];
        long ncol_cen = 0L;
        int irow = 0;
        while ((long)irow < nrow_half) {
            double clat = 1.5707963267948966 * (1.0 - ((double)irow + 0.5) / (double)nrow_half);
            long ncol = (long)(2.0 * Math.cos(clat) * (double)isinDef.nrow + 0.5);
            if (ncol < 1L) {
                ncol = 1L;
            }
            isinDef.icol_cen[irow] = (ncol + 1L) / 2L;
            isinDef.ncol_inv[irow] = 1.0 / (double)ncol;
            ncol_cen = ncol;
            ++irow;
        }
        isinDef.col_dist_inv = (double)ncol_cen / (Math.PI * 2 * sphere);
        return isinDef;
    }

    private IsinPoint invMap(IsinPoint isinPoint) {
        double line_global = (this.ul_y - isinPoint.getY()) * this.inv_siz_y - (double)this.nl_offset;
        double samp_global = (isinPoint.getX() - this.ul_x) * this.inv_siz_x - (double)this.ns_offset;
        return new IsinPoint(samp_global, line_global);
    }

    private IsinPoint fwdMap(IsinPoint isinPoint) {
        double samp_global = isinPoint.getX();
        double line_global = isinPoint.getY();
        double y = this.ul_y - (line_global + (double)this.nl_offset) * this.siz_y;
        double x = this.ul_x + (samp_global + (double)this.ns_offset) * this.siz_x;
        return new IsinPoint(x, y);
    }

    private IsinPoint invPix(IsinPoint isinPoint) {
        long isamp_global;
        double samp_global = isinPoint.getX();
        double line_global = isinPoint.getY();
        if (line_global < -0.5275 || line_global > (double)this.nl - 0.5 + 0.0275) {
            throw new RuntimeException("Map line out of range: " + line_global);
        }
        if (samp_global < -0.5275 || samp_global > (double)this.ns - 0.5 + 0.0275) {
            throw new RuntimeException("Map row out of range: " + samp_global);
        }
        long iline_global = (long)(line_global + 0.5);
        if (iline_global >= this.nl_p) {
            iline_global = this.nl - 1L;
        }
        if (iline_global < 0L) {
            iline_global = 0L;
        }
        if ((isamp_global = (long)(samp_global + 0.5)) >= this.ns_p) {
            isamp_global = this.ns - 1L;
        }
        if (isamp_global < 0L) {
            isamp_global = 0L;
        }
        int itile_line = (int)(iline_global / this.nl_tile);
        int itile_samp = (int)(isamp_global / this.ns_tile);
        double line = line_global - (double)((long)itile_line * this.nl_tile);
        double samp = samp_global - (double)((long)itile_samp * this.ns_tile);
        return new IsinPoint(samp, line, itile_samp, itile_line);
    }

    private IsinPoint fwdPix(IsinPoint isinPoint) {
        int tile_line = isinPoint.getTile_line();
        int tile_col = isinPoint.getTile_col();
        double samp = isinPoint.getX();
        double line = isinPoint.getY();
        if (line < -0.5 || line > (double)this.nl_tile - 0.5 || samp < -0.5 || samp > (double)this.ns_tile - 0.5) {
            throw new IllegalArgumentException("tile coordinates out of range");
        }
        double line_global = line + (double)(this.nl_tile * (long)tile_line);
        double samp_global = samp + (double)(this.ns_tile * (long)tile_col);
        return new IsinPoint(samp_global, line_global);
    }
}

