/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.grid.isin;

import org.esa.snap.core.util.grid.isin.IsinPoint;
import org.esa.snap.core.util.grid.isin.ProjectionParam;
import org.esa.snap.core.util.grid.isin.ProjectionParamFactory;
import org.esa.snap.core.util.grid.isin.ProjectionType;
import org.esa.snap.core.util.grid.isin.Tile;

public class IsinAPI {
    private final Tile tile;
    static final double TO_RAD = Math.PI / 180;
    private static final double TO_DEG = 57.29577951308232;

    public IsinAPI(Raster raster) {
        ProjectionParam projectionParam = IsinAPI.getProjectionParam(raster);
        this.tile = new Tile();
        this.tile.init(projectionParam);
    }

    public IsinPoint toGlobalMap(double lon, double lat) {
        return this.tile.forwardGlobalMap(lon * (Math.PI / 180), lat * (Math.PI / 180));
    }

    public IsinPoint globalMapToGeo(double x, double y) {
        IsinPoint isinPoint = this.tile.inverseGlobalMap(x, y);
        return new IsinPoint(isinPoint.getX() * 57.29577951308232, isinPoint.getY() * 57.29577951308232);
    }

    public IsinPoint tileImageCoordinatesToGeo(double x, double y, int tileH, int tileV) {
        IsinPoint isinPoint = this.tile.inverseTileImage(x, y, tileH, tileV);
        return new IsinPoint(isinPoint.getX() * 57.29577951308232, isinPoint.getY() * 57.29577951308232);
    }

    public IsinPoint toTileImageCoordinates(double lon, double lat) {
        return this.tile.forwardTileImage(lon * (Math.PI / 180), lat * (Math.PI / 180));
    }

    public IsinPoint getTileDimensions() {
        long tile_height = this.tile.getNl_tile();
        long tile_width = this.tile.getNs_tile();
        return new IsinPoint(tile_width, tile_height);
    }

    static ProjectionParam getProjectionParam(Raster raster) {
        ProjectionType projectionType;
        if (raster == Raster.GRID_1_KM) {
            projectionType = ProjectionType.ISIN_K;
        } else if (raster == Raster.GRID_500_M) {
            projectionType = ProjectionType.ISIN_H;
        } else if (raster == Raster.GRID_250_M) {
            projectionType = ProjectionType.ISIN_Q;
        } else {
            throw new RuntimeException("Illegal projection type");
        }
        return ProjectionParamFactory.get(projectionType);
    }

    public static enum Raster {
        GRID_1_KM,
        GRID_500_M,
        GRID_250_M;

    }
}

