/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.geotiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.GeoTIFFTagSet;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.core.util.geotiff.IIOUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.Parent;
import org.jdom2.input.DOMBuilder;
import org.jdom2.output.DOMOutputter;
import org.w3c.dom.Element;

public class GeoTIFF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeImage(RenderedImage image, File outputFile, GeoTIFFMetadata geoTIFFMetadata) throws IOException {
        ImageOutputStream stream;
        if (outputFile == null) {
            throw new IllegalArgumentException("outputFile == null!");
        }
        outputFile.delete();
        try {
            stream = ImageIO.createImageOutputStream(outputFile);
        }
        catch (IIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IIOException("Failed to create TIFF output stream.", e);
        }
        boolean writerFound = false;
        try {
            writerFound = GeoTIFF.writeImage(image, stream, geoTIFFMetadata);
        }
        finally {
            stream.close();
        }
        return writerFound;
    }

    public static boolean writeImage(RenderedImage image, ImageOutputStream outputStream, GeoTIFFMetadata geoTIFFMetadata) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream == null!");
        }
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
        ImageWriter writer = GeoTIFF.getImageWriter(type);
        if (writer == null) {
            return false;
        }
        writer.setOutput(outputStream);
        writer.write(GeoTIFF.createIIOImage(writer, image, geoTIFFMetadata));
        outputStream.flush();
        writer.dispose();
        return true;
    }

    public static ImageWriter getImageWriter(RenderedImage image) {
        return GeoTIFF.getImageWriter(ImageTypeSpecifier.createFromRenderedImage(image));
    }

    public static ImageWriter getImageWriter(ImageTypeSpecifier imageType) {
        return IIOUtils.getImageWriter(imageType, "TIFF", "com_sun_media_imageio_plugins_tiff_image_1.0");
    }

    public static IIOImage createIIOImage(ImageWriter writer, RenderedImage im, GeoTIFFMetadata geoTIFFMetadata) throws IIOException {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(im);
        return new IIOImage(im, null, GeoTIFF.createIIOMetadata(writer, type, geoTIFFMetadata));
    }

    public static IIOMetadata createIIOMetadata(ImageWriter writer, ImageTypeSpecifier type, GeoTIFFMetadata geoTIFFMetadata) throws IIOException {
        String classnameList = BaselineTIFFTagSet.class.getName() + "," + GeoTIFFTagSet.class.getName();
        return GeoTIFF.createIIOMetadata(writer, type, geoTIFFMetadata, "com_sun_media_imageio_plugins_tiff_image_1.0", classnameList);
    }

    public static IIOMetadata createIIOMetadata(ImageWriter writer, ImageTypeSpecifier type, GeoTIFFMetadata geoTIFFMetadata, String metadataFormatName, String classNameList) throws IIOException {
        IIOMetadata imageMetadata = writer.getDefaultImageMetadata(type, null);
        Element w3cElement = (Element)imageMetadata.getAsTree(metadataFormatName);
        org.jdom2.Element element = new DOMBuilder().build(w3cElement);
        if (Debug.isEnabled()) {
            Debug.trace("Dumping original TIFF metadata tree:\n" + StringUtils.toXMLString(element));
        }
        geoTIFFMetadata.assignTo(element, metadataFormatName, classNameList);
        if (Debug.isEnabled()) {
            Debug.trace("Dumping modified GeoTIFF metadata tree:\n" + StringUtils.toXMLString(element));
        }
        Parent parent = element.getParent();
        parent.removeContent((Content)element);
        Document document = new Document(element);
        try {
            org.w3c.dom.Document w3cDoc = new DOMOutputter().output(document);
            imageMetadata.setFromTree(metadataFormatName, w3cDoc.getDocumentElement());
        }
        catch (JDOMException e) {
            throw new IIOException("Failed to set GeoTIFF specific tags.", e);
        }
        catch (IIOInvalidTreeException e) {
            throw new IIOException("Failed to set GeoTIFF specific tags.", e);
        }
        return imageMetadata;
    }
}

