/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.ResourceLocator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Config;

public class ServiceFinder {
    private final String servicesPath;
    private final List<Path> searchPaths;
    private boolean useClassPath;
    private boolean useZipFiles;

    public ServiceFinder(Class serviceType) {
        this(serviceType.getName());
    }

    public ServiceFinder(String serviceName) {
        this.servicesPath = "META-INF/services/" + serviceName;
        this.searchPaths = new ArrayList<Path>();
    }

    private static Path subtract(Path resourcePath, int nameCount) {
        Path moduleRoot = resourcePath;
        for (int i = 0; i < nameCount; ++i) {
            moduleRoot = moduleRoot.resolve("..");
        }
        moduleRoot = moduleRoot.normalize();
        return moduleRoot;
    }

    public String getServicesPath() {
        return this.servicesPath;
    }

    public boolean getUseClassPath() {
        return this.useClassPath;
    }

    public void setUseClassPath(boolean value) {
        this.useClassPath = value;
    }

    public boolean getUseZipFiles() {
        return this.useZipFiles;
    }

    public void setUseZipFiles(boolean value) {
        this.useZipFiles = value;
    }

    public List<Path> getSearchPaths() {
        return Collections.unmodifiableList(this.searchPaths);
    }

    public void addSearchPath(Path path) {
        this.searchPaths.add(path);
    }

    public void addSearchPaths(Path ... paths) {
        this.searchPaths.addAll(Arrays.asList(paths));
    }

    public void addSearchPathsFromPreferences(String configName, String key) {
        this.addSearchPathsFromPreferencesValue(Config.instance((String)configName).preferences().get(key, null));
    }

    public void addSearchPathsFromPreferences(String key) {
        this.addSearchPathsFromPreferencesValue(Config.instance().preferences().get(key, null));
    }

    public List<Module> findServices() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Path directory : this.searchPaths) {
            this.scanPath(directory, modules);
        }
        if (this.useClassPath) {
            this.scanClassPath(modules);
        }
        return modules;
    }

    private void addSearchPathsFromPreferencesValue(String extraPaths) {
        if (extraPaths != null) {
            this.addSearchPaths((Path[])Stream.of(extraPaths.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new));
        }
    }

    private void scanPath(Path path, List<Module> modules) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.scanDirectory(path, modules);
        } else {
            SystemUtils.LOG.warning("Can't search for SPIs, not a directory: " + path);
        }
    }

    private void scanDirectory(Path directory, List<Module> modules) {
        try {
            SystemUtils.LOG.fine("Searching for SPIs " + this.servicesPath + " in " + directory);
            Files.list(directory).forEach(entry -> {
                String extension;
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    this.parseServiceRegistry(entry.resolve(this.servicesPath), modules);
                } else if (this.useZipFiles && (".jar".compareToIgnoreCase(extension = FileUtils.getExtension(entry.toString())) == 0 || ".zip".compareToIgnoreCase(extension) == 0)) {
                    try (FileSystem fs = FileSystems.newFileSystem(entry, null);){
                        this.parseServiceRegistry(fs.getPath(this.servicesPath, new String[0]), modules);
                    }
                    catch (IOException e) {
                        SystemUtils.LOG.log(Level.SEVERE, "Failed to open file : " + entry, e);
                    }
                }
            });
        }
        catch (IOException e) {
            SystemUtils.LOG.log(Level.SEVERE, "Failed to list directory: " + directory, e);
        }
    }

    private void scanClassPath(List<Module> modules) {
        SystemUtils.LOG.fine("Searching for SPIs " + this.servicesPath + " in Java class path");
        Collection resources = ResourceLocator.getResources((String)this.servicesPath);
        resources.forEach(path -> this.parseServiceRegistry((Path)path, modules));
    }

    private void parseServiceRegistry(Path registryPath, List<Module> modules) {
        if (!Files.exists(registryPath, new LinkOption[0]) || !registryPath.endsWith(this.servicesPath)) {
            return;
        }
        Path moduleRoot = ServiceFinder.subtract(registryPath, Paths.get(this.servicesPath, new String[0]).getNameCount());
        ArrayList<String> services = new ArrayList<String>();
        try {
            Files.lines(registryPath).forEach(line -> {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    services.add((String)line);
                }
            });
        }
        catch (IOException e) {
            SystemUtils.LOG.log(Level.SEVERE, "Failed to parse service registry file " + registryPath, e);
        }
        if (!services.isEmpty()) {
            modules.add(new Module(moduleRoot, services));
        }
    }

    public static class Module {
        private final Path path;
        private final List<String> serviceNames;

        private Module(Path path, List<String> serviceNames) {
            this.path = path;
            this.serviceNames = serviceNames;
        }

        public Path getPath() {
            return this.path;
        }

        public List<String> getServiceNames() {
            return Collections.unmodifiableList(this.serviceNames);
        }
    }
}

