/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.support.BufferedImageRendering;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.DensityPlot;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductVisitorAdapter;
import org.esa.snap.core.datamodel.RGBChannelDef;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.SceneFactory;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.layer.MaskLayerType;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.GeoUtils;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.IntMap;
import org.esa.snap.core.util.geotiff.GeoCoding2GeoTIFFMetadata;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.Range;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ProductUtils {
    private static final int[] RGB_BAND_OFFSETS = new int[]{2, 1, 0};
    private static final int[] RGBA_BAND_OFFSETS = new int[]{3, 2, 1, 0};
    private static final String MSG_CREATING_IMAGE = "Creating image";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo createImageInfo(RasterDataNode[] rasters, boolean assignMissingImageInfos, ProgressMonitor pm) {
        Assert.notNull((Object)rasters, (String)"rasters");
        Assert.argument((rasters.length > 0 && rasters.length <= 3 ? 1 : 0) != 0, (String)"rasters.length > 0 && rasters.length <= 3");
        if (rasters.length == 1) {
            return assignMissingImageInfos ? rasters[0].getImageInfo(pm) : rasters[0].createDefaultImageInfo(null, pm);
        }
        try {
            pm.beginTask("Computing image information", 3);
            RGBChannelDef rgbChannelDef = new RGBChannelDef();
            for (int i = 0; i < rasters.length; ++i) {
                RasterDataNode raster = rasters[i];
                ProgressMonitor subPm = SubProgressMonitor.create((ProgressMonitor)pm, (int)1);
                ImageInfo imageInfo = assignMissingImageInfos ? raster.getImageInfo(subPm) : raster.createDefaultImageInfo(null, subPm);
                rgbChannelDef.setSourceName(i, raster.getName());
                rgbChannelDef.setMinDisplaySample(i, imageInfo.getColorPaletteDef().getMinDisplaySample());
                rgbChannelDef.setMaxDisplaySample(i, imageInfo.getColorPaletteDef().getMaxDisplaySample());
            }
            ImageInfo imageInfo = new ImageInfo(rgbChannelDef);
            return imageInfo;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createRgbImage(RasterDataNode[] rasters, ImageInfo imageInfo, ProgressMonitor pm) throws IOException {
        Assert.notNull((Object)rasters, (String)"rasters");
        Assert.argument((rasters.length == 1 || rasters.length == 2 || rasters.length == 3 ? 1 : 0) != 0, (String)"rasters.length == 1 || rasters.length == 2 || rasters.length == 3");
        RasterDataNode raster0 = rasters[0];
        ProductNodeGroup<Mask> maskGroup = raster0.getOverlayMaskGroup();
        pm.beginTask(MSG_CREATING_IMAGE, 6 + maskGroup.getNodeCount());
        try {
            BufferedImage overlayBIm = rasters.length == 1 ? ProductUtils.create1BandRgbImage(raster0, imageInfo, SubProgressMonitor.create((ProgressMonitor)pm, (int)3)) : ProductUtils.create3BandRgbImage(rasters, imageInfo, SubProgressMonitor.create((ProgressMonitor)pm, (int)3));
            if (maskGroup.getNodeCount() > 0) {
                overlayBIm = ProductUtils.overlayMasks(raster0, overlayBIm, SubProgressMonitor.create((ProgressMonitor)pm, (int)maskGroup.getNodeCount()));
            }
            BufferedImage bufferedImage = overlayBIm;
            return bufferedImage;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage create1BandRgbImage(RasterDataNode raster, ImageInfo imageInfo, ProgressMonitor pm) throws IOException {
        Assert.notNull((Object)raster, (String)"raster");
        Assert.notNull((Object)imageInfo, (String)"imageInfo");
        Assert.argument((imageInfo.getColorPaletteDef() != null ? 1 : 0) != 0, (String)"imageInfo.getColorPaletteDef() != null");
        Assert.notNull((Object)pm, (String)"pm");
        IndexCoding indexCoding = raster instanceof Band ? ((Band)raster).getIndexCoding() : null;
        int width = raster.getRasterWidth();
        int height = raster.getRasterHeight();
        int numPixels = width * height;
        int numColorComponents = imageInfo.getColorComponentCount();
        byte[] rgbSamples = new byte[numColorComponents * numPixels];
        double minSample = imageInfo.getColorPaletteDef().getMinDisplaySample();
        double maxSample = imageInfo.getColorPaletteDef().getMaxDisplaySample();
        pm.beginTask(MSG_CREATING_IMAGE, 100);
        try {
            Color[] palette;
            IndexValidator indexValidator;
            if (indexCoding == null) {
                raster.quantizeRasterData(minSample, maxSample, 1.0, rgbSamples, 0, numColorComponents, ProgressMonitor.NULL);
                indexValidator = raster::isPixelValid;
                palette = ImageManager.createColorPalette(raster.getImageInfo());
                pm.worked(50);
                ProductUtils.checkCanceled(pm);
            } else {
                IntMap sampleColorIndexMap = new IntMap((int)minSample - 1, 4098);
                ColorPaletteDef.Point[] points = imageInfo.getColorPaletteDef().getPoints();
                for (int colorIndex = 0; colorIndex < points.length; ++colorIndex) {
                    sampleColorIndexMap.putValue((int)points[colorIndex].getSample(), colorIndex);
                }
                int noDataIndex = points.length < 255 ? points.length + 1 : 0;
                ProductData data = raster.getRasterData();
                for (int pixelIndex2 = 0; pixelIndex2 < data.getNumElems(); ++pixelIndex2) {
                    int sample = data.getElemIntAt(pixelIndex2);
                    int colorIndex = sampleColorIndexMap.getValue(sample);
                    rgbSamples[pixelIndex2 * numColorComponents] = colorIndex != Integer.MIN_VALUE ? (byte)colorIndex : (byte)noDataIndex;
                }
                palette = raster.getImageInfo().getColors();
                if (noDataIndex > 0) {
                    palette = Arrays.copyOf(palette, palette.length + 1);
                    palette[palette.length - 1] = ImageInfo.NO_COLOR;
                }
                indexValidator = pixelIndex -> raster.isPixelValid(pixelIndex) && (noDataIndex == 0 || (rgbSamples[pixelIndex * numColorComponents] & 0xFF) != noDataIndex);
                pm.worked(50);
                ProductUtils.checkCanceled(pm);
            }
            ProductUtils.convertPaletteToRgbSamples(palette, imageInfo.getNoDataColor(), numColorComponents, rgbSamples, indexValidator);
            pm.worked(40);
            ProductUtils.checkCanceled(pm);
            BufferedImage image = ProductUtils.createBufferedImage(imageInfo, width, height, rgbSamples);
            image = ProductUtils.applyHistogramMatching(image, imageInfo.getHistogramMatching());
            pm.worked(10);
            ProductUtils.checkCanceled(pm);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            pm.done();
        }
    }

    private static void convertPaletteToRgbSamples(Color[] palette, Color noDataColor, int numColorComponents, byte[] rgbSamples, IndexValidator indexValidator) {
        byte[] r = new byte[palette.length];
        byte[] g = new byte[palette.length];
        byte[] b = new byte[palette.length];
        byte[] a = new byte[palette.length];
        for (int i = 0; i < palette.length; ++i) {
            r[i] = (byte)palette[i].getRed();
            g[i] = (byte)palette[i].getGreen();
            b[i] = (byte)palette[i].getBlue();
            a[i] = (byte)palette[i].getAlpha();
        }
        int pixelIndex = 0;
        for (int i = 0; i < rgbSamples.length; i += numColorComponents) {
            if (indexValidator.validateIndex(pixelIndex)) {
                int colorIndex = rgbSamples[i] & 0xFF;
                if (numColorComponents == 4) {
                    rgbSamples[i] = a[colorIndex];
                    rgbSamples[i + 1] = b[colorIndex];
                    rgbSamples[i + 2] = g[colorIndex];
                    rgbSamples[i + 3] = r[colorIndex];
                } else {
                    rgbSamples[i] = b[colorIndex];
                    rgbSamples[i + 1] = g[colorIndex];
                    rgbSamples[i + 2] = r[colorIndex];
                }
            } else if (numColorComponents == 4) {
                rgbSamples[i] = (byte)noDataColor.getAlpha();
                rgbSamples[i + 1] = (byte)noDataColor.getBlue();
                rgbSamples[i + 2] = (byte)noDataColor.getGreen();
                rgbSamples[i + 3] = (byte)noDataColor.getRed();
            } else {
                rgbSamples[i] = (byte)noDataColor.getBlue();
                rgbSamples[i + 1] = (byte)noDataColor.getGreen();
                rgbSamples[i + 2] = (byte)noDataColor.getRed();
            }
            ++pixelIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage create3BandRgbImage(RasterDataNode[] rasters, ImageInfo imageInfo, ProgressMonitor pm) throws IOException {
        Assert.notNull((Object)rasters, (String)"rasters");
        Assert.argument((rasters.length > 1 && rasters.length <= 3 ? 1 : 0) != 0, (String)"rasters.length == 2 or 3");
        Assert.notNull((Object)imageInfo, (String)"imageInfo");
        Assert.argument((imageInfo.getRgbChannelDef() != null ? 1 : 0) != 0, (String)"imageInfo.getRgbChannelDef() != null");
        Assert.notNull((Object)pm, (String)"pm");
        Color noDataColor = imageInfo.getNoDataColor();
        int width = rasters[0].getRasterWidth();
        int height = rasters[0].getRasterHeight();
        int numColorComponents = imageInfo.getColorComponentCount();
        int numPixels = width * height;
        byte[] rgbSamples = new byte[numColorComponents * numPixels];
        String[] taskMessages = new String[]{"Computing red channel", "Computing green channel", "Computing blue channel"};
        pm.beginTask(MSG_CREATING_IMAGE, 100);
        try {
            for (int i = 0; i < rasters.length; ++i) {
                RasterDataNode raster = rasters[i];
                pm.setSubTaskName(taskMessages[i]);
                raster.quantizeRasterData(imageInfo.getRgbChannelDef().getMinDisplaySample(i), imageInfo.getRgbChannelDef().getMaxDisplaySample(i), imageInfo.getRgbChannelDef().getGamma(i), rgbSamples, numColorComponents - 1 - i, numColorComponents, ProgressMonitor.NULL);
                pm.worked(30);
                ProductUtils.checkCanceled(pm);
            }
            boolean validMaskUsed = rasters[0].isValidMaskUsed() || rasters[1].isValidMaskUsed() || rasters.length > 2 && rasters[2].isValidMaskUsed();
            int pixelIndex = 0;
            for (int i = 0; i < rgbSamples.length; i += numColorComponents) {
                boolean pixelValid;
                boolean bl = pixelValid = !validMaskUsed || rasters[0].isPixelValid(pixelIndex) && rasters[1].isPixelValid(pixelIndex) && (rasters.length < 3 || rasters[2].isPixelValid(pixelIndex));
                if (pixelValid) {
                    if (numColorComponents == 4) {
                        rgbSamples[i] = -1;
                    }
                } else if (numColorComponents == 4) {
                    rgbSamples[i] = (byte)noDataColor.getAlpha();
                    rgbSamples[i + 1] = (byte)noDataColor.getBlue();
                    rgbSamples[i + 2] = (byte)noDataColor.getGreen();
                    rgbSamples[i + 3] = (byte)noDataColor.getRed();
                } else {
                    rgbSamples[i] = (byte)noDataColor.getBlue();
                    rgbSamples[i + 1] = (byte)noDataColor.getGreen();
                    rgbSamples[i + 2] = (byte)noDataColor.getRed();
                }
                ++pixelIndex;
            }
            pm.worked(5);
            ProductUtils.checkCanceled(pm);
            BufferedImage image = ProductUtils.createBufferedImage(imageInfo, width, height, rgbSamples);
            image = ProductUtils.applyHistogramMatching(image, imageInfo.getHistogramMatching());
            pm.worked(5);
            ProductUtils.checkCanceled(pm);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            pm.done();
        }
    }

    private static BufferedImage createBufferedImage(ImageInfo imageInfo, int width, int height, byte[] rgbSamples) {
        int colorComponentCount;
        ComponentColorModel cm = imageInfo.createComponentColorModel();
        DataBufferByte db = new DataBufferByte(rgbSamples, rgbSamples.length);
        WritableRaster wr = Raster.createInterleavedRaster(db, width, height, colorComponentCount * width, colorComponentCount, (colorComponentCount = imageInfo.getColorComponentCount()) == 4 ? RGBA_BAND_OFFSETS : RGB_BAND_OFFSETS, null);
        return new BufferedImage(cm, wr, false, null);
    }

    public static BufferedImage createColorIndexedImage(RasterDataNode rasterDataNode, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("rasterDataNode", rasterDataNode);
        int width = rasterDataNode.getRasterWidth();
        int height = rasterDataNode.getRasterHeight();
        ImageInfo imageInfo = rasterDataNode.getImageInfo(ProgressMonitor.NULL);
        double newMin = imageInfo.getColorPaletteDef().getMinDisplaySample();
        double newMax = imageInfo.getColorPaletteDef().getMaxDisplaySample();
        byte[] colorIndexes = rasterDataNode.quantizeRasterData(newMin, newMax, 1.0, pm);
        IndexColorModel cm = imageInfo.createIndexColorModel(rasterDataNode);
        SampleModel sm = cm.createCompatibleSampleModel(width, height);
        DataBufferByte db = new DataBufferByte(colorIndexes, colorIndexes.length);
        WritableRaster wr = WritableRaster.createWritableRaster(sm, db, null);
        return new BufferedImage(cm, wr, false, null);
    }

    private static BufferedImage applyHistogramMatching(BufferedImage overlayBIm, ImageInfo.HistogramMatching histogramMatching) {
        boolean doNormalize;
        boolean doEqualize = ImageInfo.HistogramMatching.Equalize == histogramMatching;
        boolean bl = doNormalize = ImageInfo.HistogramMatching.Normalize == histogramMatching;
        if (doEqualize || doNormalize) {
            PlanarImage sourcePIm = PlanarImage.wrapRenderedImage((RenderedImage)overlayBIm);
            sourcePIm = JAIUtils.createTileFormatOp((RenderedImage)sourcePIm, 512, 512);
            sourcePIm = doEqualize ? JAIUtils.createHistogramEqualizedImage(sourcePIm) : JAIUtils.createHistogramNormalizedImage(sourcePIm);
            overlayBIm = sourcePIm.getAsBufferedImage();
        }
        return overlayBIm;
    }

    private static void checkCanceled(ProgressMonitor pm) throws IOException {
        if (pm.isCanceled()) {
            throw new IOException("Process terminated by user.");
        }
    }

    public static void copyFlagCodings(Product source, Product target) {
        Guardian.assertNotNull("source", (Object)source);
        Guardian.assertNotNull("target", (Object)target);
        int numCodings = source.getFlagCodingGroup().getNodeCount();
        for (int n = 0; n < numCodings; ++n) {
            FlagCoding sourceFlagCoding = source.getFlagCodingGroup().get(n);
            ProductUtils.copyFlagCoding(sourceFlagCoding, target);
        }
    }

    public static FlagCoding copyFlagCoding(FlagCoding sourceFlagCoding, Product target) {
        FlagCoding flagCoding = target.getFlagCodingGroup().get(sourceFlagCoding.getName());
        if (flagCoding == null) {
            flagCoding = new FlagCoding(sourceFlagCoding.getName());
            flagCoding.setDescription(sourceFlagCoding.getDescription());
            target.getFlagCodingGroup().add(flagCoding);
            ProductUtils.copyMetadata(sourceFlagCoding, flagCoding);
        }
        return flagCoding;
    }

    public static void copyIndexCodings(Product source, Product target) {
        Guardian.assertNotNull("source", (Object)source);
        Guardian.assertNotNull("target", (Object)target);
        int numCodings = source.getIndexCodingGroup().getNodeCount();
        for (int n = 0; n < numCodings; ++n) {
            IndexCoding sourceFlagCoding = source.getIndexCodingGroup().get(n);
            ProductUtils.copyIndexCoding(sourceFlagCoding, target);
        }
    }

    public static void copyQuicklookBandName(Product source, Product target) {
        Guardian.assertNotNull("source", (Object)source);
        Guardian.assertNotNull("target", (Object)target);
        if (target.getQuicklookBandName() == null && source.getQuicklookBandName() != null && target.getBand(source.getQuicklookBandName()) != null) {
            target.setQuicklookBandName(source.getQuicklookBandName());
        }
    }

    public static IndexCoding copyIndexCoding(IndexCoding sourceIndexCoding, Product target) {
        IndexCoding indexCoding = target.getIndexCodingGroup().get(sourceIndexCoding.getName());
        if (indexCoding == null) {
            indexCoding = new IndexCoding(sourceIndexCoding.getName());
            indexCoding.setDescription(sourceIndexCoding.getDescription());
            target.getIndexCodingGroup().add(indexCoding);
            ProductUtils.copyMetadata(sourceIndexCoding, indexCoding);
        }
        return indexCoding;
    }

    public static void copyMasks(Product sourceProduct, Product targetProduct) {
        ProductNodeGroup<Mask> sourceMaskGroup = sourceProduct.getMaskGroup();
        for (int i = 0; i < sourceMaskGroup.getNodeCount(); ++i) {
            Mask mask = sourceMaskGroup.get(i);
            if (targetProduct.getMaskGroup().contains(mask.getName()) || !mask.getImageType().canTransferMask(mask, targetProduct)) continue;
            mask.getImageType().transferMask(mask, targetProduct);
        }
    }

    public static void copyMasks(Product sourceProduct, Product targetProduct, String[] sourceMaskNames) {
        double scaleX = (double)sourceProduct.getSceneRasterWidth() / (double)targetProduct.getSceneRasterWidth();
        double scaleY = (double)sourceProduct.getSceneRasterHeight() / (double)targetProduct.getSceneRasterHeight();
        GeoCoding sceneGeoCoding = sourceProduct.getSceneGeoCoding();
        AffineTransform referenceImageToModelTransform = null;
        if (sceneGeoCoding != null && sceneGeoCoding.getImageToMapTransform() instanceof AffineTransform) {
            AffineTransform mapTransform = (AffineTransform)sceneGeoCoding.getImageToMapTransform();
            referenceImageToModelTransform = new AffineTransform(scaleX * mapTransform.getScaleX(), 0.0, 0.0, scaleY * mapTransform.getScaleY(), mapTransform.getTranslateX(), mapTransform.getTranslateY());
        } else {
            referenceImageToModelTransform = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
        }
        ProductNodeGroup<Mask> sourceMaskGroup = sourceProduct.getMaskGroup();
        for (String sourceMaskName : sourceMaskNames) {
            Mask sourceMask = sourceMaskGroup.get(sourceMaskName);
            Mask.ImageType imageType = sourceMask.getImageType();
            if (imageType.getName().equals("Maths")) {
                String expression = Mask.BandMathsType.getExpression(sourceMask);
                Mask targetMask = Mask.BandMathsType.create(sourceMask.getName(), sourceMask.getDescription(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight(), expression, sourceMask.getImageColor(), sourceMask.getImageTransparency());
                targetProduct.addMask(targetMask);
                continue;
            }
            if (imageType.getName().equals("Geometry")) {
                VectorDataNode targetVectorDataNode;
                VectorDataNode vectorDataMaskNode = Mask.VectorDataType.getVectorData(sourceMask);
                String vectorDataNodeName = vectorDataMaskNode.getName();
                if (sourceProduct.getVectorDataGroup().get(vectorDataNodeName) != null || (targetVectorDataNode = ProductUtils.transferVectorDataNode(targetProduct, vectorDataMaskNode, referenceImageToModelTransform)) == null) continue;
                targetProduct.addMask(sourceMask.getName(), targetVectorDataNode, sourceMask.getDescription(), sourceMask.getImageColor(), sourceMask.getImageTransparency());
                continue;
            }
            if (!imageType.canTransferMask(sourceMask, targetProduct)) continue;
            imageType.transferMask(sourceMask, targetProduct);
        }
    }

    public static void copyOverlayMasks(Product sourceProduct, Product targetProduct) {
        for (TiePointGrid tiePointGrid : sourceProduct.getTiePointGrids()) {
            ProductUtils.copyOverlayMasks(tiePointGrid, targetProduct);
        }
        for (RasterDataNode rasterDataNode : sourceProduct.getBands()) {
            ProductUtils.copyOverlayMasks(rasterDataNode, targetProduct);
        }
    }

    private static void copyOverlayMasks(RasterDataNode sourceNode, Product targetProduct) {
        String[] maskNames = sourceNode.getOverlayMaskGroup().getNodeNames();
        RasterDataNode targetNode = targetProduct.getRasterDataNode(sourceNode.getName());
        if (targetNode != null) {
            ProductNodeGroup<Mask> overlayMaskGroup = targetNode.getOverlayMaskGroup();
            ProductNodeGroup<Mask> maskGroup = targetProduct.getMaskGroup();
            ProductUtils.addMasksToGroup(maskNames, maskGroup, overlayMaskGroup);
        }
    }

    private static void addMasksToGroup(String[] maskNames, ProductNodeGroup<Mask> maskGroup, ProductNodeGroup<Mask> specialMaskGroup) {
        for (String maskName : maskNames) {
            Mask mask = maskGroup.get(maskName);
            if (mask == null) continue;
            specialMaskGroup.add(mask);
        }
    }

    public static void copyFlagBands(Product sourceProduct, Product targetProduct, boolean copySourceImage) {
        Guardian.assertNotNull("source", (Object)sourceProduct);
        Guardian.assertNotNull("target", (Object)targetProduct);
        if (sourceProduct.getFlagCodingGroup().getNodeCount() > 0) {
            for (int i = 0; i < sourceProduct.getNumBands(); ++i) {
                Band sourceBand = sourceProduct.getBandAt(i);
                String bandName = sourceBand.getName();
                if (!sourceBand.isFlagBand() || targetProduct.getBand(bandName) != null) continue;
                ProductUtils.copyBand(bandName, sourceProduct, targetProduct, copySourceImage);
            }
            ProductUtils.copyMasks(sourceProduct, targetProduct);
            ProductUtils.copyOverlayMasks(sourceProduct, targetProduct);
        }
    }

    public static void copyFlagBandsWithoutMasks(Product sourceProduct, Product targetProduct, boolean copySourceImage) {
        Guardian.assertNotNull("source", (Object)sourceProduct);
        Guardian.assertNotNull("target", (Object)targetProduct);
        if (sourceProduct.getFlagCodingGroup().getNodeCount() > 0) {
            for (int i = 0; i < sourceProduct.getNumBands(); ++i) {
                Band sourceBand = sourceProduct.getBandAt(i);
                String bandName = sourceBand.getName();
                if (!sourceBand.isFlagBand() || targetProduct.getBand(bandName) != null) continue;
                ProductUtils.copyBand(bandName, sourceProduct, targetProduct, copySourceImage);
            }
        }
    }

    public static void copySampleCodingBands(Product sourceProduct, Product targetProduct, boolean copySourceImage) {
        Guardian.assertNotNull("source", (Object)sourceProduct);
        Guardian.assertNotNull("target", (Object)targetProduct);
        if (sourceProduct.getFlagCodingGroup().getNodeCount() > 0 || sourceProduct.getIndexCodingGroup().getNodeCount() > 0) {
            for (int i = 0; i < sourceProduct.getNumBands(); ++i) {
                Band sourceBand = sourceProduct.getBandAt(i);
                String bandName = sourceBand.getName();
                if (!sourceBand.isFlagBand() && !sourceBand.isIndexBand() || targetProduct.getBand(bandName) != null) continue;
                ProductUtils.copyBand(bandName, sourceProduct, targetProduct, copySourceImage);
            }
            ProductUtils.copyMasks(sourceProduct, targetProduct);
            ProductUtils.copyOverlayMasks(sourceProduct, targetProduct);
        }
    }

    public static TiePointGrid copyTiePointGrid(String gridName, Product sourceProduct, Product targetProduct) {
        Guardian.assertNotNull("sourceProduct", (Object)sourceProduct);
        Guardian.assertNotNull("targetProduct", (Object)targetProduct);
        if (gridName == null || gridName.isEmpty()) {
            return null;
        }
        TiePointGrid sourceGrid = sourceProduct.getTiePointGrid(gridName);
        if (sourceGrid == null) {
            return null;
        }
        TiePointGrid targetGrid = sourceGrid.cloneTiePointGrid();
        targetProduct.addTiePointGrid(targetGrid);
        return targetGrid;
    }

    public static VirtualBand copyVirtualBand(Product target, VirtualBand srcBand, String name) {
        return ProductUtils.copyVirtualBand(target, srcBand, name, false);
    }

    public static VirtualBand copyVirtualBand(Product target, VirtualBand srcBand, String name, boolean adaptToSceneRasterSize) {
        VirtualBand virtBand = new VirtualBand(name, srcBand.getDataType(), adaptToSceneRasterSize ? target.getSceneRasterWidth() : srcBand.getRasterWidth(), adaptToSceneRasterSize ? target.getSceneRasterHeight() : srcBand.getRasterHeight(), srcBand.getExpression());
        virtBand.setUnit(srcBand.getUnit());
        virtBand.setDescription(srcBand.getDescription());
        virtBand.setNoDataValue(srcBand.getNoDataValue());
        virtBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
        virtBand.setOwner(target);
        target.addBand(virtBand);
        return virtBand;
    }

    public static Band copyBand(String sourceBandName, Product sourceProduct, Product targetProduct, boolean copySourceImage) {
        return ProductUtils.copyBand(sourceBandName, sourceProduct, sourceBandName, targetProduct, copySourceImage);
    }

    public static Band copyBand(String sourceBandName, Product sourceProduct, String targetBandName, Product targetProduct, boolean copySourceImage) {
        Guardian.assertNotNull("sourceProduct", (Object)sourceProduct);
        Guardian.assertNotNull("targetProduct", (Object)targetProduct);
        if (sourceBandName == null || sourceBandName.isEmpty()) {
            return null;
        }
        Band sourceBand = sourceProduct.getBand(sourceBandName);
        if (sourceBand == null) {
            return null;
        }
        Band targetBand = new Band(targetBandName, sourceBand.getDataType(), sourceBand.getRasterWidth(), sourceBand.getRasterHeight());
        targetProduct.addBand(targetBand);
        ProductUtils.copyRasterDataNodeProperties(sourceBand, targetBand);
        if (copySourceImage) {
            targetBand.setSourceImage(sourceBand.getSourceImage());
        }
        return targetBand;
    }

    public static void copyRasterDataNodeProperties(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        targetRaster.setDescription(sourceRaster.getDescription());
        targetRaster.setUnit(sourceRaster.getUnit());
        targetRaster.setScalingFactor(sourceRaster.getScalingFactor());
        targetRaster.setScalingOffset(sourceRaster.getScalingOffset());
        targetRaster.setLog10Scaled(sourceRaster.isLog10Scaled());
        targetRaster.setNoDataValueUsed(sourceRaster.isNoDataValueUsed());
        targetRaster.setNoDataValue(sourceRaster.getNoDataValue());
        targetRaster.setValidPixelExpression(sourceRaster.getValidPixelExpression());
        if (sourceRaster instanceof Band && targetRaster instanceof Band) {
            Band sourceBand = (Band)sourceRaster;
            Band targetBand = (Band)targetRaster;
            ProductUtils.copySpectralBandProperties(sourceBand, targetBand);
            Product targetProduct = targetBand.getProduct();
            if (targetProduct == null) {
                return;
            }
            if (sourceBand.getFlagCoding() != null) {
                FlagCoding srcFlagCoding = sourceBand.getFlagCoding();
                ProductUtils.copyFlagCoding(srcFlagCoding, targetProduct);
                targetBand.setSampleCoding(targetProduct.getFlagCodingGroup().get(srcFlagCoding.getName()));
            }
            if (sourceBand.getIndexCoding() != null) {
                IndexCoding srcIndexCoding = sourceBand.getIndexCoding();
                ProductUtils.copyIndexCoding(srcIndexCoding, targetProduct);
                targetBand.setSampleCoding(targetProduct.getIndexCodingGroup().get(srcIndexCoding.getName()));
                ImageInfo imageInfo = sourceBand.getImageInfo();
                if (imageInfo != null) {
                    targetBand.setImageInfo(imageInfo.clone());
                }
            }
        }
    }

    public static void copySpectralBandProperties(Band sourceBand, Band targetBand) {
        Guardian.assertNotNull("source", sourceBand);
        Guardian.assertNotNull("target", targetBand);
        targetBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
        targetBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
        targetBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
        targetBand.setSolarFlux(sourceBand.getSolarFlux());
    }

    public static void copyProductNodes(Product sourceProduct, Product targetProduct) {
        ProductUtils.copyMetadata(sourceProduct, targetProduct);
        ProductUtils.copyTiePointGrids(sourceProduct, targetProduct);
        ProductUtils.copyFlagCodings(sourceProduct, targetProduct);
        ProductUtils.copyFlagBands(sourceProduct, targetProduct, true);
        ProductUtils.copyGeoCoding(sourceProduct, targetProduct);
        ProductUtils.copyMasks(sourceProduct, targetProduct);
        ProductUtils.copyVectorData(sourceProduct, targetProduct);
        ProductUtils.copyIndexCodings(sourceProduct, targetProduct);
        ProductUtils.copyQuicklookBandName(sourceProduct, targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        targetProduct.setDescription(sourceProduct.getDescription());
        targetProduct.setAutoGrouping(sourceProduct.getAutoGrouping());
    }

    public static void copyGeoCoding(Product sourceProduct, Product targetProduct) {
        Guardian.assertNotNull("sourceProduct", (Object)sourceProduct);
        Guardian.assertNotNull("targetProduct", (Object)targetProduct);
        sourceProduct.transferGeoCodingTo(targetProduct, null);
    }

    public static void copyGeoCoding(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        ProductUtils.copyGeoCodingImpl(sourceRaster, targetRaster);
    }

    public static void copyGeoCoding(RasterDataNode sourceRaster, Product targetProduct) {
        ProductUtils.copyGeoCodingImpl(sourceRaster, targetProduct);
    }

    public static void copyGeoCoding(Product sourceProduct, RasterDataNode targetRaster) {
        ProductUtils.copyGeoCodingImpl(sourceProduct, targetRaster);
    }

    private static void copyGeoCodingImpl(ProductNode sourceNode, ProductNode targetNode) {
        Scene srcScene = SceneFactory.createScene(sourceNode);
        Scene destScene = SceneFactory.createScene(targetNode);
        if (srcScene != null && destScene != null) {
            srcScene.transferGeoCodingTo(destScene, null);
        }
    }

    public static void copyImageGeometry(RasterDataNode sourceRaster, RasterDataNode targetRaster, boolean deepCopy) {
        if (sourceRaster.getRasterSize().equals(targetRaster.getRasterSize())) {
            if (sourceRaster.getGeoCoding() != targetRaster.getGeoCoding()) {
                if (deepCopy) {
                    ProductUtils.copyGeoCoding(sourceRaster, targetRaster);
                } else {
                    targetRaster.setGeoCoding(sourceRaster.getGeoCoding());
                }
            }
            if (!targetRaster.isSourceImageSet() && !sourceRaster.getImageToModelTransform().equals(targetRaster.getImageToModelTransform())) {
                targetRaster.setImageToModelTransform(sourceRaster.getImageToModelTransform());
            }
        }
    }

    public static void copyTiePointGrids(Product sourceProduct, Product targetProduct) {
        for (int i = 0; i < sourceProduct.getNumTiePointGrids(); ++i) {
            TiePointGrid srcTPG = sourceProduct.getTiePointGridAt(i);
            if (targetProduct.containsRasterDataNode(srcTPG.getName())) continue;
            targetProduct.addTiePointGrid(srcTPG.cloneTiePointGrid());
        }
    }

    public static void copyVectorData(Product sourceProduct, Product targetProduct) {
        VectorDataNode sourceVDN;
        int i;
        ProductNodeGroup<VectorDataNode> vectorDataGroup = sourceProduct.getVectorDataGroup();
        boolean allPermanentAndEmpty = true;
        for (i = 0; i < vectorDataGroup.getNodeCount(); ++i) {
            sourceVDN = vectorDataGroup.get(i);
            if (sourceVDN.isPermanent() && sourceVDN.getFeatureCollection().isEmpty()) continue;
            allPermanentAndEmpty = false;
            break;
        }
        if (allPermanentAndEmpty) {
            return;
        }
        if (sourceProduct.isCompatibleProduct(targetProduct, 0.001f)) {
            for (i = 0; i < vectorDataGroup.getNodeCount(); ++i) {
                sourceVDN = vectorDataGroup.get(i);
                String name = sourceVDN.getName();
                DefaultFeatureCollection featureCollection = sourceVDN.getFeatureCollection();
                featureCollection = new DefaultFeatureCollection((FeatureCollection)featureCollection);
                if (!targetProduct.getVectorDataGroup().contains(name)) {
                    targetProduct.getVectorDataGroup().add(new VectorDataNode(name, (SimpleFeatureType)featureCollection.getSchema()));
                }
                VectorDataNode targetVDN = targetProduct.getVectorDataGroup().get(name);
                targetVDN.getFeatureCollection().addAll((FeatureCollection)featureCollection);
                targetVDN.setDefaultStyleCss(sourceVDN.getDefaultStyleCss());
                targetVDN.setDescription(sourceVDN.getDescription());
            }
        } else {
            Geometry clipGeometry;
            if (sourceProduct.getSceneGeoCoding() == null || targetProduct.getSceneGeoCoding() == null) {
                return;
            }
            try {
                Geometry sourceGeometryWGS84 = FeatureUtils.createGeoBoundaryPolygon(sourceProduct);
                Geometry targetGeometryWGS84 = FeatureUtils.createGeoBoundaryPolygon(targetProduct);
                if (!sourceGeometryWGS84.intersects(targetGeometryWGS84)) {
                    return;
                }
                clipGeometry = sourceGeometryWGS84.intersection(targetGeometryWGS84);
            }
            catch (Exception e) {
                return;
            }
            CoordinateReferenceSystem srcModelCrs = sourceProduct.getSceneCRS();
            CoordinateReferenceSystem targetModelCrs = targetProduct.getSceneCRS();
            for (int i2 = 0; i2 < vectorDataGroup.getNodeCount(); ++i2) {
                VectorDataNode sourceVDN2 = vectorDataGroup.get(i2);
                String name = sourceVDN2.getName();
                DefaultFeatureCollection featureCollection = sourceVDN2.getFeatureCollection();
                featureCollection = FeatureUtils.clipCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)featureCollection, srcModelCrs, clipGeometry, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null, targetModelCrs, ProgressMonitor.NULL);
                if (!targetProduct.getVectorDataGroup().contains(name)) {
                    targetProduct.getVectorDataGroup().add(new VectorDataNode(name, (SimpleFeatureType)featureCollection.getSchema()));
                }
                VectorDataNode targetVDN = targetProduct.getVectorDataGroup().get(name);
                targetVDN.getPlacemarkGroup();
                targetVDN.getFeatureCollection().addAll((FeatureCollection)featureCollection);
                targetVDN.setDefaultStyleCss(sourceVDN2.getDefaultStyleCss());
                targetVDN.setDescription(sourceVDN2.getDescription());
            }
        }
    }

    public static boolean canGetPixelPos(Product product) {
        return product != null && product.getSceneGeoCoding() != null && product.getSceneGeoCoding().canGetPixelPos();
    }

    public static boolean canGetPixelPos(RasterDataNode raster) {
        return raster != null && raster.getGeoCoding() != null && raster.getGeoCoding().canGetPixelPos();
    }

    public static BufferedImage createDensityPlotImage(RasterDataNode raster1, float sampleMin1, float sampleMax1, RasterDataNode raster2, float sampleMin2, float sampleMax2, Mask roiMask, int width, int height, Color background, BufferedImage image, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("raster1", raster1);
        Guardian.assertNotNull("raster2", raster2);
        Guardian.assertNotNull("background", background);
        if (raster1.getRasterWidth() != raster2.getRasterWidth() || raster1.getRasterHeight() != raster2.getRasterHeight()) {
            throw new IllegalArgumentException("'raster1' has not the same size as 'raster2'");
        }
        image = ProductUtils.getCompatibleBufferedImageForDensityPlot(image, width, height, background);
        byte[] pixelValues = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        DensityPlot.accumulate(raster1, sampleMin1, sampleMax1, raster2, sampleMin2, sampleMax2, roiMask, width, height, pixelValues, pm);
        return image;
    }

    private static BufferedImage getCompatibleBufferedImageForDensityPlot(BufferedImage image, int width, int height, Color background) {
        if (image == null || image.getWidth() != width || image.getHeight() != height || !(image.getColorModel() instanceof IndexColorModel) || !(image.getRaster().getDataBuffer() instanceof DataBufferByte)) {
            int i;
            int palSize = 256;
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            byte[] a = new byte[256];
            r[0] = (byte)background.getRed();
            g[0] = (byte)background.getGreen();
            b[0] = (byte)background.getBlue();
            a[0] = (byte)background.getAlpha();
            for (i = 1; i < 128; ++i) {
                r[i] = (byte)(2 * i);
                g[i] = 0;
                b[i] = 0;
                a[i] = -1;
            }
            for (i = 128; i < 256; ++i) {
                r[i] = -1;
                g[i] = (byte)(2 * (i - 128));
                b[i] = 0;
                a[i] = -1;
            }
            image = new BufferedImage(width, height, 13, new IndexColorModel(8, 256, r, g, b, a));
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage overlayMasks(RasterDataNode raster, BufferedImage overlayBIm, ProgressMonitor pm) {
        ProductNodeGroup<Mask> maskGroup = raster.getOverlayMaskGroup();
        if (maskGroup.getNodeCount() == 0) {
            return overlayBIm;
        }
        BufferedImageRendering imageRendering = new BufferedImageRendering(overlayBIm);
        pm.beginTask("Creating masks ...", maskGroup.getNodeCount());
        try {
            Mask[] masks;
            for (Mask mask : masks = (Mask[])maskGroup.toArray(new Mask[maskGroup.getNodeCount()])) {
                pm.setSubTaskName(String.format("Applying mask '%s'", mask.getName()));
                Layer layer = MaskLayerType.createLayer(raster, mask);
                layer.render((Rendering)imageRendering);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        return imageRendering.getImage();
    }

    public static GeoPos getCenterGeoPos(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding != null) {
            PixelPos centerPixelPos = new PixelPos(0.5 * (double)product.getSceneRasterWidth() + 0.5, 0.5 * (double)product.getSceneRasterHeight() + 0.5);
            return geoCoding.getGeoPos(centerPixelPos, null);
        }
        return null;
    }

    public static int normalizeGeoPolygon(GeoPos[] polygon) {
        boolean posNormalized;
        double[] originalLon = new double[polygon.length];
        for (int i = 0; i < originalLon.length; ++i) {
            originalLon[i] = polygon[i].lon;
        }
        double increment = 0.0;
        double minLon = Double.MAX_VALUE;
        double maxLon = -1.7976931348623157E308;
        for (int i = 1; i < polygon.length; ++i) {
            GeoPos geoPos = polygon[i];
            double lonDiff = originalLon[i] - originalLon[i - 1];
            if (lonDiff > 180.0) {
                increment -= 360.0;
            } else if (lonDiff < -180.0) {
                increment += 360.0;
            }
            geoPos.lon += increment;
            if (geoPos.lon < minLon) {
                minLon = geoPos.lon;
            }
            if (!(geoPos.lon > maxLon)) continue;
            maxLon = geoPos.lon;
        }
        int normalized = 0;
        boolean negNormalized = false;
        boolean bl = posNormalized = minLon < -180.0;
        if (maxLon > 180.0) {
            negNormalized = true;
        }
        if (negNormalized && !posNormalized) {
            normalized = 1;
        } else if (!negNormalized && posNormalized) {
            normalized = -1;
            for (GeoPos aPolygon : polygon) {
                aPolygon.lon += 360.0;
            }
        } else if (negNormalized && posNormalized) {
            normalized = 2;
        }
        return normalized;
    }

    public static void denormalizeGeoPolygon(GeoPos[] polygon) {
        for (GeoPos geoPos : polygon) {
            ProductUtils.denormalizeGeoPos(geoPos);
        }
    }

    public static void denormalizeGeoPos(GeoPos geoPos) {
        int factor = geoPos.lon >= 0.0 ? (int)((geoPos.lon + 180.0) / 360.0) : (int)((geoPos.lon - 180.0) / 360.0);
        geoPos.lon -= (double)factor * 360.0;
    }

    public static int getRotationDirection(GeoPos[] polygon) {
        return ProductUtils.getAngleSum(polygon) > 0.0 ? 1 : -1;
    }

    public static double getAngleSum(GeoPos[] polygon) {
        int length = polygon.length;
        double angleSum = 0.0;
        for (int i = 0; i < length; ++i) {
            GeoPos p1 = polygon[i];
            GeoPos p2 = polygon[(i + 1) % length];
            GeoPos p3 = polygon[(i + 2) % length];
            double ax = p2.lon - p1.lon;
            double ay = p2.lat - p1.lat;
            double bx = p3.lon - p2.lon;
            double by = p3.lat - p2.lat;
            double a = Math.sqrt(ax * ax + ay * ay);
            double b = Math.sqrt(bx * bx + by * by);
            double cosAB = (ax * bx + ay * by) / (a * b);
            double sinAB = (ax * by - ay * bx) / (a * b);
            angleSum += Math.atan2(sinAB, cosAB);
        }
        return angleSum;
    }

    public static void copyMetadata(Product source, Product target) {
        Assert.notNull((Object)((Object)source), (String)"source");
        Assert.notNull((Object)((Object)target), (String)"target");
        ProductUtils.copyMetadata(source.getMetadataRoot(), target.getMetadataRoot());
    }

    public static void copyTimeInformation(Product source, Product target) {
        target.setStartTime(source.getStartTime());
        target.setEndTime(source.getEndTime());
        target.setSceneTimeCoding(source.getSceneTimeCoding());
    }

    public static void copyMetadata(MetadataElement source, MetadataElement target) {
        Assert.notNull((Object)((Object)source), (String)"source");
        Assert.notNull((Object)((Object)target), (String)"target");
        for (MetadataElement metadataElement : source.getElements()) {
            target.addElement(metadataElement.createDeepClone());
        }
        for (ProductNode productNode : source.getAttributes()) {
            target.addAttribute(((MetadataAttribute)productNode).createDeepClone());
        }
    }

    public static void copyPreferredTileSize(Product sourceProduct, Product targetProduct) {
        Dimension preferredTileSize = sourceProduct.getPreferredTileSize();
        if (preferredTileSize != null) {
            Rectangle targetRect = new Rectangle(targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            Rectangle tileRect = new Rectangle(preferredTileSize).intersection(targetRect);
            targetProduct.setPreferredTileSize(tileRect.width, tileRect.height);
        }
    }

    public static GeoTIFFMetadata createGeoTIFFMetadata(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        return ProductUtils.createGeoTIFFMetadata(geoCoding, w, h);
    }

    public static GeoTIFFMetadata createGeoTIFFMetadata(GeoCoding geoCoding, int width, int height) {
        return GeoCoding2GeoTIFFMetadata.createGeoTIFFMetadata(geoCoding, width, height);
    }

    public static void addElementToHistory(Product product, MetadataElement elem) {
        Guardian.assertNotNull("product", (Object)product);
        if (elem != null) {
            MetadataElement historyElem;
            String historyName = "history";
            MetadataElement metadataRoot = product.getMetadataRoot();
            if (!metadataRoot.containsElement("history")) {
                metadataRoot.addElement(new MetadataElement("history"));
            }
            if ((historyElem = metadataRoot.getElement("history")).containsElement(elem.getName())) {
                MetadataElement previousElem = historyElem.getElement(elem.getName());
                historyElem.removeElement(previousElem);
                elem.addElement(previousElem);
            }
            historyElem.addElement(elem);
        }
    }

    public static String[] removeInvalidExpressions(final Product product) {
        final ArrayList messages = new ArrayList(10);
        product.acceptVisitor(new ProductVisitorAdapter(){

            @Override
            public void visit(TiePointGrid grid) {
                String type = "tie point grid";
                this.checkRaster(grid, "tie point grid");
            }

            @Override
            public void visit(Band band) {
                String type = "band";
                this.checkRaster(band, "band");
            }

            @Override
            public void visit(VirtualBand virtualBand) {
                if (!product.isCompatibleBandArithmeticExpression(virtualBand.getExpression())) {
                    product.removeBand(virtualBand);
                    String pattern = "Virtual band ''{0}'' removed from output product because it is not applicable.";
                    messages.add(MessageFormat.format(pattern, virtualBand.getName()));
                } else {
                    this.checkRaster(virtualBand, "virtual band");
                }
            }

            private void checkRaster(RasterDataNode raster, String type) {
                String validExpr = raster.getValidPixelExpression();
                if (validExpr != null && !product.isCompatibleBandArithmeticExpression(validExpr)) {
                    raster.setValidPixelExpression(null);
                    String pattern = "Valid pixel expression ''{0}'' removed from output {1} ''{2}'' because it is not applicable.";
                    messages.add(MessageFormat.format(pattern, validExpr, type, raster.getName()));
                }
            }
        });
        return messages.toArray(new String[0]);
    }

    public static String getAvailableNodeName(String name, ProductNodeGroup<? extends ProductNode> nodeGroup) {
        int index = 1;
        Object foundName = name;
        while (nodeGroup.contains((String)foundName)) {
            foundName = name + "_" + index++;
        }
        return foundName;
    }

    public static String findSuitableQuicklookBandName(Product product) {
        String bandName = product.getQuicklookBandName();
        if (bandName != null && product.containsBand(bandName)) {
            return bandName;
        }
        Band[] bands = product.getBands();
        if (bands.length == 0) {
            return null;
        }
        double wavelengthMax = 0.0;
        for (Band band : bands) {
            float wavelength = band.getSpectralWavelength();
            if (!(wavelength > 1000.0f) || !((double)wavelength > wavelengthMax)) continue;
            wavelengthMax = wavelength;
            bandName = band.getName();
        }
        if (bandName != null) {
            return bandName;
        }
        double WL1 = 860.0;
        double WL2 = 890.0;
        double minValue = Double.MAX_VALUE;
        for (Band band : bands) {
            double value;
            double wavelength = band.getSpectralWavelength();
            if (!(wavelength > 860.0) || !(wavelength < 890.0) || !((value = wavelength - 860.0) < minValue)) continue;
            minValue = value;
            bandName = band.getName();
        }
        if (bandName != null) {
            return bandName;
        }
        wavelengthMax = 0.0;
        for (Band band : bands) {
            float wavelength = band.getSpectralWavelength();
            if (!((double)wavelength > wavelengthMax)) continue;
            wavelengthMax = wavelength;
            bandName = band.getName();
        }
        if (bandName != null) {
            return bandName;
        }
        return bands[0].getName();
    }

    public static PixelPos[] computeSourcePixelCoordinates(GeoCoding sourceGeoCoding, int sourceWidth, int sourceHeight, GeoCoding destGeoCoding, Rectangle destArea) {
        Guardian.assertNotNull("sourceGeoCoding", sourceGeoCoding);
        Guardian.assertEquals("sourceGeoCoding.canGetPixelPos()", sourceGeoCoding.canGetPixelPos(), true);
        Guardian.assertNotNull("destGeoCoding", destGeoCoding);
        Guardian.assertEquals("destGeoCoding.canGetGeoPos()", destGeoCoding.canGetGeoPos(), true);
        Guardian.assertNotNull("destArea", destArea);
        int minX = destArea.x;
        int minY = destArea.y;
        int maxX = minX + destArea.width - 1;
        int maxY = minY + destArea.height - 1;
        PixelPos[] pixelCoords = new PixelPos[destArea.width * destArea.height];
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos();
        int coordIndex = 0;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                pixelPos.x = (double)x + 0.5;
                pixelPos.y = (double)y + 0.5;
                destGeoCoding.getGeoPos(pixelPos, geoPos);
                sourceGeoCoding.getPixelPos(geoPos, pixelPos);
                pixelCoords[coordIndex] = pixelPos.x >= 0.0 && pixelPos.x < (double)sourceWidth && pixelPos.y >= 0.0 && pixelPos.y < (double)sourceHeight ? new PixelPos(pixelPos.x, pixelPos.y) : null;
                ++coordIndex;
            }
        }
        return pixelCoords;
    }

    public static double[] computeMinMaxY(PixelPos[] pixelPositions) {
        Guardian.assertNotNull("pixelPositions", pixelPositions);
        double min = 2.147483647E9;
        double max = -2.147483648E9;
        for (PixelPos pixelPos : pixelPositions) {
            if (pixelPos == null) continue;
            if (pixelPos.y < min) {
                min = pixelPos.y;
            }
            if (!(pixelPos.y > max)) continue;
            max = pixelPos.y;
        }
        if (min > max) {
            return null;
        }
        return new double[]{min, max};
    }

    public static void copyBandsForGeomTransform(Product sourceProduct, Product targetProduct, double defaultNoDataValue, Map<Band, RasterDataNode> addedRasterDataNodes) {
        ProductUtils.copyBandsForGeomTransform(sourceProduct, targetProduct, false, defaultNoDataValue, addedRasterDataNodes);
    }

    public static void copyBandsForGeomTransform(Product sourceProduct, Product targetProduct, boolean includeTiePointGrids, double defaultNoDataValue, Map<Band, RasterDataNode> targetToSourceMap) {
        Band targetBand;
        Debug.assertNotNull((Object)sourceProduct);
        Debug.assertNotNull((Object)targetProduct);
        HashMap<Band, RasterDataNode> sourceNodes = new HashMap<Band, RasterDataNode>(sourceProduct.getNumBands() + sourceProduct.getNumTiePointGrids() + 10);
        Band[] sourceBands = sourceProduct.getBands();
        for (Band band : sourceBands) {
            if (band.getGeoCoding() == null) continue;
            if (band instanceof VirtualBand) {
                targetBand = new VirtualBand(band.getName(), band.getDataType(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight(), ((VirtualBand)band).getExpression());
            } else if (band.isScalingApplied()) {
                targetBand = new Band(band.getName(), 30, targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
                targetBand.setLog10Scaled(band.isLog10Scaled());
            } else {
                targetBand = new Band(band.getName(), band.getDataType(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            }
            targetBand.setUnit(band.getUnit());
            if (band.getDescription() != null) {
                targetBand.setDescription(band.getDescription());
            }
            if (band.isNoDataValueUsed()) {
                if (band.isScalingApplied()) {
                    targetBand.setGeophysicalNoDataValue(band.getGeophysicalNoDataValue());
                } else {
                    targetBand.setNoDataValue(band.getNoDataValue());
                }
            } else {
                targetBand.setGeophysicalNoDataValue(defaultNoDataValue);
            }
            targetBand.setNoDataValueUsed(true);
            ProductUtils.copySpectralBandProperties(band, targetBand);
            FlagCoding sourceFlagCoding = band.getFlagCoding();
            IndexCoding sourceIndexCoding = band.getIndexCoding();
            if (sourceFlagCoding != null) {
                String flagCodingName = sourceFlagCoding.getName();
                FlagCoding destFlagCoding = targetProduct.getFlagCodingGroup().get(flagCodingName);
                Debug.assertNotNull((Object)destFlagCoding);
                targetBand.setSampleCoding(destFlagCoding);
            } else if (sourceIndexCoding != null) {
                String indexCodingName = sourceIndexCoding.getName();
                IndexCoding destIndexCoding = targetProduct.getIndexCodingGroup().get(indexCodingName);
                Debug.assertNotNull((Object)destIndexCoding);
                targetBand.setSampleCoding(destIndexCoding);
            } else {
                targetBand.setSampleCoding(null);
            }
            ImageInfo sourceImageInfo = band.getImageInfo();
            if (sourceImageInfo != null) {
                targetBand.setImageInfo(sourceImageInfo.createDeepCopy());
            }
            targetProduct.addBand(targetBand);
            sourceNodes.put(targetBand, band);
        }
        if (includeTiePointGrids) {
            for (RasterDataNode rasterDataNode : sourceProduct.getTiePointGrids()) {
                if (rasterDataNode.getGeoCoding() == null) continue;
                targetBand = new Band(rasterDataNode.getName(), ((TiePointGrid)rasterDataNode).getGeophysicalDataType(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
                targetBand.setUnit(rasterDataNode.getUnit());
                if (rasterDataNode.getDescription() != null) {
                    targetBand.setDescription(rasterDataNode.getDescription());
                }
                if (rasterDataNode.isNoDataValueUsed()) {
                    targetBand.setNoDataValue(rasterDataNode.getNoDataValue());
                } else {
                    targetBand.setNoDataValue(defaultNoDataValue);
                }
                targetBand.setNoDataValueUsed(true);
                targetProduct.addBand(targetBand);
                sourceNodes.put(targetBand, rasterDataNode);
            }
        }
        for (RasterDataNode rasterDataNode : targetProduct.getBands()) {
            String sourceExpression;
            RasterDataNode sourceNode = (RasterDataNode)sourceNodes.get(rasterDataNode);
            if (sourceNode == null || (sourceExpression = sourceNode.getValidPixelExpression()) == null || targetProduct.isCompatibleBandArithmeticExpression(sourceExpression)) continue;
            rasterDataNode.setValidPixelExpression(sourceExpression);
        }
        if (targetToSourceMap != null) {
            targetToSourceMap.putAll(sourceNodes);
        }
    }

    public static ArrayList<GeneralPath> assemblePathList(GeoPos[] geoPoints) {
        ArrayList<GeneralPath> pathList = new ArrayList<GeneralPath>(16);
        if (geoPoints.length > 1) {
            GeneralPath path = new GeneralPath(1, geoPoints.length + 8);
            Range range = GeoUtils.fillPath(geoPoints, path);
            int runIndexMin = (int)Math.floor((range.getMin() + 180.0) / 360.0);
            int runIndexMax = (int)Math.floor((range.getMax() + 180.0) / 360.0);
            if (runIndexMin == 0 && runIndexMax == 0) {
                pathList.add(path);
                return pathList;
            }
            Area pathArea = new Area(path);
            for (int k = runIndexMin; k <= runIndexMax; ++k) {
                Area currentArea = new Area(new Rectangle2D.Double((double)k * 360.0 - 180.0, -90.0, 360.0, 180.0));
                currentArea.intersect(pathArea);
                if (currentArea.isEmpty()) continue;
                pathList.addAll(GeoUtils.areaToSubPaths(currentArea, (double)(-k) * 360.0));
            }
        }
        return pathList;
    }

    public static ProductData.UTC getScanLineTime(Product product, double y) {
        return ProductUtils.getPixelScanTime(product, 0.0, y);
    }

    public static ProductData.UTC getPixelScanTime(RasterDataNode node, double x, double y) {
        if (node.getTimeCoding() != null) {
            return new ProductData.UTC(node.getTimeCoding().getMJD(new PixelPos(x, y)));
        }
        Product product = node.getProduct();
        return ProductUtils.getPixelScanTime(product, x, y);
    }

    public static ProductData.UTC getPixelScanTime(Product product, double x, double y) {
        if (product == null) {
            return null;
        }
        if (product.getSceneTimeCoding() != null) {
            return new ProductData.UTC(product.getSceneTimeCoding().getMJD(new PixelPos(x, y)));
        }
        ProductData.UTC utcStartTime = product.getStartTime();
        ProductData.UTC utcEndTime = product.getEndTime();
        if (utcStartTime == null && utcEndTime == null) {
            return null;
        }
        if (utcStartTime == null) {
            return utcEndTime;
        }
        if (utcEndTime == null) {
            return utcStartTime;
        }
        double start = utcStartTime.getMJD();
        double stop = utcEndTime.getMJD();
        if (product.getSceneRasterHeight() == 1) {
            return new ProductData.UTC(utcStartTime.getMJD());
        }
        double timePerLine = (stop - start) / (double)(product.getSceneRasterHeight() - 1);
        double currentLine = timePerLine * y + start;
        return new ProductData.UTC(currentLine);
    }

    public static double getGeophysicalSampleAsDouble(RasterDataNode raster, int pixelX, int pixelY, int level) {
        int tileY;
        int tileX;
        PlanarImage image = ImageManager.getInstance().getSourceImage(raster, level);
        Raster data = image.getTile(tileX = image.XToTileX(pixelX), tileY = image.YToTileY(pixelY));
        if (data == null) {
            return Double.NaN;
        }
        double sample = raster.getDataType() == 10 ? (double)((byte)data.getSample(pixelX, pixelY, 0)) : (raster.getDataType() == 22 ? (double)((long)data.getSample(pixelX, pixelY, 0) & 0xFFFFFFFFL) : data.getSampleDouble(pixelX, pixelY, 0));
        if (raster.isScalingApplied()) {
            return raster.scale(sample);
        }
        return sample;
    }

    public static long getGeophysicalSampleAsLong(RasterDataNode raster, int pixelX, int pixelY, int level) {
        int tileY;
        int tileX;
        PlanarImage image = ImageManager.getInstance().getSourceImage(raster, level);
        Raster data = image.getTile(tileX = image.XToTileX(pixelX), tileY = image.YToTileY(pixelY));
        if (data == null) {
            return 0L;
        }
        long sample = raster.getDataType() == 10 ? (long)((byte)data.getSample(pixelX, pixelY, 0)) : (raster.getDataType() == 22 ? (long)data.getSample(pixelX, pixelY, 0) & 0xFFFFFFFFL : (long)data.getSample(pixelX, pixelY, 0));
        if (raster.isScalingApplied()) {
            return (long)raster.scale(sample);
        }
        return sample;
    }

    public static boolean areRastersEqualInSize(RasterDataNode ... rasters) {
        return rasters.length < 2 || ProductUtils.areRastersEqualInSize(rasters[0].getRasterWidth(), rasters[0].getRasterHeight(), rasters);
    }

    public static boolean areRastersEqualInSize(int width, int height, RasterDataNode ... rasters) {
        for (RasterDataNode raster : rasters) {
            if (raster.getRasterWidth() == width && raster.getRasterHeight() == height) continue;
            return false;
        }
        return true;
    }

    public static boolean areRastersEqualInSize(Product product, String ... rasterNames) throws IllegalArgumentException {
        if (rasterNames.length < 2) {
            return true;
        }
        RasterDataNode referenceNode = product.getRasterDataNode(rasterNames[0]);
        if (referenceNode == null) {
            throw new IllegalArgumentException(rasterNames[0] + " is not part of " + product.getName());
        }
        int referenceWidth = referenceNode.getRasterWidth();
        int referenceHeight = referenceNode.getRasterHeight();
        for (int i = 1; i < rasterNames.length; ++i) {
            RasterDataNode node = product.getRasterDataNode(rasterNames[i]);
            if (node == null) {
                throw new IllegalArgumentException(rasterNames[i] + " is not part of " + product.getName());
            }
            if (node.getRasterWidth() == referenceWidth && node.getRasterHeight() == referenceHeight) continue;
            return false;
        }
        return true;
    }

    private static VectorDataNode transferVectorDataNode(Product targetProduct, VectorDataNode sourceVectorDataNode, AffineTransform referenceImageToModelTransform) {
        AffineTransform referenceModelToImageTransform;
        try {
            referenceModelToImageTransform = referenceImageToModelTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        AffineTransform targetImageToModelTransform = Product.findImageToModelTransform(targetProduct.getSceneGeoCoding());
        referenceModelToImageTransform.concatenate(targetImageToModelTransform);
        AffineTransform2D mathTransform = new AffineTransform2D(referenceModelToImageTransform);
        transformer.setMathTransform((MathTransform)mathTransform);
        DefaultFeatureCollection sourceCollection = sourceVectorDataNode.getFeatureCollection();
        DefaultFeatureCollection targetCollection = new DefaultFeatureCollection(sourceCollection.getID(), (SimpleFeatureType)sourceCollection.getSchema());
        FeatureIterator featureIterator = sourceCollection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature srcFeature = (SimpleFeature)featureIterator.next();
            Object defaultGeometry = srcFeature.getDefaultGeometry();
            if (!(defaultGeometry instanceof Geometry)) continue;
            try {
                Geometry transformedGeometry = transformer.transform((Geometry)defaultGeometry);
                SimpleFeature targetFeature = SimpleFeatureBuilder.copy((SimpleFeature)srcFeature);
                targetFeature.setDefaultGeometry((Object)transformedGeometry);
                targetCollection.add(targetFeature);
            }
            catch (TransformException e) {
                return null;
            }
        }
        VectorDataNode targetVectorDataNode = new VectorDataNode(sourceVectorDataNode.getName(), (SimpleFeatureType)sourceCollection.getSchema());
        targetVectorDataNode.getFeatureCollection().addAll((FeatureCollection)targetCollection);
        targetVectorDataNode.setDefaultStyleCss(sourceVectorDataNode.getDefaultStyleCss());
        targetVectorDataNode.setDescription(sourceVectorDataNode.getDescription());
        targetVectorDataNode.setOwner(targetProduct);
        return targetVectorDataNode;
    }
}

