/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrivilegedAccessor {
    public static Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static void setValue(Object instance, String fieldName, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        field.set(instance, value);
    }

    public static Object getStaticValue(Class c, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(c, fieldName);
        field.setAccessible(true);
        return field.get(null);
    }

    public static void setStaticValue(Class c, String fieldName, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(c, fieldName);
        field.setAccessible(true);
        field.set(null, value);
    }

    public static Object invokeMethod(Object instance, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return PrivilegedAccessor.invokeMethod(instance, methodName, args);
    }

    public static Object invokeMethod(Object instance, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = new Object[]{};
        }
        Class[] classTypes = PrivilegedAccessor.getClassArray(args);
        Method[] methods = instance.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class[] paramTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || !PrivilegedAccessor.compare(paramTypes, args)) continue;
            return method.invoke(instance, args);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("No method named ").append(methodName).append(" found in ").append(instance.getClass().getName()).append(" with parameters (");
        for (int x = 0; x < classTypes.length; ++x) {
            sb.append(classTypes[x].getName());
            if (x >= classTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        throw new NoSuchMethodException(sb.toString());
    }

    private static Class[] getClassArray(Object[] args) {
        Class[] classTypes = null;
        if (args != null) {
            classTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                classTypes[i] = args[i].getClass();
            }
        }
        return classTypes;
    }

    public static Method getMethod(Object instance, String methodName, Class[] classTypes) throws NoSuchMethodException {
        Method accessMethod = PrivilegedAccessor.getMethod(instance.getClass(), methodName, classTypes);
        accessMethod.setAccessible(true);
        return accessMethod;
    }

    public static Field getField(Class thisClass, String fieldName) throws NoSuchFieldException {
        if (thisClass == null) {
            throw new NoSuchFieldException("Invalid field : " + fieldName);
        }
        try {
            return thisClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return PrivilegedAccessor.getField(thisClass.getSuperclass(), fieldName);
        }
    }

    public static Method getMethod(Class thisClass, String methodName, Class[] classTypes) throws NoSuchMethodException {
        if (thisClass == null) {
            throw new NoSuchMethodException("Invalid method : " + methodName);
        }
        try {
            return thisClass.getDeclaredMethod(methodName, classTypes);
        }
        catch (NoSuchMethodException e) {
            return PrivilegedAccessor.getMethod(thisClass.getSuperclass(), methodName, classTypes);
        }
    }

    private static boolean compare(Class[] c, Object[] args) {
        if (c.length != args.length) {
            return false;
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    public static Object getNewInstance(String classname, Object[] args) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (classname == null) {
            throw new ClassNotFoundException();
        }
        if (args == null) {
            args = new Object[]{};
        }
        Class[] classTypes = PrivilegedAccessor.getClassArray(args);
        Class<?> c = Class.forName(classname);
        Constructor<?>[] constructors = c.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            Class[] paramTypes = constructor.getParameterTypes();
            if (!PrivilegedAccessor.compare(paramTypes, args)) continue;
            return constructor.newInstance(args);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("No constructor found for ").append(classname).append(" with parameters (");
        for (int x = 0; x < classTypes.length; ++x) {
            sb.append(classTypes[x].getName());
            if (x >= classTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        throw new NoSuchMethodException(sb.toString());
    }
}

