/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.Assert;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.esa.snap.core.util.AbstractPropertyMap;

public class PreferencesPropertyMap
extends AbstractPropertyMap
implements PreferenceChangeListener {
    private final Preferences preferences;
    private PropertyChangeSupport propertyChangeSupport;

    public PreferencesPropertyMap(Preferences preferences) {
        Assert.notNull((Object)preferences, (String)"preferences");
        this.preferences = preferences;
    }

    @Override
    protected String get(String key) {
        return this.preferences.get(key, null);
    }

    @Override
    protected String get(String key, String defaultValue) {
        return this.preferences.get(key, defaultValue);
    }

    @Override
    protected String set(String key, String value) {
        String oldValue = this.preferences.get(key, null);
        if (value != null) {
            this.preferences.put(key, value);
        } else {
            this.preferences.remove(key);
        }
        return oldValue;
    }

    @Override
    protected void firePropertyChange(String key, String oldValue, String newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
        }
    }

    @Override
    public void load(Path file) throws IOException {
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(file);){
            properties.load(reader);
        }
        for (String key : properties.stringPropertyNames()) {
            this.preferences.put(key, properties.getProperty(key));
        }
    }

    @Override
    public void store(Path file, String header) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.getProperties().store(writer, header);
        }
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            for (String propertyKey : this.preferences.keys()) {
                properties.put(propertyKey, this.preferences.get(propertyKey, null));
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return properties;
    }

    @Override
    public Set<String> getPropertyKeys() {
        try {
            return new HashSet<String>(Arrays.asList(this.preferences.keys()));
        }
        catch (BackingStoreException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.maybeAddPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
        this.maybeAddPropertyChangeSupport().addPropertyChangeListener(key, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
            this.maybeRemovePropertyChangeSupport();
        }
    }

    @Override
    public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(key, listener);
            this.maybeRemovePropertyChangeSupport();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        this.firePropertyChange(evt.getKey(), null, evt.getNewValue());
    }

    private synchronized PropertyChangeSupport maybeAddPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
            this.preferences.addPreferenceChangeListener(this);
        }
        return this.propertyChangeSupport;
    }

    private synchronized void maybeRemovePropertyChangeSupport() {
        if (!this.propertyChangeSupport.hasListeners(null)) {
            this.propertyChangeSupport = null;
            this.preferences.removePreferenceChangeListener(this);
        }
    }
}

