/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;

public class ObservableFeatureCollection
extends DefaultFeatureCollection {
    private List<Listener> listeners;
    private ReferencedEnvelope bounds = null;

    public ObservableFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        super(collection);
    }

    public final void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireChange(EVENT_TYPE type, Collection coll) {
        SimpleFeature[] features = new SimpleFeature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(type, features);
    }

    private void fireChange(EVENT_TYPE type, SimpleFeature ... features) {
        this.forceBoundsRecalculation();
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                listener.changed(type, features);
            }
        }
    }

    protected boolean add(SimpleFeature feature, boolean fire) {
        boolean changed = super.add(feature, fire);
        if (changed && fire) {
            this.fireChange(EVENT_TYPE.ADDED, feature);
        }
        return changed;
    }

    public boolean addAll(Collection<? extends SimpleFeature> collection) {
        boolean changed = super.addAll(collection);
        if (changed) {
            ArrayList<SimpleFeature> featuresAdded = new ArrayList<SimpleFeature>(collection.size());
            for (SimpleFeature simpleFeature : collection) {
                if (!this.contains(simpleFeature)) continue;
                featuresAdded.add(simpleFeature);
            }
            this.fireChange(EVENT_TYPE.ADDED, featuresAdded);
        }
        return changed;
    }

    public boolean addAll(FeatureCollection<?, ?> collection) {
        boolean changed = super.addAll(collection);
        if (changed) {
            try (FeatureIterator features = collection.features();){
                ArrayList<SimpleFeature> featuresAdded = new ArrayList<SimpleFeature>(collection.size());
                while (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    if (!this.contains(feature)) continue;
                    featuresAdded.add(feature);
                }
                this.fireChange(EVENT_TYPE.ADDED, featuresAdded);
            }
        }
        return changed;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        SimpleFeature[] oldFeatures = (SimpleFeature[])this.toArray(new SimpleFeature[this.size()]);
        super.clear();
        this.fireChange(EVENT_TYPE.REMOVED, oldFeatures);
    }

    public boolean remove(Object o) {
        boolean changed = super.remove(o);
        if (changed) {
            this.fireChange(EVENT_TYPE.REMOVED, (SimpleFeature)o);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> collection) {
        boolean changed = super.removeAll(collection);
        Iterator<?> iterator = collection.iterator();
        try {
            if (changed) {
                ArrayList<SimpleFeature> featuresRemoved = new ArrayList<SimpleFeature>(collection.size());
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    if (this.contains(feature)) continue;
                    featuresRemoved.add(feature);
                }
                this.fireChange(EVENT_TYPE.REMOVED, featuresRemoved);
            }
        }
        finally {
            if (iterator instanceof FeatureIterator) {
                ((FeatureIterator)iterator).close();
            }
        }
        return changed;
    }

    public boolean retainAll(Collection<?> collection) {
        boolean changed;
        List<SimpleFeature> oldFeatures = Arrays.asList((SimpleFeature[])this.toArray(new SimpleFeature[0]));
        super.retainAll(collection);
        List<SimpleFeature> currentFeatures = Arrays.asList((SimpleFeature[])this.toArray(new SimpleFeature[0]));
        ArrayList<SimpleFeature> featuresRemoved = new ArrayList<SimpleFeature>();
        for (SimpleFeature oldFeature : oldFeatures) {
            if (currentFeatures.contains(oldFeature)) continue;
            featuresRemoved.add(oldFeature);
        }
        boolean bl = changed = !featuresRemoved.isEmpty();
        if (changed) {
            this.fireChange(EVENT_TYPE.REMOVED, featuresRemoved);
        }
        return changed;
    }

    private void forceBoundsRecalculation() {
        this.bounds = null;
    }

    public ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope();
            SimpleFeatureIterator iterator = this.features();
            while (iterator.hasNext()) {
                BoundingBox geomBounds = ((SimpleFeature)iterator.next()).getBounds();
                if (geomBounds.isEmpty()) continue;
                this.bounds.include(geomBounds);
            }
        }
        return this.bounds;
    }

    public Iterator<SimpleFeature> iterator() {
        final Iterator iterator = super.iterator();
        return new Iterator<SimpleFeature>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SimpleFeature next() {
                return (SimpleFeature)iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                ObservableFeatureCollection.this.forceBoundsRecalculation();
            }
        };
    }

    public static interface Listener {
        public void changed(EVENT_TYPE var1, SimpleFeature ... var2);
    }

    public static enum EVENT_TYPE {
        ADDED,
        REMOVED;

    }
}

