/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import org.esa.snap.core.util.Guardian;

public final class MouseEventFilterFactory {
    private static int _timeout = 300;

    public static void setTimeout(int timeout) throws IllegalArgumentException {
        Guardian.assertGreaterThan("timeout", timeout, 0L);
        _timeout = timeout;
    }

    public static MouseInputListener createFilter(MouseInputListener mouseInputListener) {
        if (mouseInputListener != null) {
            return new MouseInputFilter(_timeout, mouseInputListener);
        }
        return null;
    }

    public static MouseListener createFilter(MouseListener mouseListener) {
        if (mouseListener != null) {
            return new MouseEventFilter(_timeout, mouseListener);
        }
        return null;
    }

    private static class MouseEventFilter
    implements MouseListener {
        private final int _timeout;
        private final MouseListener _listener;
        private MouseEvent _clickEvent;
        private Timer _clickTimer;

        public MouseEventFilter(int timeout, MouseListener listener) {
            this._timeout = timeout;
            this._listener = listener;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this._clickEvent = e;
            this.startClickTimer();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this._listener != null) {
                this._listener.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this._listener != null) {
                this._listener.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this._listener != null) {
                this._listener.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this._listener != null) {
                this._listener.mouseExited(e);
            }
        }

        private void startClickTimer() {
            if (this._clickTimer == null) {
                this._clickTimer = new Timer(this._timeout, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        _clickTimer.stop();
                        if (_listener != null && _clickEvent != null) {
                            _listener.mouseClicked(_clickEvent);
                            _clickEvent = null;
                        }
                    }
                });
            }
            if (!this._clickTimer.isRunning()) {
                this._clickTimer.start();
            }
        }
    }

    private static class MouseInputFilter
    implements MouseInputListener {
        private final MouseInputListener _listener;
        private MouseEventFilter _mouseEventFilter;

        public MouseInputFilter(int timeout, MouseInputListener listener) {
            this._mouseEventFilter = new MouseEventFilter(timeout, listener);
            this._listener = listener;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this._mouseEventFilter.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._mouseEventFilter.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._mouseEventFilter.mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this._mouseEventFilter.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this._mouseEventFilter.mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this._listener != null) {
                this._listener.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this._listener != null) {
                this._listener.mouseMoved(e);
            }
        }
    }
}

