/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.esa.snap.core.datamodel.ProductData;

public class ISO8601Converter {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSX");
    private static final int MILLI_TO_MICRO = 1000;

    public static ProductData.UTC parse(String iso8601String) throws ParseException {
        TemporalAccessor accessor = FORMATTER.parse(iso8601String);
        ZonedDateTime time = ZonedDateTime.from(accessor);
        Date date = Date.from(time.toInstant());
        return ProductData.UTC.create(date, time.get(ChronoField.MICRO_OF_SECOND));
    }

    public static String format(ProductData.UTC utc) {
        Calendar asCalendar = utc.getAsCalendar();
        OffsetDateTime odt = OffsetDateTime.of(asCalendar.get(1), asCalendar.get(2) + 1, asCalendar.get(5), asCalendar.get(11), asCalendar.get(12), asCalendar.get(13), (int)utc.getMicroSecondsFraction() * 1000, ZoneOffset.UTC);
        return odt.format(FORMATTER);
    }
}

