/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.util.logging.Level;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.VersionChecker;
import org.esa.snap.runtime.Activator;

public class EngineVersionCheckActivator
implements Activator {
    private static final String MSG_UPDATE_INFO = "A new SNAP version is available for download.\nCurrently installed %s, available is %s.\nPlease visit %s\n";
    private static final VersionChecker VERSION_CHECKER = VersionChecker.getInstance();
    private static boolean hasChecked = false;

    public void start() {
        SystemUtils.LOG.log(Level.INFO, "Please check regularly for new updates for the best SNAP experience.");
        if (VERSION_CHECKER.mustCheck()) {
            hasChecked = true;
            if (VERSION_CHECKER.checkForNewRelease()) {
                String localVersion = String.valueOf(VERSION_CHECKER.getLocalVersion());
                String remoteVersion = String.valueOf(VERSION_CHECKER.getRemoteVersion());
                String logMsg = String.format(MSG_UPDATE_INFO, localVersion, remoteVersion, SystemUtils.getApplicationHomepageUrl());
                SystemUtils.LOG.log(Level.WARNING, logMsg);
            }
        }
    }

    public void stop() {
        if (hasChecked) {
            VERSION_CHECKER.setChecked();
        }
    }

    public int getStartLevel() {
        return 1000;
    }
}

