/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Random;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class DummyProductBuilder {
    private Size size = Size.SMALL;
    private SizeOcc sizeOcc = SizeOcc.SINGLE;
    private I2M i2m = I2M.NOT_SET;
    private GC gc = GC.NONE;
    private GCOcc gcOcc = GCOcc.UNIQUE;
    private GP gp = GP.NULL_MERIDIAN;
    static int i2mCounter = 0;
    static AffineTransform[] transforms = new AffineTransform[]{AffineTransform.getRotateInstance(1.0471975511965976), AffineTransform.getRotateInstance(0.6283185307179586), AffineTransform.getRotateInstance(0.4487989505128276)};

    public DummyProductBuilder size(Size size) {
        this.size = size;
        return this;
    }

    public DummyProductBuilder sizeOcc(SizeOcc sizeOcc) {
        this.sizeOcc = sizeOcc;
        return this;
    }

    public DummyProductBuilder i2m(I2M i2m) {
        this.i2m = i2m;
        return this;
    }

    public DummyProductBuilder gc(GC gc) {
        this.gc = gc;
        return this;
    }

    public DummyProductBuilder gcOcc(GCOcc gcOcc) {
        this.gcOcc = gcOcc;
        return this;
    }

    public DummyProductBuilder gp(GP gp) {
        this.gp = gp;
        return this;
    }

    public static Product[] createTestProducts() {
        DummyProductBuilder builder = new DummyProductBuilder();
        return new Product[]{builder.size(Size.MEDIUM).sizeOcc(SizeOcc.SINGLE).gc(GC.TIE_POINTS).gcOcc(GCOcc.UNIQUE).gp(GP.NULL_MERIDIAN).create(), builder.size(Size.MEDIUM).sizeOcc(SizeOcc.SINGLE).gc(GC.TIE_POINTS).gcOcc(GCOcc.UNIQUE).gp(GP.ANTI_MERIDIAN).create(), builder.size(Size.MEDIUM).sizeOcc(SizeOcc.MULTI).gc(GC.TIE_POINTS).gcOcc(GCOcc.UNIQUE).gp(GP.NULL_MERIDIAN).i2m(I2M.NOT_SET).create(), builder.size(Size.MEDIUM).sizeOcc(SizeOcc.MULTI).gc(GC.TIE_POINTS).gcOcc(GCOcc.UNIQUE).gp(GP.NULL_MERIDIAN).i2m(I2M.SET_CONGRUENT).create(), builder.size(Size.MEDIUM).sizeOcc(SizeOcc.MULTI).gc(GC.TIE_POINTS).gcOcc(GCOcc.UNIQUE).gp(GP.NULL_MERIDIAN).i2m(I2M.SET_INCONGRUENT).create(), builder.size(Size.MEDIUM).sizeOcc(SizeOcc.MULTI).gc(GC.TIE_POINTS).gcOcc(GCOcc.UNIQUE).gp(GP.NULL_MERIDIAN).i2m(I2M.SET_PROPORTIONAL).create(), builder.size(Size.LARGE).sizeOcc(SizeOcc.SINGLE).gc(GC.MAP).gcOcc(GCOcc.UNIQUE).gp(GP.NULL_MERIDIAN).create(), builder.size(Size.LARGE).sizeOcc(SizeOcc.SINGLE).gc(GC.MAP).gcOcc(GCOcc.UNIQUE).gp(GP.ANTI_MERIDIAN).create(), builder.size(Size.LARGE).sizeOcc(SizeOcc.MULTI).gc(GC.MAP).gcOcc(GCOcc.UNIQUE).gp(GP.NULL_MERIDIAN).create()};
    }

    public Product create() {
        int ny;
        Object[] objectArray = new Object[6];
        Object object = this.size == Size.SMALL ? "S" : (this.size == Size.MEDIUM ? "M" : (objectArray[0] = this.size == Size.LARGE ? "L" : "x"));
        Object object2 = this.sizeOcc == SizeOcc.MULTI ? "N" : (this.sizeOcc == SizeOcc.SINGLE ? "1" : (objectArray[1] = this.sizeOcc == SizeOcc.NONE ? "0" : "x"));
        Object object3 = this.i2m == I2M.NOT_SET ? "N" : (this.i2m == I2M.SET_CONGRUENT ? "C" : (this.i2m == I2M.SET_INCONGRUENT ? "I" : (objectArray[2] = this.i2m == I2M.SET_PROPORTIONAL ? "P" : "x")));
        Object object4 = this.gc == GC.NONE ? "0" : (this.gc == GC.MAP ? "M" : (this.gc == GC.TIE_POINTS ? "T" : (objectArray[3] = this.gc == GC.PER_PIXEL ? "P" : "x")));
        Object object5 = this.gcOcc == GCOcc.UNIQUE ? "U" : (objectArray[4] = this.gcOcc == GCOcc.VARIOUS ? "V" : "x");
        objectArray[5] = this.gp == GP.NULL_MERIDIAN ? "M" : (this.gp == GP.ANTI_MERIDIAN ? "A" : (this.gp == GP.NORTH_POLE ? "N" : (this.gp == GP.SOUTH_POLE ? "S" : "x")));
        String name = String.format("test_sz_%s(%s)_i2m_%s_gc_%s(%s)_gp_%s", objectArray);
        String description = String.format("size:%s(%s), i2m:%s, geo-coding:%s(%s), geo-pos:%s", new Object[]{this.size, this.sizeOcc, this.i2m, this.gc, this.gcOcc, this.gp});
        int sceneRasterWidth = 1800;
        int sceneRasterHeight = 3600;
        int gridWidth = sceneRasterWidth / 10;
        int gridHeight = sceneRasterHeight / 10;
        int tileSize = 512;
        if (this.size == Size.LARGE) {
            sceneRasterWidth *= 15;
            sceneRasterHeight *= 15;
            gridWidth *= 15;
            gridHeight *= 15;
            tileSize = 2048;
        } else if (this.size == Size.SMALL) {
            sceneRasterWidth /= 15;
            sceneRasterHeight /= 15;
            gridWidth /= 15;
            gridHeight /= 15;
            tileSize = 256;
        }
        int nx = sceneRasterWidth / gridWidth;
        if (nx * gridWidth <= sceneRasterWidth) {
            gridWidth = sceneRasterWidth / nx + 1;
        }
        if ((ny = sceneRasterHeight / gridHeight) * gridHeight <= sceneRasterHeight) {
            gridHeight = sceneRasterHeight / ny + 1;
        }
        Product product = new Product(name, name, sceneRasterWidth, sceneRasterHeight);
        product.setDescription(description);
        product.setPreferredTileSize(tileSize, tileSize);
        product.getMetadataRoot().addElement(new MetadataElement("Global_Attributes"));
        product.getMetadataRoot().addElement(new MetadataElement("Local_Attributes"));
        DummyProductBuilder.addRandomTiePointGrids(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight);
        String bandAExpr = "sin(4 * PI * sqrt( sq(0.5*X/%s - 1) + sq(0.5*Y/%s - 1) ))";
        String bandBExpr = "sin(4 * PI * sqrt( 2.0 * abs(0.5*X/%s * 0.5*Y/%s) ))";
        String bandCExpr = "cos( X/180 ) * cos( Y/180 )";
        String bandDExpr = "max(cos( X/180 ), cos( Y/180 ))";
        String maskAExpr = "band_a%s > 0.5";
        String maskBExpr = "band_b%s < 0.0";
        String maskCExpr = "band_c%1$s > -0.1 && band_c%1$s < 0.1";
        if (this.sizeOcc == SizeOcc.MULTI) {
            this.addMultiSizeBands(product, sceneRasterWidth, sceneRasterHeight, "band_a", bandAExpr, 500.0f, "mask_a", maskAExpr, Color.ORANGE);
            this.addMultiSizeBands(product, sceneRasterWidth, sceneRasterHeight, "band_b", bandBExpr, 600.0f, "mask_b", maskBExpr, Color.GREEN);
            this.addMultiSizeBands(product, sceneRasterWidth, sceneRasterHeight, "band_c", bandCExpr, 700.0f, "mask_c", maskCExpr, Color.BLUE);
            this.setMultiSizeGeoCodings(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, bandDExpr);
        } else if (this.sizeOcc == SizeOcc.SINGLE) {
            this.addSingleSizeBand(product, sceneRasterWidth, sceneRasterHeight, "band_a", bandAExpr, 500.0f, "mask_a", maskAExpr, Color.ORANGE);
            this.addSingleSizeBand(product, sceneRasterWidth, sceneRasterHeight, "band_b", bandBExpr, 600.0f, "mask_b", maskBExpr, Color.GREEN);
            this.addSingleSizeBand(product, sceneRasterWidth, sceneRasterHeight, "band_c", bandCExpr, 700.0f, "mask_c", maskCExpr, Color.BLUE);
            this.setSingleSizeGeoCoding(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, bandDExpr);
        } else {
            this.setSceneGeoCoding(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight);
        }
        product.setModified(false);
        return product;
    }

    private void setMultiSizeGeoCodings(Product product, int sceneRasterWidth, int sceneRasterHeight, int gridWidth, int gridHeight, String bandDExpr) {
        this.setSceneGeoCoding(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight);
        if (this.gc == GC.MAP) {
            HashMap<Dimension, GeoCoding[]> dimensionSet = new HashMap<Dimension, GeoCoding[]>();
            for (RasterDataNode rasterDataNode : product.getRasterDataNodes()) {
                dimensionSet.put(rasterDataNode.getRasterSize(), new GeoCoding[1]);
            }
            for (Dimension dimension : dimensionSet.keySet()) {
                ((GeoCoding[])dimensionSet.get((Object)dimension))[0] = DummyProductBuilder.createCrsGeoCoding(dimension.width, dimension.height, this.gp);
            }
            for (RasterDataNode rasterDataNode : product.getRasterDataNodes()) {
                rasterDataNode.setGeoCoding(((GeoCoding[])dimensionSet.get(rasterDataNode.getRasterSize()))[0]);
            }
            product.setSceneGeoCoding(((GeoCoding[])dimensionSet.get(product.getSceneRasterSize()))[0]);
            if (this.gcOcc == GCOcc.VARIOUS) {
                product.addBand("band_d", bandDExpr).setGeoCoding(DummyProductBuilder.createTiePointGeoCoding(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, this.gp));
            }
        } else if (this.gc == GC.TIE_POINTS) {
            if (this.gcOcc == GCOcc.VARIOUS) {
                product.addBand("band_d", bandDExpr).setGeoCoding(DummyProductBuilder.createCrsGeoCoding(sceneRasterWidth, sceneRasterHeight, this.gp));
            }
        } else if (this.gc == GC.PER_PIXEL && this.gcOcc == GCOcc.VARIOUS) {
            product.addBand("band_d", bandDExpr).setGeoCoding(DummyProductBuilder.createCrsGeoCoding(sceneRasterWidth, sceneRasterHeight, this.gp));
        }
    }

    private void setSingleSizeGeoCoding(Product product, int sceneRasterWidth, int sceneRasterHeight, int gridWidth, int gridHeight, String bandDExpr) {
        this.setSceneGeoCoding(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight);
        if (this.gc == GC.MAP) {
            if (this.gcOcc == GCOcc.VARIOUS) {
                product.addBand("band_d", bandDExpr).setGeoCoding(DummyProductBuilder.createTiePointGeoCoding(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, this.gp));
            }
        } else if (this.gc == GC.TIE_POINTS) {
            if (this.gcOcc == GCOcc.VARIOUS) {
                product.addBand("band_d", bandDExpr).setGeoCoding(DummyProductBuilder.createCrsGeoCoding(sceneRasterWidth, sceneRasterHeight, this.gp));
            }
        } else if (this.gc == GC.PER_PIXEL && this.gcOcc == GCOcc.VARIOUS) {
            product.addBand("band_d", bandDExpr).setGeoCoding(DummyProductBuilder.createCrsGeoCoding(sceneRasterWidth, sceneRasterHeight, this.gp));
        }
    }

    private void setSceneGeoCoding(Product product, int sceneRasterWidth, int sceneRasterHeight, int gridWidth, int gridHeight) {
        if (this.gc == GC.NONE) {
            product.setSceneGeoCoding(null);
        } else if (this.gc == GC.MAP) {
            product.setSceneGeoCoding(DummyProductBuilder.createCrsGeoCoding(sceneRasterWidth, sceneRasterHeight, this.gp));
        } else if (this.gc == GC.TIE_POINTS) {
            product.setSceneGeoCoding(DummyProductBuilder.createTiePointGeoCoding(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, this.gp));
        } else if (this.gc == GC.PER_PIXEL) {
            product.setSceneGeoCoding(DummyProductBuilder.createPixelGeoCoding(product, sceneRasterWidth, sceneRasterHeight, this.gp));
        }
    }

    private static PixelGeoCoding createPixelGeoCoding(Product product, int sceneRasterWidth, int sceneRasterHeight, GP gp) {
        DummyProductBuilder.addLatLonBands(product, sceneRasterWidth, sceneRasterHeight, gp);
        return new PixelGeoCoding(product.getBand("latitude"), product.getBand("longitude"), null, 10);
    }

    private static TiePointGeoCoding createTiePointGeoCoding(Product product, int sceneRasterWidth, int sceneRasterHeight, int gridWidth, int gridHeight, GP gp) {
        DummyProductBuilder.addLatLonTiePointGrids(product, sceneRasterWidth, sceneRasterHeight, gridWidth, gridHeight, gp);
        return new TiePointGeoCoding(product.getTiePointGrid("latitude"), product.getTiePointGrid("longitude"));
    }

    private static CrsGeoCoding createCrsGeoCoding(int imageWidth, int imageHeight, GP gp) {
        try {
            double extend = 10.0;
            double pixelSize = extend / (double)imageWidth;
            double easting = 0.0;
            double northing = 0.0;
            return new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, imageWidth, imageHeight, easting, northing, pixelSize, pixelSize, 0.0, 0.0);
        }
        catch (FactoryException | TransformException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addSingleSizeBand(Product product, int sceneRasterWidth, int sceneRasterHeight, String bandName, String bandExpr, float bandWavelength, String maskName, String maskExpr, Color maskColor) {
        Band band = product.addBand(bandName, String.format(bandExpr, sceneRasterWidth, sceneRasterHeight));
        band.setSpectralWavelength(bandWavelength);
        Mask mask = product.addMask(maskName, String.format(maskExpr, ""), String.format(maskExpr, ""), maskColor, 0.5);
        AffineTransform i2mTransform = this.getImageToModelTransform(sceneRasterWidth, 1);
        if (i2mTransform != null) {
            band.setImageToModelTransform(i2mTransform);
            mask.setImageToModelTransform(i2mTransform);
        }
    }

    private void addMultiSizeBands(Product product, int width, int height, String bandName, String bandExpr, float bandWavelength, String maskName, String maskExpr, Color maskColor) {
        this.addMultiSizeBand(product, 1, width, height, bandName, bandExpr, bandWavelength, maskName, maskExpr, maskColor);
        this.addMultiSizeBand(product, 2, width, height, bandName, bandExpr, bandWavelength + 10.0f, maskName, maskExpr, maskColor.brighter());
        this.addMultiSizeBand(product, 6, width, height, bandName, bandExpr, bandWavelength + 20.0f, maskName, maskExpr, maskColor.darker());
    }

    private void addMultiSizeBand(Product product, int divisor, int width, int height, String bandName, String bandExpr, float bandWavelength, String maskName, String maskExpr, Color maskColor) {
        VirtualBand band = new VirtualBand(bandName + "_" + divisor, 30, width / divisor, height / divisor, String.format(bandExpr, width / divisor, height / divisor));
        band.setSpectralWavelength(bandWavelength);
        product.addBand(band);
        maskName = (String)maskName + "_" + divisor;
        maskExpr = String.format(maskExpr, "_" + divisor);
        Mask mask = Mask.BandMathsType.create((String)maskName, maskExpr, width / divisor, height / divisor, maskExpr, maskColor, 0.5);
        AffineTransform i2mTransform = this.getImageToModelTransform(width, divisor);
        if (i2mTransform != null) {
            band.setImageToModelTransform(i2mTransform);
            mask.setImageToModelTransform(i2mTransform);
        }
        product.addMask(mask);
    }

    private AffineTransform getImageToModelTransform(int width, int divisor) {
        AffineTransform i2mTransform = null;
        if (this.i2m == I2M.SET_CONGRUENT) {
            i2mTransform = AffineTransform.getScaleInstance(divisor, divisor);
        } else if (this.i2m == I2M.SET_INCONGRUENT) {
            i2mTransform = AffineTransform.getScaleInstance(divisor, divisor);
            i2mTransform.concatenate(transforms[i2mCounter++ % transforms.length]);
        } else if (this.i2m == I2M.SET_PROPORTIONAL) {
            i2mTransform = AffineTransform.getScaleInstance(0.1 * (double)width, 0.1 * (double)width);
        }
        return i2mTransform;
    }

    private static float[] createRandomPoints(int n) {
        Random random = new Random();
        float[] pnts = new float[n];
        for (int i = 0; i < pnts.length; ++i) {
            pnts[i] = (float)random.nextGaussian();
        }
        return pnts;
    }

    private static void addRandomTiePointGrids(Product product, int sceneRasterWidth, int sceneRasterHeight, int gridWidth, int gridHeight) {
        double subSamplingX = (double)sceneRasterWidth / ((double)gridWidth - 1.0);
        double subSamplingY = (double)sceneRasterHeight / ((double)gridHeight - 1.0);
        product.addTiePointGrid(new TiePointGrid("tpgrid_a", gridWidth, gridHeight, 0.0, 0.0, subSamplingX, subSamplingY, DummyProductBuilder.createRandomPoints(gridWidth * gridHeight)));
        product.addTiePointGrid(new TiePointGrid("tpgrid_b", gridWidth, gridHeight, 0.0, 0.0, subSamplingX, subSamplingY, DummyProductBuilder.createRandomPoints(gridWidth * gridHeight)));
    }

    private static void addLatLonBands(Product product, int sceneRasterWidth, int sceneRasterHeight, GP GP2) {
        float[] lonData = new float[sceneRasterWidth * sceneRasterHeight];
        float[] latData = new float[sceneRasterWidth * sceneRasterHeight];
        DummyProductBuilder.computeLonLat(GP2, 0.2, sceneRasterWidth, sceneRasterHeight, lonData, latData);
        Band longitudeBand = new Band("longitude", 30, sceneRasterWidth, sceneRasterHeight);
        longitudeBand.setRasterData(ProductData.createInstance(lonData));
        product.addBand(longitudeBand);
        Band latitudeBand = new Band("latitude", 30, sceneRasterWidth, sceneRasterHeight);
        latitudeBand.setRasterData(ProductData.createInstance(latData));
        product.addBand(latitudeBand);
    }

    private static void addLatLonTiePointGrids(Product product, int sceneRasterWidth, int sceneRasterHeight, int gridWidth, int gridHeight, GP GP2) {
        float[] lonData = new float[gridWidth * gridHeight];
        float[] latData = new float[gridWidth * gridHeight];
        DummyProductBuilder.computeLonLat(GP2, 0.2, gridWidth, gridHeight, lonData, latData);
        double subSamplingX = (double)sceneRasterWidth / ((double)gridWidth - 1.0);
        double subSamplingY = (double)sceneRasterHeight / ((double)gridHeight - 1.0);
        product.addTiePointGrid(new TiePointGrid("longitude", gridWidth, gridHeight, 0.0, 0.0, subSamplingX, subSamplingY, lonData));
        product.addTiePointGrid(new TiePointGrid("latitude", gridWidth, gridHeight, 0.0, 0.0, subSamplingX, subSamplingY, latData));
    }

    private static void computeLonLat(GP gp, double extend, int gridWidth, int gridHeight, float[] lonData, float[] latData) {
        double sizeX = extend;
        double sizeY = extend * (double)gridHeight / (double)gridWidth;
        for (int j = 0; j < gridHeight; ++j) {
            for (int i = 0; i < gridWidth; ++i) {
                double x = 1.0;
                double y = sizeX * ((double)i / ((double)gridWidth - 1.0) - 0.5);
                double z = 0.5 * sizeY - sizeY * ((double)j / ((double)gridHeight - 1.0) - 0.5);
                double[] p0 = new double[]{x, y, z};
                double[] p = gp == GP.ANTI_MERIDIAN ? DummyProductBuilder.rotZ(Math.PI, p0) : (gp == GP.NORTH_POLE ? DummyProductBuilder.rotY(1.5707963267948966, p0) : (gp == GP.SOUTH_POLE ? DummyProductBuilder.rotY(1.5707963267948966, p0) : p0));
                double r = Math.sqrt(p[0] * p[0] + p[1] * p[1] + p[2] * p[2]);
                x = p[0] / r;
                y = p[1] / r;
                z = p[2] / r;
                double r2 = Math.sqrt(x * x + y * y);
                double lon = 180.0 * Math.atan2(y, x) / Math.PI;
                double lat = 180.0 * Math.atan2(z, r2) / Math.PI;
                lonData[j * gridWidth + i] = (float)lon;
                latData[j * gridWidth + i] = (float)lat;
            }
        }
    }

    private static double[] rotX(double a, double[] in) {
        return DummyProductBuilder.rotX(a, in, new double[3]);
    }

    private static double[] rotY(double a, double[] in) {
        return DummyProductBuilder.rotY(a, in, new double[3]);
    }

    private static double[] rotZ(double a, double[] in) {
        return DummyProductBuilder.rotZ(a, in, new double[3]);
    }

    private static double[] rotX(double a, double[] in, double[] out) {
        double x = in[0];
        double y = in[1];
        double z = in[2];
        out[0] = x;
        out[1] = y * Math.cos(a) - z * Math.sin(a);
        out[2] = y * Math.sin(a) + z * Math.cos(a);
        return out;
    }

    private static double[] rotY(double a, double[] in, double[] out) {
        double x = in[0];
        double y = in[1];
        double z = in[2];
        out[1] = y;
        out[0] = z * Math.sin(a) + x * Math.cos(a);
        out[2] = z * Math.cos(a) - x * Math.sin(a);
        return out;
    }

    private static double[] rotZ(double a, double[] in, double[] out) {
        double x = in[0];
        double y = in[1];
        double z = in[2];
        out[0] = x * Math.cos(a) - y * Math.sin(a);
        out[1] = x * Math.sin(a) + y * Math.cos(a);
        out[2] = z;
        return out;
    }

    public static enum I2M {
        NOT_SET,
        SET_PROPORTIONAL,
        SET_INCONGRUENT,
        SET_CONGRUENT;

    }

    public static enum GP {
        NULL_MERIDIAN,
        ANTI_MERIDIAN,
        NORTH_POLE,
        SOUTH_POLE;

    }

    public static enum GCOcc {
        UNIQUE,
        VARIOUS;

    }

    public static enum GC {
        NONE,
        MAP,
        TIE_POINTS,
        PER_PIXEL;

    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE;

    }

    public static enum SizeOcc {
        NONE,
        SINGLE,
        MULTI;

    }
}

