/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.ProductData;

public class DateTimeUtils {
    public static final SimpleDateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    public static final SimpleDateFormat ISO_8601_UTC_FORMAT = (SimpleDateFormat)ISO_8601_FORMAT.clone();
    public static final double JD_OFFSET = 2440587.5;
    public static final double MJD_OFFSET = 2400000.5;
    public static final double HOURS_PER_DAY = 24.0;
    public static final double SECONDS_PER_DAY = 86400.0;
    public static final double MILLIS_PER_DAY = 8.64E7;
    public static final double MICROS_PER_DAY = 8.64E10;

    public static double jdToMJD(double jd) {
        return jd - 2400000.5;
    }

    public static double mjdToJD(double mjd) {
        return 2400000.5 + mjd;
    }

    public static Date jdToUTC(double jd) {
        long millis = Math.round((jd - 2440587.5) * 8.64E7);
        return new Date(millis);
    }

    public static double utcToJD(Date utc) {
        long millis = utc != null ? utc.getTime() : System.currentTimeMillis();
        return 2440587.5 + (double)millis / 8.64E7;
    }

    public static String utcToString(Date utc) {
        return ISO_8601_UTC_FORMAT.format(utc != null ? utc : new Date());
    }

    public static Date stringToUTC(String utc) throws ParseException {
        return ISO_8601_UTC_FORMAT.parse(utc);
    }

    public static LocalDateTime calendarToLocalDateTime(Calendar utc) {
        return LocalDateTime.ofInstant(utc.toInstant(), utc.getTimeZone().toZoneId());
    }

    public static Date average(Date startDate, Date endDate) {
        Date averageDate = null;
        if (startDate != null && endDate != null) {
            BigInteger averageMillis = BigInteger.valueOf(startDate.getTime()).add(BigInteger.valueOf(endDate.getTime())).divide(BigInteger.valueOf(2L));
            averageDate = new Date(averageMillis.longValue());
        }
        return averageDate;
    }

    public static ProductData.UTC average(ProductData.UTC startDate, ProductData.UTC endDate) {
        ProductData.UTC average = null;
        if (startDate != null && endDate != null) {
            BigInteger averageMillis = BigInteger.valueOf(startDate.getAsDate().getTime()).add(BigInteger.valueOf(endDate.getAsDate().getTime())).divide(BigInteger.valueOf(2L));
            Date averageDate = new Date(averageMillis.longValue());
            average = ProductData.UTC.create(averageDate, 0L);
        }
        return average;
    }

    public static ProductData.UTC parseDate(String stringData, String dateFormat) {
        ProductData.UTC parsedDate = null;
        if (stringData != null) {
            try {
                if (((String)stringData).endsWith("Z")) {
                    stringData = ((String)stringData).substring(0, ((String)stringData).length() - 1);
                }
                if (!((String)stringData).contains(".") && dateFormat.contains(".")) {
                    stringData = (String)stringData + ".000000";
                }
                Long microseconds = 0L;
                if (dateFormat.contains(".")) {
                    Object stringMicroseconds = ((String)stringData).substring(((String)stringData).indexOf(".") + 1);
                    if (((String)stringMicroseconds).length() > 6) {
                        stringMicroseconds = ((String)stringMicroseconds).substring(0, 6);
                    } else {
                        while (((String)stringMicroseconds).length() < 6) {
                            stringMicroseconds = (String)stringMicroseconds + "0";
                        }
                    }
                    microseconds = Long.parseLong((String)stringMicroseconds);
                    stringData = ((String)stringData).substring(0, ((String)stringData).lastIndexOf("."));
                    dateFormat = dateFormat.substring(0, dateFormat.lastIndexOf("."));
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                simpleDateFormat.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                Date date = simpleDateFormat.parse((String)stringData);
                parsedDate = ProductData.UTC.create(date, microseconds);
            }
            catch (ParseException e) {
                Logger.getLogger(DateTimeUtils.class.getName()).warning(String.format("Date not in expected format. Found %s, expected %s", stringData, dateFormat));
            }
        }
        return parsedDate;
    }

    static {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        ISO_8601_UTC_FORMAT.setCalendar(calendar);
    }
}

