/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollectionHelper {
    public static <T> T firstOrDefault(Collection<T> collection, Predicate<T> condition) {
        T result = null;
        if (collection != null) {
            if (condition != null) {
                List<T> subset = CollectionHelper.where(collection, condition);
                if (subset != null && subset.size() > 0) {
                    result = subset.get(0);
                }
            } else {
                result = collection.iterator().next();
            }
        }
        return result;
    }

    public static <T> T firstOrDefault(T[] array, Predicate<T> condition) {
        T result = null;
        if (array != null) {
            if (condition != null) {
                List<T> subset = CollectionHelper.where(array, condition);
                if (subset != null && subset.size() > 0) {
                    result = subset.get(0);
                }
            } else {
                result = array[0];
            }
        }
        return result;
    }

    public static <T> List<T> where(Collection<T> collection, Predicate<T> filter) {
        List<Object> result = null;
        if (collection != null) {
            result = filter != null ? CollectionHelper.where(collection.stream(), filter) : (collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection));
        }
        return result;
    }

    public static <T> List<T> where(T[] array, Predicate<T> filter) {
        List<T> result = null;
        if (array != null) {
            result = filter != null ? CollectionHelper.where(Arrays.stream(array), filter) : Arrays.asList(array);
        }
        return result;
    }

    private static <T> List<T> where(Stream<T> stream, Predicate<T> filter) {
        return stream.filter(filter).collect(Collectors.toList());
    }
}

