/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.converters.ColorConverter;
import com.bc.ceres.binding.converters.FontConverter;
import java.awt.Color;
import java.awt.Font;
import org.esa.snap.core.util.PropertyMap;

public abstract class AbstractPropertyMap
implements PropertyMap {
    public static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    public static final Color DEFAULT_COLOR = Color.BLACK;

    @Override
    public boolean getPropertyBool(String key) {
        return this.getPropertyBool(key, false);
    }

    @Override
    public Boolean getPropertyBool(String key, Boolean defaultValue) {
        String value = this.get(key);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    @Override
    public void setPropertyBool(String key, Boolean newValue) {
        this.set(key, newValue != null ? Boolean.toString(newValue) : null);
    }

    @Override
    public int getPropertyInt(String key) {
        return this.getPropertyInt(key, 0);
    }

    @Override
    public Integer getPropertyInt(String key, Integer defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setPropertyInt(String key, Integer value) {
        this.set(key, value != null ? Integer.toString(value) : null);
    }

    @Override
    public double getPropertyDouble(String key) {
        return this.getPropertyDouble(key, 0.0);
    }

    @Override
    public Double getPropertyDouble(String key, Double defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setPropertyDouble(String key, Double value) {
        this.set(key, value != null ? Double.toString(value) : null);
    }

    @Override
    public String getPropertyString(String key) {
        return this.get(key, "");
    }

    @Override
    public String getPropertyString(String key, String defaultValue) {
        return this.get(key, defaultValue);
    }

    @Override
    public void setPropertyString(String key, String value) {
        this.set(key, value);
    }

    @Override
    public Color getPropertyColor(String key) {
        return this.getPropertyColor(key, DEFAULT_COLOR);
    }

    @Override
    public Color getPropertyColor(String key, Color defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return ColorConverter.INSTANCE.parse(value);
        }
        catch (ConversionException e) {
            return DEFAULT_COLOR;
        }
    }

    @Override
    public void setPropertyColor(String key, Color value) {
        this.set(key, ColorConverter.INSTANCE.format(value));
    }

    @Override
    public Font getPropertyFont(String key) {
        return this.getPropertyFont(key, DEFAULT_FONT);
    }

    @Override
    public Font getPropertyFont(String key, Font defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return FontConverter.INSTANCE.parse(value);
        }
        catch (ConversionException e) {
            return DEFAULT_FONT;
        }
    }

    @Override
    public void setPropertyFont(String key, Font font) {
        String value = null;
        if (font != null) {
            value = FontConverter.INSTANCE.format(font);
        }
        this.set(key, value);
    }

    protected abstract String get(String var1);

    protected abstract String get(String var1, String var2);

    protected abstract String set(String var1, String var2);

    protected abstract void firePropertyChange(String var1, String var2, String var3);
}

