/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.subset;

import java.awt.Rectangle;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.subset.AbstractSubsetRegion;
import org.esa.snap.core.util.GeoUtils;
import org.locationtech.jts.geom.Geometry;

public class GeometrySubsetRegion
extends AbstractSubsetRegion {
    private final Geometry geometryRegion;

    public GeometrySubsetRegion(Geometry geometryRegion, int borderPixels) {
        super(borderPixels);
        if (geometryRegion == null) {
            throw new NullPointerException("The geometry region is null.");
        }
        this.geometryRegion = geometryRegion;
    }

    @Override
    public Rectangle computeProductPixelRegion(GeoCoding productDefaultGeoCoding, int defaultProductWidth, int defaultProductHeight, boolean roundPixelRegion) {
        this.validateDefaultSize(defaultProductWidth, defaultProductHeight, "The default product");
        if (productDefaultGeoCoding == null) {
            throw new NullPointerException("The pixel region cannot be computed because the product GeoCoding is missing.");
        }
        return GeoUtils.computePixelRegionUsingGeometry(productDefaultGeoCoding, defaultProductWidth, defaultProductHeight, this.geometryRegion, this.borderPixels, roundPixelRegion, false);
    }

    @Override
    public Rectangle computeBandPixelRegion(GeoCoding productDefaultGeoCoding, GeoCoding bandDefaultGeoCoding, int defaultProductWidth, int defaultProductHeight, int defaultBandWidth, int defaultBandHeight, boolean roundPixelRegion) {
        this.validateDefaultSize(defaultProductWidth, defaultProductHeight, "The default product");
        super.validateDefaultSize(defaultBandWidth, defaultBandHeight, "The default band");
        if (defaultProductWidth != defaultBandWidth || defaultProductHeight != defaultBandHeight) {
            if (bandDefaultGeoCoding == null) {
                throw new NullPointerException("The pixel region cannot be computed because the band GeoCoding is missing of the multi size product.");
            }
            return GeoUtils.computePixelRegionUsingGeometry(bandDefaultGeoCoding, defaultBandWidth, defaultBandHeight, this.geometryRegion, this.borderPixels, roundPixelRegion, false);
        }
        if (productDefaultGeoCoding == null) {
            throw new NullPointerException("The pixel region cannot be computed because the product GeoCoding is missing.");
        }
        return GeoUtils.computePixelRegionUsingGeometry(productDefaultGeoCoding, defaultProductWidth, defaultProductHeight, this.geometryRegion, this.borderPixels, roundPixelRegion, false);
    }
}

