/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.param.editors;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;
import org.esa.snap.core.param.AbstractParamEditor;
import org.esa.snap.core.param.ParamProperties;
import org.esa.snap.core.param.Parameter;

public class TextFieldEditor
extends AbstractParamEditor {
    private JTextComponent _textComponent;
    private JComponent _component;
    private FocusListener _focusListener;

    public TextFieldEditor(Parameter parameter) {
        super(parameter, true);
    }

    public JTextComponent getTextComponent() {
        return this._textComponent;
    }

    private void setTextComponent(JTextComponent textComponent) {
        if (this._textComponent != null) {
            this._textComponent.removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        this._textComponent = textComponent;
        if (this._textComponent != null) {
            this._focusListener = this.createFocusListener();
            this._textComponent.addFocusListener(this._focusListener);
        }
        if (this._textComponent instanceof JTextArea) {
            this._textComponent.setBorder(null);
            JScrollPane pane = new JScrollPane(this._textComponent);
            this.nameComponent(this._component, "ScrollPane");
            pane.setMinimumSize(this._textComponent.getPreferredSize());
            this._component = pane;
        } else {
            this._component = this._textComponent;
        }
    }

    @Override
    public JComponent getEditorComponent() {
        return this.getTextComponent();
    }

    @Override
    public JComponent getComponent() {
        return this._component;
    }

    @Override
    protected void initUI() {
        JTextComponent textComponent;
        super.initUI();
        int numCols = this.getParamProps().getNumCols();
        int numRows = this.getParamProps().getNumRows();
        if (numRows <= 1) {
            textComponent = new JTextField();
            this.nameEditorComponent(textComponent);
            if (numCols <= 0) {
                if (this.getParameter().isTypeOf(Character.class)) {
                    ((JTextField)textComponent).setColumns(2);
                } else if (this.getParameter().isTypeOf(Byte.class)) {
                    ((JTextField)textComponent).setColumns(4);
                } else if (this.getParameter().isTypeOf(Short.class)) {
                    ((JTextField)textComponent).setColumns(6);
                } else if (this.getParameter().isTypeOf(Integer.class)) {
                    ((JTextField)textComponent).setColumns(8);
                } else if (this.getParameter().isTypeOf(Long.class)) {
                    ((JTextField)textComponent).setColumns(8);
                } else if (this.getParameter().isTypeOf(Float.class)) {
                    ((JTextField)textComponent).setColumns(8);
                } else if (this.getParameter().isTypeOf(Double.class)) {
                    ((JTextField)textComponent).setColumns(8);
                } else {
                    ((JTextField)textComponent).setColumns(24);
                }
            } else {
                ((JTextField)textComponent).setColumns(numCols);
            }
            if (this.getParameter().isTypeOf(Number.class)) {
                ((JTextField)textComponent).setHorizontalAlignment(4);
            }
            ((JTextField)textComponent).addActionListener(this.getDefaultActionListener());
            this.setTextComponent(textComponent);
        } else {
            textComponent = new JTextArea();
            this.nameEditorComponent(textComponent);
            ((JTextArea)textComponent).setRows(numRows);
            if (numCols > 0) {
                ((JTextArea)textComponent).setColumns(numCols);
            }
            if (this.getParamProps().getPropertyValue("wordWrap", false)) {
                ((JTextArea)textComponent).setLineWrap(true);
                ((JTextArea)textComponent).setWrapStyleWord(true);
            }
            textComponent.setBorder(new EtchedBorder(1));
            this.setTextComponent(textComponent);
        }
        if (this.getParamProps().getDescription() != null) {
            this._textComponent.setToolTipText(this.getParamProps().getDescription());
        }
        boolean enabled = !this.getParamProps().isReadOnly();
        this._textComponent.setEnabled(enabled);
        this._component.setEnabled(enabled);
        this._textComponent.setInputVerifier(this.getDefaultInputVerifier());
    }

    private ParamProperties getParamProps() {
        return this.getParameter().getProperties();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        String text = this.getParameter().getValueAsText();
        if (!this.getTextComponent().getText().equals(text)) {
            this.getTextComponent().setText(text);
        }
        if (this.getTextComponent().isEnabled() != this.isEnabled()) {
            if (this.getParameter().getProperties().isReadOnly()) {
                this.getTextComponent().setEnabled(false);
                this.getComponent().setEnabled(false);
            } else {
                this.getTextComponent().setEnabled(this.isEnabled());
                this.getComponent().setEnabled(this.isEnabled());
            }
        }
    }

    private FocusAdapter createFocusListener() {
        ParamProperties paramProperties = this.getParameter().getProperties();
        boolean selectAll = paramProperties.getPropertyValue("selectAllOnFocus", true);
        if (selectAll) {
            return new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    JTextComponent tc = (JTextComponent)e.getComponent();
                    tc.setCaretPosition(tc.getText().length());
                    tc.moveCaretPosition(0);
                }
            };
        }
        return new FocusAdapter(){};
    }
}

