/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.param.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.esa.snap.core.param.AbstractParamXEditor;
import org.esa.snap.core.param.Parameter;

public class ColorEditor
extends AbstractParamXEditor {
    private ColorDisplay _colorDisplay;

    public ColorEditor(Parameter parameter) {
        super(parameter, false);
    }

    public ColorDisplay getColorDisplay() {
        return this._colorDisplay;
    }

    @Override
    public JComponent getEditorComponentChild() {
        return this.getColorDisplay();
    }

    @Override
    protected void initUIChild() {
        this._colorDisplay = new ColorDisplay();
        this.nameComponent(this._colorDisplay, "ColorDisplay");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getColorDisplay().isEnabled() != this.isEnabled()) {
            this.getColorDisplay().setEnabled(this.isEnabled());
        }
        this.getColorDisplay().repaint();
    }

    @Override
    protected void invokeXEditor() {
        Color color = JColorChooser.showDialog(this.getEditorComponent(), "Select Colour", this.getParameterColorValue());
        if (color != null) {
            this.setParameterColorValue(color);
        }
    }

    private Color getParameterColorValue() {
        Color color = (Color)this.getParameter().getValue();
        return color == null ? Color.black : color;
    }

    private void setParameterColorValue(Color color) {
        this.getParameter().setValue(color, null);
    }

    class ColorDisplay
    extends JComponent {
        public ColorDisplay() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1), BorderFactory.createLineBorder(Color.darkGray)));
        }

        @Override
        public Dimension getMinimumSize() {
            return ColorEditor.this.getXEditorButton().getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Runtime.getRuntime().maxMemory();
            Dimension size1 = ColorEditor.this.getXEditorButton().getPreferredSize();
            Dimension size2 = new JTextField(1).getPreferredSize();
            int height = Math.max(size1.height, size2.height);
            return new Dimension(3 * height, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle b = this.getBounds();
            Insets i = this.getInsets();
            g.setColor(ColorEditor.this.getParameterColorValue());
            g.fillRect(b.x + i.left, b.y + i.top, b.width - (i.left + i.right), b.height - (i.top + i.bottom));
            super.paintComponent(g);
        }
    }
}

