/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.metadata;

import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.metadata.GenericXmlMetadata;
import org.esa.snap.core.metadata.XmlMetadataParser;

public class XmlMetadataParserFactory {
    private static Map<Class, XmlMetadataParser> parserMap = new HashMap<Class, XmlMetadataParser>();

    public static <T extends GenericXmlMetadata> void registerParser(Class clazz, XmlMetadataParser<T> parser) {
        if (!parserMap.containsKey(clazz)) {
            parserMap.put(clazz, parser);
        }
    }

    public static <T extends GenericXmlMetadata> XmlMetadataParser<T> getParser(Class clazz) throws InstantiationException {
        if (!parserMap.containsKey(clazz)) {
            throw new InstantiationException("No parser registered for metadata class " + clazz.getName());
        }
        XmlMetadataParser parser = parserMap.get(clazz);
        return parser;
    }
}

