/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.metadata;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.TreeSet;
import org.esa.snap.core.datamodel.GeoCoding;

public interface MetadataInspector {
    public Metadata getMetadata(Path var1) throws IOException;

    public static class Metadata {
        private final Set<String> bandList = new TreeSet<String>();
        private final Set<String> maskList = new TreeSet<String>();
        private int productWidth;
        private int productHeight;
        private GeoCoding geoCoding;

        public Metadata() {
            this(0, 0);
        }

        public Metadata(int productWidth, int productHeight) {
            this.setProductWidth(productWidth);
            this.setProductHeight(productHeight);
        }

        public void addBandName(String bandName) {
            this.bandList.add(bandName);
        }

        public void addMaskName(String maskName) {
            this.maskList.add(maskName);
        }

        public Set<String> getBandList() {
            return this.bandList;
        }

        public Set<String> getMaskList() {
            return this.maskList;
        }

        public boolean isHasMasks() {
            return !this.maskList.isEmpty();
        }

        public boolean isHasGeoCoding() {
            return this.geoCoding != null;
        }

        public int getProductWidth() {
            return this.productWidth;
        }

        public void setProductWidth(int productWidth) {
            this.productWidth = productWidth;
        }

        public int getProductHeight() {
            return this.productHeight;
        }

        public void setProductHeight(int productHeight) {
            this.productHeight = productHeight;
        }

        public GeoCoding getGeoCoding() {
            return this.geoCoding;
        }

        public void setGeoCoding(GeoCoding geoCoding) {
            this.geoCoding = geoCoding;
        }
    }
}

