/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.metadata;

import com.bc.ceres.core.Assert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.metadata.XmlMetadataParserFactory;
import org.xml.sax.SAXException;

public abstract class GenericXmlMetadata {
    protected static final String MISSING_ELEMENT_WARNING = "Metadata: [%s] element is missing or has a bad value";
    protected static final String NO_SUCH_PATH_WARNING = "Metadata: the path to element [%s] does not exist";
    protected final MetadataElement rootElement;
    protected String name;
    protected int width;
    protected int height;
    protected int numBands;
    protected Path path;
    protected Logger logger;
    protected Map<String, List<MetadataAttribute>> attributeMap;

    public static void CopyChildElements(MetadataElement source, MetadataElement target) {
        Assert.notNull((Object)((Object)source));
        Assert.notNull((Object)((Object)target));
        MetadataAttribute[] attributes = source.getAttributes();
        if (attributes != null) {
            for (MetadataAttribute attribute : attributes) {
                if (target.containsAttribute(attribute.getName()) || attribute.getName().contains(":")) continue;
                target.addAttribute(attribute);
            }
        }
        while (source.getNumElements() > 0) {
            MetadataElement currentElement = source.getElementAt(0);
            target.addElement(currentElement);
            source.removeElement(currentElement);
        }
    }

    public GenericXmlMetadata(String name) {
        this.name = name;
        this.rootElement = new MetadataElement(this.name);
        this.logger = Logger.getLogger(GenericXmlMetadata.class.getName());
        this.attributeMap = new HashMap<String, List<MetadataAttribute>>();
    }

    public MetadataElement getRootElement() {
        return this.rootElement;
    }

    public abstract String getFileName();

    public void setFileName(String actualName) {
        this.name = actualName;
    }

    public abstract String getMetadataProfile();

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path value) {
        this.path = value;
    }

    public void setName(String value) {
        this.name = value;
        this.rootElement.setName(value);
    }

    public String getAttributeValue(String attributePath, String defaultValue) {
        return this.getAttributeValue(attributePath, 0, defaultValue);
    }

    public String getAttributeValue(String attributePath, int attributeIndex, String defaultValue) {
        String value = defaultValue;
        if (attributePath != null) {
            List<MetadataAttribute> attributes;
            if (this.attributeMap.containsKey(attributePath = this.ensureAttributeTagPresent(attributePath)) && (attributes = this.attributeMap.get(attributePath)) != null && attributes.size() > attributeIndex) {
                value = attributes.get(attributeIndex).getData().getElemString();
                if (value == null) {
                    value = defaultValue;
                    this.warn(MISSING_ELEMENT_WARNING, attributes.get(attributeIndex).getName());
                }
            } else {
                this.warn(NO_SUCH_PATH_WARNING, attributePath);
            }
        }
        return value;
    }

    public String[] getAttributeValues(String attributePath) {
        String[] values = null;
        if (attributePath != null) {
            List<MetadataAttribute> attributes;
            if (this.attributeMap.containsKey(attributePath = this.ensureAttributeTagPresent(attributePath)) && (attributes = this.attributeMap.get(attributePath)) != null && attributes.size() > 0) {
                values = new String[attributes.size()];
                for (int i = 0; i < attributes.size(); ++i) {
                    values[i] = attributes.get(i).getData().getElemString();
                    if (values[i] != null) continue;
                    this.warn(MISSING_ELEMENT_WARNING, attributes.get(i).getName());
                }
            } else {
                this.warn(NO_SUCH_PATH_WARNING, attributePath);
            }
        }
        return values;
    }

    public String getAttributeSiblingValue(String attributePath, String attributeValue, String siblingPath, String defaultSiblingValue) {
        String value = defaultSiblingValue;
        if (attributePath != null && siblingPath != null && attributeValue != null) {
            List<MetadataAttribute> attributes;
            if (this.attributeMap.containsKey(attributePath = this.ensureAttributeTagPresent(attributePath)) && (attributes = this.attributeMap.get(attributePath)) != null && attributes.size() > 0) {
                int foundIndex = -1;
                for (int i = 0; i < attributes.size(); ++i) {
                    if (!attributeValue.equalsIgnoreCase(attributes.get(i).getData().getElemString())) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex != -1 && (value = this.getAttributeValue(siblingPath, foundIndex, null)) == null) {
                    value = defaultSiblingValue;
                }
            } else {
                this.warn(NO_SUCH_PATH_WARNING, attributePath);
            }
        }
        return value;
    }

    protected void warn(String message, String argument) {
        if (argument == null) {
            this.logger.warning(message);
        } else if ((argument = argument.replace("@", "")).contains("/")) {
            this.logger.warning(String.format(message, argument.substring(argument.lastIndexOf("/") + 1)));
        } else {
            this.logger.warning(String.format(message, argument));
        }
    }

    public void indexAttribute(String parentElementPath, MetadataAttribute attribute) {
        String key = (parentElementPath + "@" + attribute.getName()).toLowerCase();
        if (!this.attributeMap.containsKey(key)) {
            this.attributeMap.put(key, new ArrayList());
        }
        this.attributeMap.get(key).add(attribute);
    }

    protected String ensureAttributeTagPresent(String path) {
        if (path != null && !((String)(path = ((String)path).toLowerCase())).contains("@")) {
            int idx = ((String)path).lastIndexOf("/") + 1;
            path = ((String)path).substring(0, idx) + "@" + ((String)path).substring(idx);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends GenericXmlMetadata> T create(Class<T> clazz, String input) {
        Assert.notNull((Object)input);
        GenericXmlMetadata result = null;
        InputStream stream = null;
        try {
            if (!input.isEmpty()) {
                stream = new ByteArrayInputStream(input.getBytes());
                result = (GenericXmlMetadata)XmlMetadataParserFactory.getParser(clazz).parse(stream);
                String metadataProfile = result.getMetadataProfile();
                if (metadataProfile != null) {
                    result.setName(metadataProfile);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(GenericXmlMetadata.class.getName()).severe(e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)result;
    }

    public static <T extends GenericXmlMetadata> T create(Class<T> clazz, File inputFile) {
        Assert.notNull((Object)inputFile);
        return GenericXmlMetadata.create(clazz, inputFile.toPath());
    }

    public static <T extends GenericXmlMetadata> T create(Class<T> clazz, Path inputFile) {
        Assert.notNull((Object)inputFile);
        T result = null;
        try {
            result = GenericXmlMetadata.loadMetadata(clazz, inputFile);
        }
        catch (Exception e) {
            Logger.getLogger(GenericXmlMetadata.class.getName()).severe(e.getMessage());
        }
        return result;
    }

    public static <T extends GenericXmlMetadata> T loadMetadata(Class<T> clazz, Path inputFile) throws IOException, InstantiationException, ParserConfigurationException, SAXException {
        Assert.notNull((Object)inputFile);
        GenericXmlMetadata result = null;
        if (Files.exists(inputFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(inputFile, StandardOpenOption.READ);){
                result = (GenericXmlMetadata)XmlMetadataParserFactory.getParser(clazz).parse(inputStream);
                result.setPath(inputFile);
                String metadataProfile = result.getMetadataProfile();
                if (metadataProfile != null) {
                    result.setName(metadataProfile);
                }
            }
        }
        return (T)result;
    }
}

