/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import java.awt.image.RenderedImage;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;

@LayerTypeMetadata(name="MaskLayerType", aliasNames={"org.esa.snap.core.layer.MaskLayerType"})
public class MaskLayerType
extends ImageLayer.Type {
    public static final String PROPERTY_NAME_MASK = "mask";

    public static Layer createLayer(RasterDataNode raster, Mask mask) {
        MaskLayerType type = (MaskLayerType)LayerTypeRegistry.getLayerType(MaskLayerType.class);
        PropertySet configuration = type.createLayerConfig(null);
        configuration.setValue(PROPERTY_NAME_MASK, (Object)mask);
        Layer layer = type.createLayer(null, configuration);
        layer.setVisible(raster.getOverlayMaskGroup().contains(mask));
        return layer;
    }

    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        MultiLevelSource multiLevelSource = (MultiLevelSource)configuration.getValue("multiLevelSource");
        if (multiLevelSource == null) {
            multiLevelSource = MaskLayerType.createMultiLevelSource(configuration);
        }
        configuration.setValue("multiLevelSource", (Object)multiLevelSource);
        configuration.setValue("borderShown", (Object)false);
        configuration.setValue("pixelBorderShown", (Object)false);
        ImageLayer layer = new ImageLayer((ImageLayer.Type)this, multiLevelSource, configuration);
        Mask mask = (Mask)configuration.getValue(PROPERTY_NAME_MASK);
        layer.setName(mask.getName());
        return layer;
    }

    public static MultiLevelSource createMultiLevelSource(PropertySet configuration) {
        Mask mask = (Mask)configuration.getValue(PROPERTY_NAME_MASK);
        return MaskLayerType.createMultiLevelSource(mask);
    }

    public static MultiLevelSource createMultiLevelSource(final Mask mask) {
        return new AbstractMultiLevelSource(mask.getSourceImage().getModel()){

            protected RenderedImage createImage(int level) {
                return ImageManager.createColoredMaskImage(mask.getSourceImage().getImage(level), mask.getImageColor(), 1.0 - mask.getImageTransparency());
            }
        };
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertySet layerConfig = super.createLayerConfig(ctx);
        layerConfig.addProperty(Property.create((String)PROPERTY_NAME_MASK, Mask.class));
        layerConfig.getProperty(PROPERTY_NAME_MASK).getDescriptor().setNotNull(true);
        return layerConfig;
    }
}

