/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.layer;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.Graticule;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.layer.GraticuleLayerType;

public class GraticuleLayer
extends Layer {
    private static final GraticuleLayerType LAYER_TYPE = (GraticuleLayerType)LayerTypeRegistry.getLayerType(GraticuleLayerType.class);
    private RasterDataNode raster;
    private ProductNodeHandler productNodeHandler;
    private Graticule graticule;
    private double NULL_DOUBLE;
    private double ptsToPixelsMultiplier;
    private int minorStep;

    public GraticuleLayer(RasterDataNode raster) {
        this(LAYER_TYPE, raster, GraticuleLayer.initConfiguration(LAYER_TYPE.createLayerConfig(null), raster));
    }

    public GraticuleLayer(GraticuleLayerType type, RasterDataNode raster, PropertySet configuration) {
        super((LayerType)type, configuration);
        this.ptsToPixelsMultiplier = this.NULL_DOUBLE = -1.0;
        this.minorStep = 4;
        this.setName("Graticule Layer");
        this.raster = raster;
        this.productNodeHandler = new ProductNodeHandler();
        raster.getProduct().addProductNodeListener(this.productNodeHandler);
        this.setTransparency(0.0);
    }

    private static PropertySet initConfiguration(PropertySet configurationTemplate, RasterDataNode raster) {
        configurationTemplate.setValue("raster", (Object)raster);
        return configurationTemplate;
    }

    private Product getProduct() {
        return this.getRaster().getProduct();
    }

    RasterDataNode getRaster() {
        return this.raster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderLayer(Rendering rendering) {
        this.getUserValues();
        if (this.graticule == null) {
            this.graticule = Graticule.create(this.raster, this.getNumGridLines(), this.getGridSpacingLat(), this.getGridSpacingLon(), this.isLabelsSuffix(), this.isLabelsDecimal());
        }
        if (this.graticule != null) {
            Graphics2D g2d = rendering.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Viewport vp = rendering.getViewport();
            AffineTransform transformSave = g2d.getTransform();
            try {
                Graticule.TextGlyph[] textGlyphsEast;
                Graticule.TextGlyph[] textGlyphsWest;
                Graticule.TextGlyph[] textGlyphsSouth;
                Graticule.TextGlyph[] textGlyphsNorth;
                AffineTransform transform = new AffineTransform();
                transform.concatenate(transformSave);
                transform.concatenate(vp.getModelToViewTransform());
                transform.concatenate(this.raster.getSourceImage().getModel().getImageToModelTransform(0));
                g2d.setTransform(transform);
                GeneralPath[] linePaths = this.graticule.getLinePaths();
                if (linePaths != null && this.isGridlinesShow()) {
                    this.drawLinePaths(g2d, linePaths);
                }
                if (this.isBorderShow()) {
                    this.drawBorder(g2d, this.raster);
                }
                if (this.isLabelsNorth() && (textGlyphsNorth = this.graticule.getTextGlyphsNorth()) != null) {
                    if (this.isTickmarksShow()) {
                        this.drawTickMarks(g2d, this.graticule.getTickPointsNorth(), Graticule.TextLocation.NORTH, false);
                    }
                    this.drawTextLabels(g2d, textGlyphsNorth, Graticule.TextLocation.NORTH, false, this.raster);
                }
                if (this.isLabelsSouth() && (textGlyphsSouth = this.graticule.getTextGlyphsSouth()) != null) {
                    if (this.isTickmarksShow()) {
                        this.drawTickMarks(g2d, this.graticule.getTickPointsSouth(), Graticule.TextLocation.SOUTH, false);
                    }
                    this.drawTextLabels(g2d, textGlyphsSouth, Graticule.TextLocation.SOUTH, false, this.raster);
                }
                if (this.isLabelsWest() && (textGlyphsWest = this.graticule.getTextGlyphsWest()) != null) {
                    if (this.isTickmarksShow()) {
                        this.drawTickMarks(g2d, this.graticule.getTickPointsWest(), Graticule.TextLocation.WEST, false);
                    }
                    this.drawTextLabels(g2d, textGlyphsWest, Graticule.TextLocation.WEST, false, this.raster);
                }
                if (this.isLabelsEast() && (textGlyphsEast = this.graticule.getTextGlyphsEast()) != null) {
                    if (this.isTickmarksShow()) {
                        this.drawTickMarks(g2d, this.graticule.getTickPointsEast(), Graticule.TextLocation.EAST, false);
                    }
                    this.drawTextLabels(g2d, textGlyphsEast, Graticule.TextLocation.EAST, false, this.raster);
                }
                if (this.isCornerLabelsWest()) {
                    if (this.isTickmarksShow()) {
                        this.drawCornerTickMarks(g2d, this.raster, Graticule.TextLocation.WEST);
                    }
                    if (!this.isLabelsInside()) {
                        this.drawLeftSideLatCornerLabels(g2d);
                    }
                }
                if (this.isCornerLabelsEast()) {
                    if (this.isTickmarksShow()) {
                        this.drawCornerTickMarks(g2d, this.raster, Graticule.TextLocation.EAST);
                    }
                    if (!this.isLabelsInside()) {
                        this.drawRightSideLatCornerLabels(g2d);
                    }
                }
                if (this.isCornerLabelsNorth()) {
                    if (this.isTickmarksShow()) {
                        this.drawCornerTickMarks(g2d, this.raster, Graticule.TextLocation.NORTH);
                    }
                    if (!this.isLabelsInside()) {
                        this.drawNorthSideLonCornerLabels(g2d);
                    }
                }
                if (this.isCornerLabelsSouth()) {
                    if (this.isTickmarksShow()) {
                        this.drawCornerTickMarks(g2d, this.raster, Graticule.TextLocation.SOUTH);
                    }
                    if (!this.isLabelsInside()) {
                        this.drawSouthSideLonCornerLabels(g2d);
                    }
                }
            }
            finally {
                g2d.setTransform(transformSave);
            }
        }
    }

    private void drawLeftSideLatCornerLabels(Graphics2D g2d) {
        Graticule.TextGlyph[] textGlyphs;
        ArrayList<Graticule.TextGlyph> textGlyphArrayList = new ArrayList<Graticule.TextGlyph>();
        Graticule.TextGlyph textGlyph = this.graticule.getTextGlyphsLatCorners()[Graticule.TOP_LEFT_CORNER_INDEX];
        if (textGlyph != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyph = this.graticule.getTextGlyphsLatCorners()[Graticule.BOTTOM_LEFT_CORNER_INDEX]) != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyphs = textGlyphArrayList.toArray(new Graticule.TextGlyph[textGlyphArrayList.size()])) != null) {
            this.drawTextLabels(g2d, textGlyphs, Graticule.TextLocation.WEST, true, this.raster);
        }
    }

    private void drawRightSideLatCornerLabels(Graphics2D g2d) {
        Graticule.TextGlyph[] textGlyphs;
        ArrayList<Graticule.TextGlyph> textGlyphArrayList = new ArrayList<Graticule.TextGlyph>();
        Graticule.TextGlyph textGlyph = this.graticule.getTextGlyphsLatCorners()[Graticule.TOP_RIGHT_CORNER_INDEX];
        if (textGlyph != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyph = this.graticule.getTextGlyphsLatCorners()[Graticule.BOTTOM_RIGHT_CORNER_INDEX]) != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyphs = textGlyphArrayList.toArray(new Graticule.TextGlyph[textGlyphArrayList.size()])) != null) {
            this.drawTextLabels(g2d, textGlyphs, Graticule.TextLocation.EAST, true, this.raster);
        }
    }

    private void drawNorthSideLonCornerLabels(Graphics2D g2d) {
        Graticule.TextGlyph[] textGlyphs;
        ArrayList<Graticule.TextGlyph> textGlyphArrayList = new ArrayList<Graticule.TextGlyph>();
        Graticule.TextGlyph textGlyph = this.graticule.getTextGlyphsLonCorners()[Graticule.TOP_LEFT_CORNER_INDEX];
        if (textGlyph != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyph = this.graticule.getTextGlyphsLonCorners()[Graticule.TOP_RIGHT_CORNER_INDEX]) != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyphs = textGlyphArrayList.toArray(new Graticule.TextGlyph[textGlyphArrayList.size()])) != null) {
            this.drawTextLabels(g2d, textGlyphs, Graticule.TextLocation.NORTH, true, this.raster);
        }
    }

    private void drawSouthSideLonCornerLabels(Graphics2D g2d) {
        Graticule.TextGlyph[] textGlyphs;
        ArrayList<Graticule.TextGlyph> textGlyphArrayList = new ArrayList<Graticule.TextGlyph>();
        Graticule.TextGlyph textGlyph = this.graticule.getTextGlyphsLonCorners()[Graticule.BOTTOM_LEFT_CORNER_INDEX];
        if (textGlyph != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyph = this.graticule.getTextGlyphsLonCorners()[Graticule.BOTTOM_RIGHT_CORNER_INDEX]) != null) {
            textGlyphArrayList.add(textGlyph);
        }
        if ((textGlyphs = textGlyphArrayList.toArray(new Graticule.TextGlyph[textGlyphArrayList.size()])) != null) {
            this.drawTextLabels(g2d, textGlyphs, Graticule.TextLocation.SOUTH, true, this.raster);
        }
    }

    private void getUserValues() {
    }

    private void drawLinePaths(Graphics2D g2d, GeneralPath[] linePaths) {
        Color origPaint = (Color)g2d.getPaint();
        Stroke origStroke = g2d.getStroke();
        Composite oldComposite = null;
        if (this.getGridlinesTransparency() > 0.0) {
            oldComposite = g2d.getComposite();
            g2d.setComposite(this.getAlphaComposite(this.getGridlinesTransparency()));
        }
        g2d.setPaint(this.getGridlinesColor());
        BasicStroke drawingStroke = this.getDashLengthPixels() > 0.0 ? new BasicStroke((float)this.getGridlinesWidthPixels(), 0, 2, 0.0f, new float[]{(float)this.getDashLengthPixels()}, 0.0f) : new BasicStroke((float)this.getGridlinesWidthPixels());
        g2d.setStroke(drawingStroke);
        for (GeneralPath linePath : linePaths) {
            g2d.draw(linePath);
        }
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
        g2d.setStroke(origStroke);
        g2d.setPaint(origPaint);
    }

    private void drawCornerTickMarks(Graphics2D g2d, RasterDataNode raster, Graticule.TextLocation textLocation) {
        PixelPos pixelPos1 = null;
        PixelPos pixelPos2 = null;
        switch (textLocation) {
            case NORTH: {
                pixelPos1 = new PixelPos(0.0, 0.0);
                pixelPos2 = new PixelPos(raster.getRasterWidth(), 0.0);
                break;
            }
            case SOUTH: {
                pixelPos1 = new PixelPos(0.0, raster.getRasterHeight());
                pixelPos2 = new PixelPos(raster.getRasterWidth(), raster.getRasterHeight());
                break;
            }
            case WEST: {
                pixelPos1 = new PixelPos(0.0, 0.0);
                pixelPos2 = new PixelPos(0.0, raster.getRasterHeight());
                break;
            }
            case EAST: {
                pixelPos1 = new PixelPos(raster.getRasterWidth(), 0.0);
                pixelPos2 = new PixelPos(raster.getRasterWidth(), raster.getRasterHeight());
            }
        }
        if (pixelPos1 != null && pixelPos2 != null) {
            PixelPos[] pixelPos = new PixelPos[]{pixelPos1, pixelPos2};
            boolean drawCornerTicks = false;
            if (drawCornerTicks && !this.isTickmarksInside()) {
                this.drawTickMarks(g2d, pixelPos, textLocation, true);
            }
        }
    }

    private void drawBorder(Graphics2D g2d, RasterDataNode raster) {
        Color origColor = (Color)g2d.getPaint();
        Stroke origStroke = g2d.getStroke();
        double sidewaysShift = this.getBorderWidthPixels() / 2.0;
        double lengthWiseAddOn = this.getBorderWidthPixels();
        GeneralPath northBorderPath = new GeneralPath();
        GeneralPath southBorderPath = new GeneralPath();
        double xStart = 0.0 - lengthWiseAddOn;
        double xEnd = (double)raster.getRasterWidth() + lengthWiseAddOn;
        double y = 0.0 - sidewaysShift;
        northBorderPath.moveTo(xStart, y);
        northBorderPath.lineTo(xEnd, y);
        northBorderPath.closePath();
        y = (double)raster.getRasterHeight() + sidewaysShift;
        southBorderPath.moveTo(xStart, y);
        southBorderPath.lineTo(xEnd, y);
        southBorderPath.closePath();
        GeneralPath westBorderPath = new GeneralPath();
        GeneralPath eastBorderPath = new GeneralPath();
        double yStart = 0.0 - lengthWiseAddOn;
        double yEnd = (double)raster.getRasterHeight() + lengthWiseAddOn;
        double x = 0.0 - sidewaysShift;
        westBorderPath.moveTo(x, yStart);
        westBorderPath.lineTo(x, yEnd);
        westBorderPath.closePath();
        x = (double)raster.getRasterWidth() + sidewaysShift;
        eastBorderPath.moveTo(x, yStart);
        eastBorderPath.lineTo(x, yEnd);
        eastBorderPath.closePath();
        BasicStroke drawingStroke = new BasicStroke((float)this.getBorderWidthPixels());
        g2d.setStroke(drawingStroke);
        g2d.setPaint(this.getBorderColor());
        g2d.draw(southBorderPath);
        g2d.draw(northBorderPath);
        g2d.draw(westBorderPath);
        g2d.draw(eastBorderPath);
        g2d.setPaint(origColor);
        g2d.setStroke(origStroke);
    }

    private boolean isTextConflict(PixelPos pixelPos, Graphics2D g2d, Graticule.TextLocation textLocation, boolean isCorner, RasterDataNode raster) {
        Font origFont = g2d.getFont();
        Font font = new Font(this.getLabelsFont(), this.getFontType(), this.getFontSizePixels());
        g2d.setFont(font);
        Rectangle2D singleLetter = g2d.getFontMetrics().getStringBounds("W", g2d);
        double WRONG_AXIS_BUFFER_PERCENT = 0.02;
        boolean conflict = false;
        double overlapMultiplierBuffer = 1.0;
        double xAllowedMin = 0.0 + overlapMultiplierBuffer * singleLetter.getHeight();
        double xAllowedMax = (double)raster.getRasterWidth() - overlapMultiplierBuffer * singleLetter.getHeight();
        double yAllowedMin = 0.0 + overlapMultiplierBuffer * singleLetter.getHeight();
        double yAllowedMax = (double)raster.getRasterHeight() - overlapMultiplierBuffer * singleLetter.getHeight();
        double buffer = 0.0;
        switch (textLocation) {
            case NORTH: {
                if (this.isCornerLabelsNorth() && !isCorner && (pixelPos.getX() < xAllowedMin || pixelPos.getX() > xAllowedMax)) {
                    conflict = true;
                }
                buffer = WRONG_AXIS_BUFFER_PERCENT * (double)raster.getRasterHeight();
                if (!(pixelPos.getY() > buffer)) break;
                conflict = true;
                break;
            }
            case SOUTH: {
                if (this.isCornerLabelsSouth() && !isCorner && (pixelPos.getX() < xAllowedMin || pixelPos.getX() > xAllowedMax)) {
                    conflict = true;
                }
                buffer = WRONG_AXIS_BUFFER_PERCENT * (double)raster.getRasterHeight();
                if (!(pixelPos.getY() < (double)raster.getRasterHeight() - buffer)) break;
                conflict = true;
                break;
            }
            case WEST: {
                if (this.isCornerLabelsWest() && !isCorner && (pixelPos.getY() < yAllowedMin || pixelPos.getY() > yAllowedMax)) {
                    conflict = true;
                }
                buffer = WRONG_AXIS_BUFFER_PERCENT * (double)raster.getRasterWidth();
                if (!(pixelPos.getX() > buffer)) break;
                conflict = true;
                break;
            }
            case EAST: {
                if (this.isCornerLabelsEast() && !isCorner && (pixelPos.getY() < yAllowedMin || pixelPos.getY() > yAllowedMax)) {
                    conflict = true;
                }
                buffer = WRONG_AXIS_BUFFER_PERCENT * (double)raster.getRasterWidth();
                if (!(pixelPos.getX() < (double)raster.getRasterWidth() - buffer)) break;
                conflict = true;
            }
        }
        g2d.setFont(origFont);
        return conflict;
    }

    private void drawTextLabels(Graphics2D g2d, Graticule.TextGlyph[] textGlyphs, Graticule.TextLocation textLocation, boolean isCorner, RasterDataNode raster) {
        double halfPixelCorrection = 0.0;
        if (!isCorner) {
            halfPixelCorrection = 0.5;
        }
        Color origColor = (Color)g2d.getPaint();
        if (isCorner) {
            g2d.setPaint(this.getLabelsColor());
        } else {
            g2d.setPaint(this.getLabelsColor());
        }
        Font origFont = g2d.getFont();
        Font font = new Font(this.getLabelsFont(), this.getFontType(), this.getFontSizePixels());
        g2d.setFont(font);
        Rectangle2D singleLetter = g2d.getFontMetrics().getStringBounds("W", g2d);
        double letterWidth = singleLetter.getWidth();
        float spacerBetweenTextAndBorder = (float)(letterWidth / 2.0);
        for (Graticule.TextGlyph glyph : textGlyphs) {
            float yOffset;
            PixelPos pixelPos = new PixelPos(glyph.getX(), glyph.getY());
            if (this.isTextConflict(pixelPos, g2d, textLocation, isCorner, raster)) continue;
            if (this.isLabelsInside() && this.getInsideLabelsBgTransparency() < 1.0) {
                this.drawRectangle(g2d, glyph);
            }
            g2d.translate(glyph.getX(), glyph.getY());
            g2d.rotate(glyph.getAngle());
            Rectangle2D labelBounds = g2d.getFontMetrics().getStringBounds(glyph.getText(), g2d);
            float width = (float)labelBounds.getWidth();
            float height = (float)labelBounds.getHeight();
            float halfLabelWidth = width / 2.0f;
            AffineTransform orig = g2d.getTransform();
            if (!this.isLabelsInside()) {
                float yMod;
                float xMod;
                double verticalShift;
                float yOffset2;
                float xOffset;
                double theta;
                if (textLocation == Graticule.TextLocation.NORTH) {
                    theta = this.getLabelsRotationLon() / 180.0 * Math.PI;
                    xOffset = 0.0f;
                    yOffset2 = 0.0f;
                    verticalShift = halfPixelCorrection + this.getBorderWidthPixels() + (double)spacerBetweenTextAndBorder;
                    if (this.isTickmarksShow() && !this.isTickmarksInside() && !isCorner) {
                        verticalShift += this.getTickmarksLength();
                    }
                    if (this.getLabelsRotationLon() > 85.0) {
                        xOffset = -halfLabelWidth;
                    }
                    if (this.getLabelsRotationLon() < 5.0) {
                        yOffset2 = height / 3.0f;
                    }
                    xMod = (float)(verticalShift * Math.cos(theta));
                    yMod = -1.0f * (float)(verticalShift * Math.sin(theta));
                    g2d.rotate(-Math.PI + theta);
                    g2d.drawString(glyph.getText(), xMod + xOffset, yMod + yOffset2);
                }
                if (textLocation == Graticule.TextLocation.SOUTH) {
                    theta = this.getLabelsRotationLon() / 180.0 * Math.PI;
                    xOffset = -width;
                    yOffset2 = 2.0f * height / 3.0f;
                    verticalShift = -halfPixelCorrection - this.getBorderWidthPixels() - (double)spacerBetweenTextAndBorder;
                    if (this.isTickmarksShow() && !this.isTickmarksInside() && !isCorner) {
                        verticalShift -= this.getTickmarksLength();
                    }
                    if (this.getLabelsRotationLon() > 85.0) {
                        xOffset += halfLabelWidth;
                    }
                    if (this.getLabelsRotationLon() < 5.0) {
                        yOffset2 -= height / 3.0f;
                    }
                    xMod = (float)(verticalShift * Math.cos(theta));
                    yMod = -1.0f * (float)(verticalShift * Math.sin(theta));
                    g2d.rotate(theta);
                    g2d.drawString(glyph.getText(), xMod + xOffset, yMod + yOffset2);
                }
                if (textLocation == Graticule.TextLocation.EAST) {
                    theta = this.getLabelsRotationLat() / 180.0 * Math.PI;
                    xOffset = 0.0f;
                    yOffset2 = 2.0f * height / 3.0f;
                    verticalShift = halfPixelCorrection + this.getBorderWidthPixels() + (double)spacerBetweenTextAndBorder;
                    if (this.isTickmarksShow() && !this.isTickmarksInside() && !isCorner) {
                        verticalShift += this.getTickmarksLength();
                    }
                    if (this.getLabelsRotationLat() > 85.0) {
                        xOffset = -halfLabelWidth;
                    }
                    if (this.getLabelsRotationLat() < 5.0) {
                        yOffset2 = height / 3.0f;
                    }
                    xMod = (float)(verticalShift * Math.cos(theta));
                    yMod = (float)(verticalShift * Math.sin(theta));
                    g2d.rotate(-Math.PI - theta);
                    g2d.drawString(glyph.getText(), xMod + xOffset, yMod + yOffset2);
                }
                if (textLocation == Graticule.TextLocation.WEST) {
                    theta = this.getLabelsRotationLat() / 180.0 * Math.PI;
                    xOffset = -width;
                    yOffset2 = 0.0f;
                    verticalShift = -halfPixelCorrection - this.getBorderWidthPixels() - (double)spacerBetweenTextAndBorder;
                    if (this.isTickmarksShow() && !this.isTickmarksInside() && !isCorner) {
                        verticalShift -= this.getTickmarksLength();
                    }
                    if (this.getLabelsRotationLat() > 85.0) {
                        xOffset += halfLabelWidth;
                    }
                    if (this.getLabelsRotationLat() < 5.0) {
                        yOffset2 += height / 3.0f;
                    }
                    xMod = (float)(verticalShift * Math.cos(theta));
                    yMod = (float)(verticalShift * Math.sin(theta));
                    g2d.rotate(-theta);
                    g2d.drawString(glyph.getText(), xMod + xOffset, yMod + yOffset2);
                }
            } else if (textLocation == Graticule.TextLocation.WEST || textLocation == Graticule.TextLocation.SOUTH) {
                float xOffset = spacerBetweenTextAndBorder;
                yOffset = height / 3.0f;
                if (this.isTickmarksShow() && this.isTickmarksInside()) {
                    xOffset = (float)((double)xOffset + this.getTickmarksLength());
                }
                g2d.drawString(glyph.getText(), xOffset, yOffset);
            } else {
                float xOffset = -width - spacerBetweenTextAndBorder;
                yOffset = height / 3.0f;
                if (this.isTickmarksShow() && this.isTickmarksInside()) {
                    xOffset = (float)((double)xOffset - this.getTickmarksLength());
                }
                g2d.rotate(-Math.PI);
                g2d.drawString(glyph.getText(), xOffset, yOffset);
            }
            g2d.setTransform(orig);
            g2d.rotate(-glyph.getAngle());
            g2d.translate(-glyph.getX(), -glyph.getY());
        }
        g2d.setPaint(origColor);
        g2d.setFont(origFont);
    }

    private void drawRectangle(Graphics2D g2d, Graticule.TextGlyph glyph) {
        Composite oldComposite = null;
        if (this.getInsideLabelsBgTransparency() > 0.0) {
            oldComposite = g2d.getComposite();
            g2d.setComposite(this.getAlphaComposite(this.getInsideLabelsBgTransparency()));
        }
        Color origPaint = (Color)g2d.getPaint();
        Stroke origStroke = g2d.getStroke();
        g2d.setPaint(this.getInsideLabelsBgColor());
        g2d.setStroke(new BasicStroke(0.0f));
        g2d.translate(glyph.getX(), glyph.getY());
        g2d.rotate(glyph.getAngle());
        Rectangle2D singleLetter = g2d.getFontMetrics().getStringBounds("W", g2d);
        double xOffset = singleLetter.getWidth() / 2.0;
        double yOffset = singleLetter.getHeight() / 3.0;
        if (this.isTickmarksShow() && this.isTickmarksInside()) {
            xOffset += this.getTickmarksLength();
        }
        Rectangle2D labelBounds = g2d.getFontMetrics().getStringBounds(glyph.getText(), g2d);
        labelBounds.setRect(labelBounds.getX() + xOffset - 1.0, labelBounds.getY() + yOffset - 1.0, labelBounds.getWidth(), labelBounds.getHeight());
        g2d.fill(labelBounds);
        g2d.rotate(-glyph.getAngle());
        g2d.translate(-glyph.getX(), -glyph.getY());
        g2d.setPaint(origPaint);
        g2d.setStroke(origStroke);
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
    }

    private void drawTickMarks(Graphics2D g2d, PixelPos[] pixelPoses, Graticule.TextLocation textLocation, boolean isCorner) {
        Composite oldComposite = g2d.getComposite();
        Stroke origStroke = g2d.getStroke();
        BasicStroke drawingStroke = new BasicStroke((float)this.getGridlinesWidthPixels());
        g2d.setStroke(drawingStroke);
        Color origPaint = (Color)g2d.getPaint();
        g2d.setPaint(this.getTickmarksColor());
        double halfPixelCorrection = 0.0;
        if (!isCorner) {
            halfPixelCorrection = 0.5;
        }
        double xStart = 0.0;
        double xEnd = 0.0;
        double yStart = 0.0;
        double yEnd = 0.0;
        boolean validCase = false;
        for (PixelPos pixelPos : pixelPoses) {
            if (this.isTextConflict(pixelPos, g2d, textLocation, isCorner, this.raster)) continue;
            switch (textLocation) {
                case NORTH: {
                    xStart = pixelPos.getX();
                    xEnd = pixelPos.getX();
                    if (this.isTickmarksInside()) {
                        yStart = pixelPos.getY() - halfPixelCorrection;
                        yEnd = yStart + this.getTickmarksLength();
                    } else {
                        yStart = pixelPos.getY() - halfPixelCorrection - this.getBorderWidthPixels();
                        yEnd = yStart - this.getTickmarksLength();
                    }
                    validCase = true;
                    break;
                }
                case SOUTH: {
                    xStart = pixelPos.getX();
                    xEnd = pixelPos.getX();
                    if (this.isTickmarksInside()) {
                        yStart = pixelPos.getY() + halfPixelCorrection;
                        yEnd = yStart - this.getTickmarksLength();
                    } else {
                        yStart = pixelPos.getY() + halfPixelCorrection + this.getBorderWidthPixels();
                        yEnd = yStart + this.getTickmarksLength();
                    }
                    validCase = true;
                    break;
                }
                case WEST: {
                    yStart = pixelPos.getY();
                    yEnd = pixelPos.getY();
                    if (this.isTickmarksInside()) {
                        xStart = pixelPos.getX() - halfPixelCorrection;
                        xEnd = xStart + this.getTickmarksLength();
                    } else {
                        xStart = pixelPos.getX() - halfPixelCorrection - this.getBorderWidthPixels();
                        xEnd = xStart - this.getTickmarksLength();
                    }
                    validCase = true;
                    break;
                }
                case EAST: {
                    yStart = pixelPos.getY();
                    yEnd = pixelPos.getY();
                    if (this.isTickmarksInside()) {
                        xStart = pixelPos.getX() + halfPixelCorrection;
                        xEnd = xStart - this.getTickmarksLength();
                    } else {
                        xStart = pixelPos.getX() + halfPixelCorrection + this.getBorderWidthPixels();
                        xEnd = xStart + this.getTickmarksLength();
                    }
                    validCase = true;
                }
            }
            if (!validCase) continue;
            GeneralPath path = new GeneralPath();
            path.moveTo(xStart, yStart);
            path.lineTo(xEnd, yEnd);
            path.closePath();
            g2d.draw(path);
        }
        g2d.setPaint(origPaint);
        g2d.setStroke(origStroke);
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
    }

    private AlphaComposite getAlphaComposite(double itemTransparancy) {
        double combinedAlpha = (1.0 - this.getTransparency()) * (1.0 - itemTransparancy);
        return AlphaComposite.getInstance(3, (float)combinedAlpha);
    }

    public void disposeLayer() {
        Product product = this.getProduct();
        if (product != null) {
            product.removeProductNodeListener(this.productNodeHandler);
            this.graticule = null;
            this.raster = null;
        }
    }

    protected void fireLayerPropertyChanged(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("graticule.spacing.lat") || propertyName.equals("graticule.spacing.lon") || propertyName.equals("graticule.num.grid.lines") || propertyName.equals("graticule.labels.suffix.nswe") || propertyName.equals("graticule.labels.decimal.value")) {
            this.graticule = null;
        }
        if (this.getConfiguration().getProperty(propertyName) != null) {
            this.getConfiguration().setValue(propertyName, event.getNewValue());
        }
        super.fireLayerPropertyChanged(event);
    }

    private double getGridSpacingLon() {
        return (Double)this.getConfigurationProperty("graticule.spacing.lon", 0.0);
    }

    private double getGridSpacingLat() {
        return (Double)this.getConfigurationProperty("graticule.spacing.lat", 0.0);
    }

    private int getNumGridLines() {
        return (Integer)this.getConfigurationProperty("graticule.num.grid.lines", 4);
    }

    private Color getGridlinesColor() {
        return (Color)this.getConfigurationProperty("graticule.gridlines.color", GraticuleLayerType.PROPERTY_GRIDLINES_COLOR_DEFAULT);
    }

    private double getGridlinesTransparency() {
        return (Double)this.getConfigurationProperty("graticule.gridlines.transparency", 0.6);
    }

    private Color getLabelsColor() {
        return (Color)this.getConfigurationProperty("graticule.labels.color", GraticuleLayerType.PROPERTY_LABELS_COLOR_DEFAULT);
    }

    private Color getTickmarksColor() {
        return (Color)this.getConfigurationProperty("graticule.tickmarks.color", GraticuleLayerType.PROPERTY_TICKMARKS_COLOR_DEFAULT);
    }

    private Color getInsideLabelsBgColor() {
        return (Color)this.getConfigurationProperty("graticule.text.bg.color", GraticuleLayerType.PROPERTY_INSIDE_LABELS_BG_COLOR_DEFAULT);
    }

    private double getInsideLabelsBgTransparency() {
        return (Double)this.getConfigurationProperty("graticule.text.bg.transparency", 0.3);
    }

    private double getGridlinesWidthPixels() {
        double gridLineWidthPts = (Double)this.getConfigurationProperty("graticule.gridlines.width", 0.8);
        return this.getPtsToPixelsMultiplier() * gridLineWidthPts;
    }

    private double getBorderWidthPixels() {
        double borderLineWidthPts = (Double)this.getConfigurationProperty("graticule.border.width", 1.2);
        return this.getPtsToPixelsMultiplier() * borderLineWidthPts;
    }

    private double getDashLengthPixels() {
        double dashLengthPts = (Double)this.getConfigurationProperty("graticule.gridlines.dashed.phase", 3.0);
        return this.getPtsToPixelsMultiplier() * dashLengthPts;
    }

    private int getFontSizePixels() {
        int fontSizePts = (Integer)this.getConfigurationProperty("graticule.labels.size", 12);
        return (int)Math.round(this.getPtsToPixelsMultiplier() * (double)fontSizePts);
    }

    private double getPtsToPixelsMultiplier() {
        if (this.ptsToPixelsMultiplier == this.NULL_DOUBLE) {
            double PTS_PER_INCH = 72.0;
            double PAPER_HEIGHT = 11.0;
            double PAPER_WIDTH = 8.5;
            double heightToWidthRatioPaper = 1.2941176470588236;
            double heightToWidthRatioRaster = this.raster.getRasterHeight() / this.raster.getRasterWidth();
            this.ptsToPixelsMultiplier = heightToWidthRatioRaster > heightToWidthRatioPaper ? 0.013888888888888888 * ((double)this.raster.getRasterHeight() / 11.0) : 0.013888888888888888 * ((double)this.raster.getRasterWidth() / 8.5);
        }
        return this.ptsToPixelsMultiplier;
    }

    private String getLabelsFont() {
        return (String)this.getConfigurationProperty("graticule.labels.font.name", "SanSerif");
    }

    private Boolean isLabelsItalic() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.font.italic", false);
    }

    private Boolean isLabelsBold() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.font.bold", false);
    }

    private int getFontType() {
        if (this.isLabelsItalic().booleanValue() && this.isLabelsBold().booleanValue()) {
            return 3;
        }
        if (this.isLabelsItalic().booleanValue()) {
            return 2;
        }
        if (this.isLabelsBold().booleanValue()) {
            return 1;
        }
        return 0;
    }

    private boolean isLabelsInside() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.inside", false);
    }

    private double getLabelsRotationLon() {
        return (Double)this.getConfigurationProperty("graticule.labels.rotation.lon", 45.0);
    }

    private double getLabelsRotationLat() {
        return (Double)this.getConfigurationProperty("graticule.labels.rotation.lat", 0.0);
    }

    private boolean isLabelsNorth() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.north", true);
    }

    private boolean isLabelsSouth() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.south", true);
    }

    private boolean isLabelsWest() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.west", true);
    }

    private boolean isLabelsEast() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.east", true);
    }

    private boolean isGridlinesShow() {
        return (Boolean)this.getConfigurationProperty("graticule.gridlines.show", true);
    }

    private boolean isBorderShow() {
        return (Boolean)this.getConfigurationProperty("graticule.border.show", true);
    }

    private boolean isLabelsSuffix() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.suffix.nswe", true);
    }

    private boolean isLabelsDecimal() {
        return (Boolean)this.getConfigurationProperty("graticule.labels.decimal.value", false);
    }

    private Color getBorderColor() {
        return (Color)this.getConfigurationProperty("graticule.border.color", GraticuleLayerType.PROPERTY_BORDER_COLOR_DEFAULT);
    }

    private boolean isCornerLabelsNorth() {
        return (Boolean)this.getConfigurationProperty("graticule.corner.labels.north", false);
    }

    private boolean isCornerLabelsWest() {
        return (Boolean)this.getConfigurationProperty("graticule.corner.labels.west", false);
    }

    private boolean isCornerLabelsEast() {
        return (Boolean)this.getConfigurationProperty("graticule.corner.labels.east", false);
    }

    private boolean isCornerLabelsSouth() {
        return (Boolean)this.getConfigurationProperty("graticule.corner.labels.south", false);
    }

    private boolean isTickmarksShow() {
        return (Boolean)this.getConfigurationProperty("graticule.tickmarks.show", true);
    }

    private boolean isTickmarksInside() {
        return (Boolean)this.getConfigurationProperty("graticule.tickmarks.inside", false);
    }

    private double getTickmarksLength() {
        double tickMarkLengthPts = (Double)this.getConfigurationProperty("graticule.tickmarks.length", 3.0);
        return this.getPtsToPixelsMultiplier() * tickMarkLengthPts;
    }

    private class ProductNodeHandler
    extends ProductNodeListenerAdapter {
        private ProductNodeHandler() {
        }

        @Override
        public void nodeChanged(ProductNodeEvent event) {
            if (event.getSourceNode() == GraticuleLayer.this.getProduct() && "sceneGeoCoding".equals(event.getPropertyName())) {
                GraticuleLayer.this.graticule = null;
                GraticuleLayer.this.fireLayerDataChanged(GraticuleLayer.this.getModelBounds());
            }
        }
    }
}

