/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.jexp.impl;

import org.esa.snap.core.jexp.Function;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.TermTransformer;
import org.esa.snap.core.jexp.impl.Functions;
import org.esa.snap.core.jexp.impl.TermFactory;
import org.esa.snap.core.jexp.impl.TermSimplifier;

public class TermDerivator
implements TermTransformer {
    private final TermSimplifier simplifier;
    private final Symbol variable;

    public TermDerivator(Symbol variable) {
        this(variable, new TermSimplifier());
    }

    public TermDerivator(Symbol variable, TermSimplifier simplifier) {
        this.variable = variable;
        this.simplifier = simplifier;
    }

    @Override
    public Term apply(Term term) {
        Term derivative = term.accept(this);
        return this.simplifier.apply(derivative);
    }

    @Override
    public Term visit(Term.ConstB term) {
        return TermFactory.c(0.0);
    }

    @Override
    public Term visit(Term.ConstI term) {
        return TermFactory.c(0.0);
    }

    @Override
    public Term visit(Term.ConstD term) {
        double v = term.getValue();
        return TermFactory.c(Double.isNaN(v) ? v : 0.0);
    }

    @Override
    public Term visit(Term.ConstS term) {
        return TermFactory.c(0.0);
    }

    @Override
    public Term visit(Term.Ref term) {
        if (term.getSymbol() == this.variable) {
            return TermFactory.c(1.0);
        }
        return TermFactory.c(0.0);
    }

    @Override
    public Term visit(Term.Call term) {
        if (TermDerivator.is(term, Functions.SQ)) {
            return TermFactory.mul(TermFactory.mul(TermFactory.c(2.0), term.getArg()), this.apply(term.getArg()));
        }
        if (TermDerivator.is(term, Functions.SQRT)) {
            return TermFactory.mul(TermFactory.div(TermFactory.c(1.0), TermFactory.mul(TermFactory.c(2.0), TermFactory.sqrt(term.getArg()))), this.apply(term.getArg()));
        }
        if (TermDerivator.is(term, Functions.POW)) {
            if (term.getArg(1).isConst()) {
                double v = term.getArg(1).evalD(null);
                return TermFactory.mul(TermFactory.mul(TermFactory.c(v), TermFactory.pow(term.getArg(), TermFactory.c(v - 1.0))), this.apply(term.getArg(0)));
            }
        } else {
            if (TermDerivator.is(term, Functions.EXP)) {
                return TermFactory.mul(term, this.apply(term.getArg()));
            }
            if (TermDerivator.is(term, Functions.LOG)) {
                return TermFactory.mul(TermFactory.div(TermFactory.c(1.0), term.getArg()), this.apply(term.getArg()));
            }
            if (TermDerivator.is(term, Functions.SIN)) {
                return TermFactory.mul(TermFactory.cos(term.getArg()), this.apply(term.getArg()));
            }
            if (TermDerivator.is(term, Functions.COS)) {
                return TermFactory.mul(TermFactory.neg(TermFactory.sin(term.getArg())), this.apply(term.getArg()));
            }
            if (TermDerivator.is(term, Functions.TAN)) {
                return TermFactory.mul(TermFactory.div(TermFactory.c(1.0), TermFactory.sq(TermFactory.cos(term.getArg()))), this.apply(term.getArg()));
            }
        }
        return this.unsupported(term);
    }

    private static boolean is(Term.Call term, Function f) {
        return term.getFunction() == f;
    }

    @Override
    public Term visit(Term.Cond term) {
        return TermFactory.cond(term.getArg(0), this.apply(term.getArg(1)), this.apply(term.getArg(2)));
    }

    @Override
    public Term visit(Term.Neg term) {
        return TermFactory.neg(this.apply(term.getArg()));
    }

    @Override
    public Term visit(Term.Add term) {
        return TermFactory.add(this.apply(term.getArg(0)), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.Sub term) {
        return TermFactory.sub(this.apply(term.getArg(0)), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.Mul term) {
        Term t1 = term.getArg(0);
        Term t2 = term.getArg(1);
        return TermFactory.add(TermFactory.mul(t1, this.apply(t2)), TermFactory.mul(this.apply(t1), t2));
    }

    @Override
    public Term visit(Term.Div term) {
        Term t1 = term.getArg(0);
        Term t2 = term.getArg(1);
        return TermFactory.div(TermFactory.sub(TermFactory.mul(this.apply(t1), t2), TermFactory.mul(t1, this.apply(t2))), TermFactory.sq(t2));
    }

    @Override
    public Term visit(Term.Assign term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.NotB term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.AndB term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.OrB term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.NotI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.XOrI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.AndI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.OrI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.Mod term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.EqB term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.EqI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.EqD term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.NEqB term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.NEqI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.NEqD term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.LtI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.LtD term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.LeI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.LeD term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.GtI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.GtD term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.GeI term) {
        return this.unsupported(term);
    }

    @Override
    public Term visit(Term.GeD term) {
        return this.unsupported(term);
    }

    private Term unsupported(Term.Op term) {
        throw new UnsupportedOperationException(String.format("derivative of operator '%s'", term.getName()));
    }

    private Term unsupported(Term.Call term) {
        throw new UnsupportedOperationException(String.format("derivative of function '%s'", term.getFunction().getName()));
    }
}

