/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import org.esa.snap.core.image.TiledFileOpImage;
import org.esa.snap.core.util.StringUtils;

public class TiledFileMultiLevelSource
extends AbstractMultiLevelSource {
    private final Path imageDir;
    private final Properties imageProperties;

    public static TiledFileMultiLevelSource create(File imageDir) throws IOException {
        return TiledFileMultiLevelSource.create(imageDir.toPath());
    }

    public static TiledFileMultiLevelSource create(Path imageDir) throws IOException {
        Assert.notNull((Object)imageDir);
        Properties imageProperties = new Properties();
        imageProperties.load(Files.newBufferedReader(imageDir.resolve("image.properties")));
        int levelCount = Integer.parseInt(imageProperties.getProperty("numLevels"));
        int sourceWidth = Integer.parseInt(imageProperties.getProperty("width"));
        int sourceHeight = Integer.parseInt(imageProperties.getProperty("height"));
        String s = imageProperties.getProperty("i2mTransform");
        AffineTransform i2mTransform = new AffineTransform();
        if (s != null) {
            try {
                double[] matrix = StringUtils.toDoubleArray(s, ",");
                if (matrix.length == 6) {
                    i2mTransform = new AffineTransform(matrix);
                }
            }
            catch (IllegalArgumentException matrix) {
                // empty catch block
            }
        }
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(levelCount, i2mTransform, sourceWidth, sourceHeight);
        return new TiledFileMultiLevelSource((MultiLevelModel)model, imageDir, imageProperties);
    }

    public TiledFileMultiLevelSource(MultiLevelModel model, Path imageDir, Properties imageProperties) {
        super(model);
        this.imageDir = imageDir;
        this.imageProperties = imageProperties;
    }

    public RenderedImage createImage(int level) {
        TiledFileOpImage image;
        try {
            image = TiledFileOpImage.create(this.imageDir.resolve(String.valueOf(level)), this.imageProperties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return image;
    }
}

