/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.bc.ceres.jai.operator.InterpretationType;
import com.bc.ceres.jai.operator.PaintDescriptor;
import com.bc.ceres.jai.operator.ReinterpretDescriptor;
import com.bc.ceres.jai.operator.ScalingType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.ClampDescriptor;
import javax.media.jai.operator.CompositeDescriptor;
import javax.media.jai.operator.CompositeDestAlpha;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MatchCDFDescriptor;
import javax.media.jai.operator.MaxDescriptor;
import javax.media.jai.operator.MinDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import javax.media.jai.operator.SubtractFromConstDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RGBChannelDef;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.image.FillConstantOpImage;
import org.esa.snap.core.image.ReplaceValueOpImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.core.util.IntMap;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.runtime.Config;

public class ImageManager {
    private static final boolean CACHE_INTERMEDIATE_TILES = Config.instance().preferences().getBoolean("snap.enableIntermediateTileCaching", false);

    public static ImageManager getInstance() {
        return Holder.instance;
    }

    public static ImageLayout createSingleBandedImageLayout(RasterDataNode rasterDataNode) {
        return ImageManager.createSingleBandedImageLayout(rasterDataNode, ImageManager.getDataBufferType(rasterDataNode.getDataType()));
    }

    public static ImageLayout createSingleBandedImageLayout(RasterDataNode rasterDataNode, int dataBufferType) {
        int width = rasterDataNode.getRasterWidth();
        int height = rasterDataNode.getRasterHeight();
        Dimension tileSize = ImageManager.getPreferredTileSize(rasterDataNode.getProduct());
        return ImageManager.createSingleBandedImageLayout(dataBufferType, width, height, tileSize.width, tileSize.height);
    }

    public static ImageLayout createSingleBandedImageLayout(int dataBufferType, int width, int height, int tileWidth, int tileHeight) {
        SampleModel sampleModel = ImageUtils.createSingleBandedSampleModel(dataBufferType, tileWidth, tileHeight);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        return new ImageLayout(0, 0, width, height, 0, 0, tileWidth, tileHeight, sampleModel, colorModel);
    }

    public static ImageLayout createSingleBandedImageLayout(int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        return ImageManager.createSingleBandedImageLayout(dataBufferType, null, sourceWidth, sourceHeight, tileSize, level);
    }

    public static ImageLayout createSingleBandedImageLayout(int dataBufferType, Point sourcePos, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        if (sourceWidth < 0) {
            throw new IllegalArgumentException("sourceWidth");
        }
        if (sourceHeight < 0) {
            throw new IllegalArgumentException("sourceHeight");
        }
        Rectangle sourceBounds = new Rectangle(sourcePos != null ? sourcePos.x : 0, sourcePos != null ? sourcePos.y : 0, sourceWidth, sourceHeight);
        Rectangle destBounds = DefaultMultiLevelSource.getLevelImageBounds((Rectangle)sourceBounds, (double)level.getScale());
        int destWidth = destBounds.width;
        int destHeight = destBounds.height;
        tileSize = tileSize != null ? tileSize : JAIUtils.computePreferredTileSize(destWidth, destHeight, 1);
        SampleModel sampleModel = ImageUtils.createSingleBandedSampleModel(dataBufferType, tileSize.width, tileSize.height);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        if (colorModel == null) {
            int dataType = sampleModel.getDataType();
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{DataBuffer.getDataTypeSize(dataType)};
            colorModel = new ComponentColorModel(cs, nBits, false, true, 1, dataType);
        }
        return new ImageLayout(destBounds.x, destBounds.y, destWidth, destHeight, 0, 0, tileSize.width, tileSize.height, sampleModel, colorModel);
    }

    public static int getDataBufferType(int productDataType) {
        switch (productDataType) {
            case 10: 
            case 20: {
                return 0;
            }
            case 11: {
                return 2;
            }
            case 21: {
                return 1;
            }
            case 12: 
            case 22: {
                return 3;
            }
            case 30: {
                return 4;
            }
            case 31: {
                return 5;
            }
        }
        throw new IllegalArgumentException("productDataType");
    }

    public static int getProductDataType(int dataBufferType) {
        switch (dataBufferType) {
            case 0: {
                return 20;
            }
            case 2: {
                return 11;
            }
            case 1: {
                return 21;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
        }
        throw new IllegalArgumentException("dataBufferType");
    }

    public static Dimension getPreferredTileSize(Product product) {
        Dimension preferredTileSize = product.getPreferredTileSize();
        Dimension tileSize = preferredTileSize != null ? preferredTileSize : JAIUtils.computePreferredTileSize(product.getSceneRasterWidth(), product.getSceneRasterHeight(), 1);
        return tileSize;
    }

    public static RasterDataNode getUncertaintyBand(RasterDataNode valueBand) {
        String[] roleNames = new String[]{"uncertainty", "error", "variance", "standard_deviation", "confidence"};
        RasterDataNode uncertaintyBand = null;
        for (String roleName : roleNames) {
            uncertaintyBand = valueBand.getAncillaryVariable(roleName);
            if (uncertaintyBand != null) break;
        }
        return uncertaintyBand;
    }

    private static PlanarImage paint(PlanarImage sourceImage, PlanarImage maskImage, Color paintColor) {
        RenderingHints renderingHints = ImageManager.createDefaultRenderingHints((RenderedImage)sourceImage, null);
        if (maskImage != null) {
            sourceImage = PaintDescriptor.create((RenderedImage)sourceImage, (RenderedImage)maskImage, (Color)paintColor, (Boolean)false, (RenderingHints)renderingHints);
        }
        return sourceImage;
    }

    private static PlanarImage paint(PlanarImage sourceImage, PlanarImage maskImage1, Color paintColor1, PlanarImage maskImage2, Color paintColor2) {
        RenderingHints renderingHints = ImageManager.createDefaultRenderingHints((RenderedImage)sourceImage, null);
        if (maskImage1 != null) {
            sourceImage = PaintDescriptor.create((RenderedImage)sourceImage, (RenderedImage)maskImage1, (Color)paintColor1, (Boolean)false, (RenderingHints)renderingHints);
        }
        if (maskImage2 != null) {
            sourceImage = PaintDescriptor.create((RenderedImage)sourceImage, (RenderedImage)maskImage2, (Color)paintColor2, (Boolean)false, (RenderingHints)renderingHints);
        }
        return sourceImage;
    }

    private static PlanarImage paint(PlanarImage sourceImage, PlanarImage maskImage1, Color paintColor1, PlanarImage maskImage2, Color paintColor2, PlanarImage maskImage3, Color paintColor3) {
        RenderingHints renderingHints = ImageManager.createDefaultRenderingHints((RenderedImage)sourceImage, null);
        if (maskImage1 != null) {
            sourceImage = PaintDescriptor.create((RenderedImage)sourceImage, (RenderedImage)maskImage1, (Color)paintColor1, (Boolean)false, (RenderingHints)renderingHints);
        }
        if (maskImage2 != null) {
            sourceImage = PaintDescriptor.create((RenderedImage)sourceImage, (RenderedImage)maskImage2, (Color)paintColor2, (Boolean)false, (RenderingHints)renderingHints);
        }
        if (maskImage3 != null) {
            sourceImage = PaintDescriptor.create((RenderedImage)sourceImage, (RenderedImage)maskImage3, (Color)paintColor3, (Boolean)false, (RenderingHints)renderingHints);
        }
        return sourceImage;
    }

    private static PlanarImage paint(PlanarImage sourceImage, double transparency, PlanarImage maskColorImage) {
        RenderingHints renderingHints = ImageManager.createDefaultRenderingHints((RenderedImage)sourceImage, null);
        RenderedOp maskImage = ConstantDescriptor.create((Float)Float.valueOf(sourceImage.getWidth()), (Float)Float.valueOf(sourceImage.getHeight()), (Number[])new Byte[]{(byte)(255.0 * (1.0 - transparency))}, (RenderingHints)renderingHints);
        return ImageManager.paintImpl(sourceImage, maskColorImage, (RenderedImage)maskImage, renderingHints);
    }

    private static PlanarImage paint(PlanarImage sourceImage, PlanarImage maskImage, PlanarImage maskColorImage) {
        RenderingHints renderingHints = ImageManager.createDefaultRenderingHints((RenderedImage)sourceImage, null);
        return ImageManager.paintImpl(sourceImage, maskColorImage, (RenderedImage)maskImage, renderingHints);
    }

    private static PlanarImage paintImpl(PlanarImage sourceImage, PlanarImage maskColorImage, RenderedImage maskImage, RenderingHints renderingHints) {
        RenderedOp alphaImage;
        boolean targetHasAlpha;
        boolean bl = targetHasAlpha = sourceImage.getNumBands() == 4 || maskColorImage.getNumBands() == 4;
        if (sourceImage.getNumBands() == 4) {
            alphaImage = BandSelectDescriptor.create((RenderedImage)sourceImage, (int[])new int[]{3}, (RenderingHints)renderingHints);
            maskImage = MinDescriptor.create((RenderedImage)maskImage, (RenderedImage)alphaImage, (RenderingHints)renderingHints);
            sourceImage = BandSelectDescriptor.create((RenderedImage)sourceImage, (int[])new int[]{0, 1, 2}, (RenderingHints)renderingHints);
        }
        if (maskColorImage.getNumBands() == 4) {
            alphaImage = BandSelectDescriptor.create((RenderedImage)maskColorImage, (int[])new int[]{3}, (RenderingHints)renderingHints);
            maskImage = MinDescriptor.create((RenderedImage)maskImage, (RenderedImage)alphaImage, (RenderingHints)renderingHints);
            maskColorImage = BandSelectDescriptor.create((RenderedImage)maskColorImage, (int[])new int[]{0, 1, 2}, (RenderingHints)renderingHints);
        }
        return CompositeDescriptor.create((RenderedImage)sourceImage, (RenderedImage)maskColorImage, (RenderedImage)maskImage, null, (Boolean)false, (CompositeDestAlpha)(targetHasAlpha ? CompositeDescriptor.DESTINATION_ALPHA_LAST : CompositeDescriptor.NO_DESTINATION_ALPHA), (RenderingHints)renderingHints);
    }

    private static PlanarImage createByteIndexedImage(RasterDataNode raster, RenderedImage sourceImage, ImageInfo imageInfo) {
        ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
        double minSample = colorPaletteDef.getMinDisplaySample();
        double maxSample = colorPaletteDef.getMaxDisplaySample();
        if (ImageManager.isClassificationBand(raster)) {
            IntMap sampleColorIndexMap = new IntMap((int)minSample - 1, 4098);
            ColorPaletteDef.Point[] points = colorPaletteDef.getPoints();
            for (int colorIndex = 0; colorIndex < points.length; ++colorIndex) {
                sampleColorIndexMap.putValue((int)ImageManager.getSample(points[colorIndex]), colorIndex);
            }
            int undefinedIndex = colorPaletteDef.getNumPoints();
            return ImageManager.createIndexedImage(sourceImage, sampleColorIndexMap, undefinedIndex);
        }
        return ImageManager.createByteIndexedImage(raster, sourceImage, minSample, maxSample, 1.0);
    }

    private static boolean isClassificationBand(RasterDataNode raster) {
        return (raster instanceof Band ? ((Band)raster).getIndexCoding() : null) != null;
    }

    private static PlanarImage createByteIndexedImage(RasterDataNode raster, RenderedImage sourceImage, double minSample, double maxSample, double gamma) {
        double newMin = raster.scaleInverse(minSample);
        double newMax = raster.scaleInverse(maxSample);
        if (ImageManager.mustReinterpretSourceImage(raster, sourceImage)) {
            sourceImage = ReinterpretDescriptor.create((RenderedImage)sourceImage, (double)1.0, (double)0.0, (ScalingType)ReinterpretDescriptor.LINEAR, (InterpretationType)ReinterpretDescriptor.INTERPRET_BYTE_SIGNED, null);
        }
        boolean logarithmicDisplay = raster.getImageInfo().isLogScaled();
        boolean rasterIsLog10Scaled = raster.isLog10Scaled();
        if (logarithmicDisplay) {
            if (!rasterIsLog10Scaled) {
                double offset = raster.scaleInverse(0.0);
                sourceImage = ReinterpretDescriptor.create((RenderedImage)sourceImage, (double)1.0, (double)(-offset), (ScalingType)ReinterpretDescriptor.LOGARITHMIC, (InterpretationType)ReinterpretDescriptor.AWT, null);
                newMin = Math.log10(newMin - offset);
                newMax = Math.log10(newMax - offset);
            }
        } else if (rasterIsLog10Scaled) {
            sourceImage = ReinterpretDescriptor.create((RenderedImage)sourceImage, (double)raster.getScalingFactor(), (double)raster.getScalingOffset(), (ScalingType)ReinterpretDescriptor.EXPONENTIAL, (InterpretationType)ReinterpretDescriptor.AWT, null);
            newMin = minSample;
            newMax = maxSample;
        }
        double factor = 255.0 / (newMax - newMin);
        double offset = 255.0 * newMin / (newMin - newMax);
        PlanarImage image = ImageManager.createRescaleOp(sourceImage, factor, offset);
        image = ImageManager.createByteFormatOp((RenderedImage)image);
        if (gamma != 1.0) {
            byte[] gammaCurve = MathUtils.createGammaCurve(gamma, new byte[256]);
            LookupTableJAI lookupTable = new LookupTableJAI(gammaCurve);
            image = LookupDescriptor.create((RenderedImage)image, (LookupTableJAI)lookupTable, (RenderingHints)ImageManager.createDefaultRenderingHints((RenderedImage)image, null));
        }
        return image;
    }

    private static boolean mustReinterpretSourceImage(RasterDataNode raster, RenderedImage sourceImage) {
        return sourceImage.getSampleModel().getDataType() == 0 && raster.getDataType() == 10;
    }

    private static RenderingHints createDefaultRenderingHints(RenderedImage sourceImage, ImageLayout targetLayout) {
        HashMap<RenderingHints.Key, ImageLayout> map = new HashMap<RenderingHints.Key, ImageLayout>(7);
        if (!CACHE_INTERMEDIATE_TILES) {
            map.put(JAI.KEY_TILE_CACHE, null);
        }
        if (sourceImage != null) {
            if (targetLayout == null) {
                targetLayout = new ImageLayout();
            }
            if (!targetLayout.isValid(16)) {
                targetLayout.setTileGridXOffset(sourceImage.getTileGridXOffset());
            }
            if (!targetLayout.isValid(32)) {
                targetLayout.setTileGridYOffset(sourceImage.getTileGridYOffset());
            }
            if (!targetLayout.isValid(64)) {
                targetLayout.setTileWidth(sourceImage.getTileWidth());
            }
            if (!targetLayout.isValid(128)) {
                targetLayout.setTileHeight(sourceImage.getTileHeight());
            }
            map.put(JAI.KEY_IMAGE_LAYOUT, targetLayout);
        }
        return new RenderingHints(map);
    }

    private static PlanarImage createIndexedImage(RenderedImage sourceImage, IntMap intMap, int undefinedIndex) {
        LookupTableJAI lookup;
        Object[] table;
        if (sourceImage.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException();
        }
        int[][] ranges = intMap.getRanges();
        int keyMin = ranges[0][0];
        int keyMax = ranges[0][1];
        int valueMin = ranges[1][0];
        int valueMax = ranges[1][1];
        int keyRange = 1 + keyMax - keyMin;
        int valueRange = 1 + valueMax - valueMin;
        if (keyRange > Short.MAX_VALUE) {
            throw new IllegalArgumentException("intMap: keyRange > Short.MAX_VALUE");
        }
        if (valueRange <= 256) {
            table = new byte[keyRange + 2];
            for (int i = 1; i < table.length - 1; ++i) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = (byte)(value != Integer.MIN_VALUE ? value : undefinedIndex);
            }
            table[0] = (byte)undefinedIndex;
            table[table.length - 1] = (byte)undefinedIndex;
            lookup = new LookupTableJAI(table, keyMin - 1);
        } else if (valueRange <= 65536) {
            table = new short[keyRange + 2];
            for (int i = 1; i < table.length; ++i) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = (short)(value != Integer.MIN_VALUE ? value : undefinedIndex);
            }
            table[0] = (short)undefinedIndex;
            table[table.length - 1] = (short)undefinedIndex;
            lookup = new LookupTableJAI((short[])table, keyMin - 1, valueRange > Short.MAX_VALUE);
        } else {
            table = new int[keyRange + 2];
            for (int i = 1; i < table.length; ++i) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = value != Integer.MIN_VALUE ? value : undefinedIndex;
            }
            table[0] = undefinedIndex;
            table[table.length - 1] = undefinedIndex;
            lookup = new LookupTableJAI((int[])table, keyMin - 1);
        }
        RenderingHints hints = ImageManager.createDefaultRenderingHints(sourceImage, null);
        sourceImage = ClampDescriptor.create((RenderedImage)sourceImage, (double[])new double[]{keyMin - 1}, (double[])new double[]{keyMax + 1}, (RenderingHints)hints);
        return LookupDescriptor.create((RenderedImage)sourceImage, (LookupTableJAI)lookup, (RenderingHints)hints);
    }

    private static PlanarImage createMergeRgbaOp(RenderedImage[] sourceImages, RenderedImage[] maskOpImages, ImageInfo.HistogramMatching histogramMatching, Stx[] stxs) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(sourceImages[0], null);
        if (histogramMatching == ImageInfo.HistogramMatching.None) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(sourceImages[0]);
            pb.addSource(sourceImages[1]);
            pb.addSource(sourceImages[2]);
            RenderedImage alpha = ImageManager.createMapOp(maskOpImages);
            if (alpha != null) {
                pb.addSource(alpha);
            }
            return JAI.create((String)"bandmerge", (ParameterBlock)pb, (RenderingHints)hints);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(sourceImages[0]);
        pb.addSource(sourceImages[1]);
        pb.addSource(sourceImages[2]);
        RenderedOp image = JAI.create((String)"bandmerge", (ParameterBlock)pb, (RenderingHints)hints);
        image = histogramMatching == ImageInfo.HistogramMatching.Equalize ? ImageManager.createMatchCdfEqualizeImage((PlanarImage)image, stxs) : ImageManager.createMatchCdfNormalizeImage((PlanarImage)image, stxs);
        RenderedImage alpha = ImageManager.createMapOp(maskOpImages);
        if (alpha != null) {
            pb = new ParameterBlock();
            pb.addSource(image);
            pb.addSource(alpha);
            image = JAI.create((String)"bandmerge", (ParameterBlock)pb, (RenderingHints)hints);
        }
        return image;
    }

    private static RenderedImage createMapOp(RenderedImage[] maskOpImages) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(maskOpImages.length > 0 ? maskOpImages[0] : null, null);
        RenderedImage alpha = null;
        for (RenderedImage maskOpImage : maskOpImages) {
            if (maskOpImage == null) continue;
            alpha = alpha != null ? MaxDescriptor.create((RenderedImage)alpha, (RenderedImage)maskOpImage, (RenderingHints)hints) : maskOpImage;
        }
        return alpha;
    }

    private static PlanarImage createLookupRgbImage(RasterDataNode rasterDataNode, PlanarImage sourceImage, ImageInfo imageInfo) {
        byte[][] lutData;
        Color[] palette;
        ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
        if (ImageManager.isClassificationBand(rasterDataNode)) {
            Color[] origPalette = colorPaletteDef.getColors();
            palette = Arrays.copyOf(origPalette, origPalette.length + 1);
            palette[palette.length - 1] = imageInfo.getNoDataColor();
        } else {
            palette = ImageManager.createColorPalette(imageInfo);
        }
        if (colorPaletteDef.isFullyOpaque()) {
            lutData = new byte[3][palette.length];
            for (int i = 0; i < palette.length; ++i) {
                lutData[0][i] = (byte)palette[i].getRed();
                lutData[1][i] = (byte)palette[i].getGreen();
                lutData[2][i] = (byte)palette[i].getBlue();
            }
        } else {
            lutData = new byte[4][palette.length];
            for (int i = 0; i < palette.length; ++i) {
                lutData[0][i] = (byte)palette[i].getRed();
                lutData[1][i] = (byte)palette[i].getGreen();
                lutData[2][i] = (byte)palette[i].getBlue();
                lutData[3][i] = (byte)palette[i].getAlpha();
            }
        }
        return ImageManager.createLookupOp((RenderedImage)sourceImage, lutData);
    }

    private static PlanarImage createMatchCdfImage(PlanarImage sourceImage, ImageInfo.HistogramMatching histogramMatching, Stx[] stxs) {
        boolean doNormalize;
        boolean doEqualize = ImageInfo.HistogramMatching.Equalize == histogramMatching;
        boolean bl = doNormalize = ImageInfo.HistogramMatching.Normalize == histogramMatching;
        if (doEqualize) {
            sourceImage = ImageManager.createMatchCdfEqualizeImage(sourceImage, stxs);
        } else if (doNormalize) {
            sourceImage = ImageManager.createMatchCdfNormalizeImage(sourceImage, stxs);
        }
        return sourceImage;
    }

    private static PlanarImage createMatchCdfEqualizeImage(PlanarImage sourceImage, Stx[] stxs) {
        Assert.notNull((Object)sourceImage, (String)"sourceImage");
        Assert.notNull((Object)stxs, (String)"stxs");
        int numBands = sourceImage.getSampleModel().getNumBands();
        Assert.argument((stxs.length == numBands ? 1 : 0) != 0, (String)"stxs");
        Histogram histogram = ImageManager.createHistogram(sourceImage, stxs);
        float[][] eqCDF = new float[numBands][];
        for (int b = 0; b < numBands; ++b) {
            int binCount = histogram.getNumBins(b);
            eqCDF[b] = new float[binCount];
            for (int i = 0; i < binCount; ++i) {
                eqCDF[b][i] = (float)(i + 1) / (float)binCount;
            }
        }
        return MatchCDFDescriptor.create((RenderedImage)sourceImage, (float[][])eqCDF, (RenderingHints)ImageManager.createDefaultRenderingHints((RenderedImage)sourceImage, null));
    }

    private static Histogram createHistogram(PlanarImage sourceImage, Stx[] stxs) {
        Histogram histogram = ImageManager.createHistogram(stxs);
        sourceImage.setProperty("histogram", (Object)histogram);
        if (sourceImage instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)sourceImage;
            renderedOp.getRendering().setProperty("histogram", (Object)histogram);
        }
        return histogram;
    }

    private static Histogram createHistogram(Stx[] stxs) {
        Histogram histogram = new Histogram(stxs[0].getHistogramBinCount(), 0.0, 256.0, stxs.length);
        for (int i = 0; i < stxs.length; ++i) {
            System.arraycopy(stxs[i].getHistogramBins(), 0, histogram.getBins(i), 0, stxs[0].getHistogramBinCount());
        }
        return histogram;
    }

    private static PlanarImage createMatchCdfNormalizeImage(PlanarImage sourceImage, Stx[] stxs) {
        double dev = 256.0;
        int numBands = sourceImage.getSampleModel().getNumBands();
        double[] means = new double[numBands];
        Arrays.fill(means, 128.0);
        double[] stdDevs = new double[numBands];
        Arrays.fill(stdDevs, 64.0);
        return ImageManager.createHistogramNormalizedImage(sourceImage, stxs, means, stdDevs);
    }

    private static PlanarImage createHistogramNormalizedImage(PlanarImage sourceImage, Stx[] stxs, double[] mean, double[] stdDev) {
        int binCount;
        int b;
        int numBands = sourceImage.getSampleModel().getNumBands();
        Assert.argument((numBands == mean.length ? 1 : 0) != 0, (String)"length of mean must be equal to number of bands in the image");
        Assert.argument((numBands == stdDev.length ? 1 : 0) != 0, (String)"length of stdDev must be equal to number of bands in the image");
        Histogram histogram = ImageManager.createHistogram(sourceImage, stxs);
        float[][] normCDF = new float[numBands][];
        for (b = 0; b < numBands; ++b) {
            binCount = histogram.getNumBins(b);
            normCDF[b] = new float[binCount];
            double mu = mean[b];
            double twoSigmaSquared = 2.0 * stdDev[b] * stdDev[b];
            normCDF[b][0] = (float)Math.exp(-mu * mu / twoSigmaSquared);
            for (int i = 1; i < binCount; ++i) {
                double deviation = (double)i - mu;
                normCDF[b][i] = normCDF[b][i - 1] + (float)Math.exp(-deviation * deviation / twoSigmaSquared);
            }
        }
        for (b = 0; b < numBands; ++b) {
            binCount = histogram.getNumBins(b);
            double CDFnormLast = normCDF[b][binCount - 1];
            int i = 0;
            while (i < binCount) {
                float[] fArray = normCDF[b];
                int n = i++;
                fArray[n] = (float)((double)fArray[n] / CDFnormLast);
            }
        }
        return MatchCDFDescriptor.create((RenderedImage)sourceImage, (float[][])normCDF, (RenderingHints)ImageManager.createDefaultRenderingHints((RenderedImage)sourceImage, null));
    }

    private static PlanarImage getLevelImage(MultiLevelImage levelZeroImage, int level) {
        RenderedImage image = levelZeroImage.getImage(level);
        return PlanarImage.wrapRenderedImage((RenderedImage)image);
    }

    public static PlanarImage createColoredMaskImage(Color color, RenderedImage alphaImage, boolean invertAlpha) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(alphaImage, null);
        return ImageManager.createColoredMaskImage(color, (RenderedImage)(invertAlpha ? InvertDescriptor.create((RenderedImage)alphaImage, (RenderingHints)hints) : alphaImage), hints);
    }

    public static PlanarImage createColoredMaskImage(RenderedImage maskImage, Color color, double opacity) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(maskImage, null);
        RenderedOp alphaImage = MultiplyConstDescriptor.create((RenderedImage)maskImage, (double[])new double[]{opacity}, (RenderingHints)hints);
        return ImageManager.createColoredMaskImage(color, (RenderedImage)alphaImage, hints);
    }

    public static PlanarImage createColoredMaskImage(Color color, RenderedImage alphaImage, RenderingHints hints) {
        RenderedOp colorImage = ConstantDescriptor.create((Float)Float.valueOf(alphaImage.getWidth()), (Float)Float.valueOf(alphaImage.getHeight()), (Number[])new Byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()}, (RenderingHints)hints);
        return BandMergeDescriptor.create((RenderedImage)colorImage, (RenderedImage)alphaImage, (RenderingHints)hints);
    }

    public static MultiLevelImage createMaskedGeophysicalImage(RasterDataNode node, Number maskValue) {
        MultiLevelImage varImage = node.getGeophysicalImage();
        if (node.getValidPixelExpression() != null) {
            varImage = ImageManager.replaceInvalidValues(node, varImage, node.getValidMaskImage(), maskValue);
        } else if (node.isNoDataValueSet() && node.isNoDataValueUsed() && Double.compare(maskValue.doubleValue(), node.getGeophysicalNoDataValue()) != 0) {
            varImage = ImageManager.replaceNoDataValue(node, varImage, node.getGeophysicalNoDataValue(), maskValue);
        }
        return varImage;
    }

    private static MultiLevelImage replaceInvalidValues(RasterDataNode rasterDataNode, final MultiLevelImage srcImage, final MultiLevelImage maskImage, final Number fillValue) {
        MultiLevelModel multiLevelModel = rasterDataNode.getMultiLevelModel();
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int sourceLevel) {
                return new FillConstantOpImage(srcImage.getImage(sourceLevel), maskImage.getImage(sourceLevel), fillValue);
            }
        });
    }

    private static MultiLevelImage replaceNoDataValue(RasterDataNode rasterDataNode, final MultiLevelImage srcImage, final double noDataValue, final Number newValue) {
        MultiLevelModel multiLevelModel = rasterDataNode.getMultiLevelModel();
        final int targetDataType = ImageManager.getDataBufferType(rasterDataNode.getGeophysicalDataType());
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int sourceLevel) {
                return new ReplaceValueOpImage(srcImage.getImage(sourceLevel), noDataValue, newValue, targetDataType);
            }
        });
    }

    public static RenderedImage createFormatOp(RenderedImage image, int dataType) {
        return ImageManager.createFormatOp(image, dataType, null);
    }

    public static RenderedImage createFormatOp(RenderedImage image, int dataType, ImageLayout targetLayout) {
        if (image.getSampleModel().getDataType() == dataType && targetLayout == null) {
            return PlanarImage.wrapRenderedImage((RenderedImage)image);
        }
        return FormatDescriptor.create((RenderedImage)image, (Integer)dataType, (RenderingHints)ImageManager.createDefaultRenderingHints(image, targetLayout));
    }

    private static PlanarImage createRescaleOp(RenderedImage src, double factor, double offset) {
        if (factor == 1.0 && offset == 0.0) {
            return PlanarImage.wrapRenderedImage((RenderedImage)src);
        }
        return RescaleDescriptor.create((RenderedImage)src, (double[])new double[]{factor}, (double[])new double[]{offset}, (RenderingHints)ImageManager.createDefaultRenderingHints(src, null));
    }

    private static PlanarImage createLookupOp(RenderedImage src, byte[][] lookupTable) {
        LookupTableJAI lookup = new LookupTableJAI(lookupTable);
        return LookupDescriptor.create((RenderedImage)src, (LookupTableJAI)lookup, (RenderingHints)ImageManager.createDefaultRenderingHints(src, null));
    }

    private static PlanarImage createByteFormatOp(RenderedImage src) {
        ColorModel cm = ImageUtils.create8BitGreyscaleColorModel();
        SampleModel sm = cm.createCompatibleSampleModel(src.getTileWidth(), src.getTileHeight());
        ImageLayout layout = new ImageLayout(src);
        layout.setColorModel(cm);
        layout.setSampleModel(sm);
        return FormatDescriptor.create((RenderedImage)src, (Integer)0, (RenderingHints)ImageManager.createDefaultRenderingHints(src, layout));
    }

    public static Color[] createColorPalette(ImageInfo imageInfo) {
        double maxSample;
        double minSample;
        Debug.assertNotNull(imageInfo);
        boolean logScaled = imageInfo.isLogScaled();
        ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
        Debug.assertNotNull(cpd);
        Debug.assertTrue(cpd.getNumPoints() >= 2);
        int numColors = cpd.getNumColors();
        Color[] colorPalette = new Color[numColors];
        ImageInfo.UncertaintyVisualisationMode uvMode = imageInfo.getUncertaintyVisualisationMode();
        if (uvMode == ImageInfo.UncertaintyVisualisationMode.Transparency_Blending) {
            for (int i = 0; i < colorPalette.length; ++i) {
                int alpha = 255 - 256 * i / colorPalette.length;
                colorPalette[i] = new Color(255, 255, 255, alpha);
            }
            return colorPalette;
        }
        if (uvMode == ImageInfo.UncertaintyVisualisationMode.Monochromatic_Blending) {
            Color color = cpd.getLastPoint().getColor();
            for (int i = 0; i < colorPalette.length; ++i) {
                int alpha = 256 * i / colorPalette.length;
                colorPalette[i] = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            }
            return colorPalette;
        }
        if (logScaled) {
            minSample = ImageManager.getSampleLog(cpd.getFirstPoint());
            maxSample = ImageManager.getSampleLog(cpd.getLastPoint());
        } else {
            minSample = ImageManager.getSample(cpd.getFirstPoint());
            maxSample = ImageManager.getSample(cpd.getLastPoint());
        }
        double scalingFactor = 1.0 / ((double)numColors - 1.0);
        int pointIndex = 0;
        int maxPointIndex = cpd.getNumPoints() - 2;
        BorderSamplesAndColors boSaCo = ImageManager.getBorderSamplesAndColors(imageInfo, pointIndex, null);
        for (int i = 0; i < numColors - 1; ++i) {
            double w = (double)i * scalingFactor;
            double sample = minSample + w * (maxSample - minSample);
            if (sample >= boSaCo.sample2) {
                ++pointIndex;
                pointIndex = Math.min(pointIndex, maxPointIndex);
                boSaCo = ImageManager.getBorderSamplesAndColors(imageInfo, pointIndex, boSaCo);
            }
            colorPalette[i] = cpd.isDiscrete() ? boSaCo.color1 : ImageManager.computeColor(sample, boSaCo);
        }
        colorPalette[numColors - 1] = boSaCo.color2;
        if (uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Blending || uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Overlay) {
            boolean blend = uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Blending;
            int alpha = 127;
            for (int i = 0; i < colorPalette.length; ++i) {
                Color color = colorPalette[i];
                if (blend) {
                    alpha = 256 * i / colorPalette.length;
                }
                colorPalette[i] = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            }
        }
        return colorPalette;
    }

    private static double getSample(ColorPaletteDef.Point point) {
        return point.getSample();
    }

    private static double getSampleLog(ColorPaletteDef.Point point) {
        return Stx.LOG10_SCALING.scale(ImageManager.getSample(point));
    }

    private static BorderSamplesAndColors getBorderSamplesAndColors(ImageInfo imageInfo, int pointIdx, BorderSamplesAndColors boSaCo) {
        if (boSaCo == null) {
            boSaCo = new BorderSamplesAndColors();
        }
        boolean logScaled = imageInfo.isLogScaled();
        ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
        ColorPaletteDef.Point p1 = cpd.getPointAt(pointIdx);
        ColorPaletteDef.Point p2 = cpd.getPointAt(pointIdx + 1);
        if (logScaled) {
            boSaCo.sample1 = ImageManager.getSampleLog(p1);
            boSaCo.sample2 = ImageManager.getSampleLog(p2);
        } else {
            boSaCo.sample1 = ImageManager.getSample(p1);
            boSaCo.sample2 = ImageManager.getSample(p2);
        }
        boSaCo.color1 = p1.getColor();
        boSaCo.color2 = p2.getColor();
        return boSaCo;
    }

    private static Color computeColor(double sample, BorderSamplesAndColors boSaCo) {
        double f = (sample - boSaCo.sample1) / (boSaCo.sample2 - boSaCo.sample1);
        double r1 = boSaCo.color1.getRed();
        double r2 = boSaCo.color2.getRed();
        double g1 = boSaCo.color1.getGreen();
        double g2 = boSaCo.color2.getGreen();
        double b1 = boSaCo.color1.getBlue();
        double b2 = boSaCo.color2.getBlue();
        double a1 = boSaCo.color1.getAlpha();
        double a2 = boSaCo.color2.getAlpha();
        int red = (int)MathUtils.roundAndCrop(r1 + f * (r2 - r1), 0L, 255L);
        int green = (int)MathUtils.roundAndCrop(g1 + f * (g2 - g1), 0L, 255L);
        int blue = (int)MathUtils.roundAndCrop(b1 + f * (b2 - b1), 0L, 255L);
        int alpha = (int)MathUtils.roundAndCrop(a1 + f * (a2 - a1), 0L, 255L);
        return new Color(red, green, blue, alpha);
    }

    public PlanarImage getSourceImage(RasterDataNode rasterDataNode, int level) {
        return ImageManager.getLevelImage(rasterDataNode.getSourceImage(), level);
    }

    public PlanarImage getValidMaskImage(RasterDataNode rasterDataNode, int level) {
        if (rasterDataNode.isValidMaskUsed()) {
            return ImageManager.getLevelImage(rasterDataNode.getValidMaskImage(), level);
        }
        return null;
    }

    public PlanarImage getGeophysicalImage(RasterDataNode rasterDataNode, int level) {
        return ImageManager.getLevelImage(rasterDataNode.getGeophysicalImage(), level);
    }

    public RenderedImage createColoredBandImage(RasterDataNode[] rasterDataNodes, ImageInfo imageInfo, int level) {
        Assert.notNull((Object)rasterDataNodes, (String)"rasterDataNodes");
        Assert.state((rasterDataNodes.length == 1 || rasterDataNodes.length == 3 || rasterDataNodes.length == 4 ? 1 : 0) != 0, (String)"invalid number of bands");
        this.prepareImageInfos(rasterDataNodes, ProgressMonitor.NULL);
        if (rasterDataNodes.length == 1) {
            return this.createColored1BandImage(rasterDataNodes[0], imageInfo, level);
        }
        return this.createColored3BandImage(rasterDataNodes, imageInfo, level);
    }

    private PlanarImage createColored1BandImage(RasterDataNode valueBand, ImageInfo valueImageInfo, int level) {
        ImageInfo uncertaintyImageInfo;
        ImageInfo.UncertaintyVisualisationMode visualisationMode;
        Assert.notNull((Object)valueBand, (String)"valueBand");
        if (valueImageInfo == null) {
            valueImageInfo = valueBand.getImageInfo(ProgressMonitor.NULL);
        }
        Assert.notNull((Object)valueImageInfo, (String)"valueImageInfo");
        PlanarImage sourceImage = this.getSourceImage(valueBand, level);
        PlanarImage valueValidMaskImage = this.getValidMaskImage(valueBand, level);
        PlanarImage valueImage = ImageManager.createByteIndexedImage(valueBand, (RenderedImage)sourceImage, valueImageInfo);
        valueImage = ImageManager.createMatchCdfImage(valueImage, valueImageInfo.getHistogramMatching(), new Stx[]{valueBand.getStx()});
        valueImage = ImageManager.createLookupRgbImage(valueBand, valueImage, valueImageInfo);
        RasterDataNode uncertaintyBand = ImageManager.getUncertaintyBand(valueBand);
        if (uncertaintyBand != null && (visualisationMode = (uncertaintyImageInfo = uncertaintyBand.getImageInfo(ProgressMonitor.NULL)).getUncertaintyVisualisationMode()) != ImageInfo.UncertaintyVisualisationMode.None) {
            PlanarImage uncertaintySourceImage = this.getSourceImage(uncertaintyBand, level);
            PlanarImage uncertaintyValidMaskImage = this.getValidMaskImage(uncertaintyBand, level);
            if (visualisationMode == ImageInfo.UncertaintyVisualisationMode.Transparency_Blending) {
                PlanarImage confidenceImage = this.createByteIndexedImage(uncertaintyBand, uncertaintySourceImage, uncertaintyImageInfo, true);
                valueImage = ImageManager.paint(valueImage, confidenceImage, new Color(0, 0, 0, 0), valueValidMaskImage, valueImageInfo.getNoDataColor(), uncertaintyValidMaskImage, uncertaintyImageInfo.getNoDataColor());
            } else if (visualisationMode == ImageInfo.UncertaintyVisualisationMode.Monochromatic_Blending) {
                PlanarImage confidenceImage = this.createByteIndexedImage(uncertaintyBand, uncertaintySourceImage, uncertaintyImageInfo, true);
                valueImage = ImageManager.paint(valueImage, confidenceImage, uncertaintyImageInfo.getColorPaletteDef().getLastPoint().getColor(), valueValidMaskImage, valueImageInfo.getNoDataColor(), uncertaintyValidMaskImage, uncertaintyImageInfo.getNoDataColor());
            } else if (visualisationMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Blending) {
                PlanarImage confidenceImage = this.createByteIndexedImage(uncertaintyBand, uncertaintySourceImage, uncertaintyImageInfo, true);
                RenderedOp distrustImage = SubtractFromConstDescriptor.create((RenderedImage)confidenceImage, (double[])new double[]{255.0}, (RenderingHints)ImageManager.createDefaultRenderingHints((RenderedImage)confidenceImage, null));
                PlanarImage uncertaintyImage = ImageManager.createLookupRgbImage(uncertaintyBand, (PlanarImage)distrustImage, uncertaintyImageInfo);
                valueImage = ImageManager.paint(valueImage, confidenceImage, uncertaintyImage);
                valueImage = ImageManager.paint(valueImage, valueValidMaskImage, valueImageInfo.getNoDataColor(), uncertaintyValidMaskImage, uncertaintyImageInfo.getNoDataColor());
            } else if (visualisationMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Overlay) {
                PlanarImage distrustImage = this.createByteIndexedImage(uncertaintyBand, uncertaintySourceImage, uncertaintyImageInfo, false);
                PlanarImage uncertaintyImage = ImageManager.createLookupRgbImage(uncertaintyBand, distrustImage, uncertaintyImageInfo);
                valueImage = ImageManager.paint(valueImage, 0.5, uncertaintyImage);
                valueImage = ImageManager.paint(valueImage, valueValidMaskImage, valueImageInfo.getNoDataColor(), uncertaintyValidMaskImage, uncertaintyImageInfo.getNoDataColor());
            } else {
                Assert.state((boolean)false, (String)("unknown uncertainty visualisation mode " + visualisationMode));
            }
            return valueImage;
        }
        if (valueValidMaskImage != null) {
            valueImage = ImageManager.paint(valueImage, valueValidMaskImage, valueImageInfo.getNoDataColor());
        }
        return valueImage;
    }

    private PlanarImage createColored3BandImage(RasterDataNode[] rasters, ImageInfo rgbImageInfo, int level) {
        Assert.notNull((Object)rasters, (String)"rasters");
        Assert.notNull((Object)rgbImageInfo, (String)"rgbImageInfo");
        RenderedImage[] images = new RenderedImage[rasters.length];
        RenderedImage[] validMaskImages = new RenderedImage[rasters.length];
        Stx[] stxs = new Stx[rasters.length];
        for (int i = 0; i < rasters.length; ++i) {
            RasterDataNode raster = rasters[i];
            stxs[i] = raster.getStx();
            PlanarImage sourceImage = this.getSourceImage(raster, level);
            images[i] = ImageManager.createByteIndexedImage(raster, (RenderedImage)sourceImage, rgbImageInfo.getRgbChannelDef().getMinDisplaySample(i), rgbImageInfo.getRgbChannelDef().getMaxDisplaySample(i), rgbImageInfo.getRgbChannelDef().getGamma(i));
            validMaskImages[i] = this.getValidMaskImage(raster, level);
        }
        return ImageManager.createMergeRgbaOp(images, validMaskImages, rgbImageInfo.getHistogramMatching(), stxs);
    }

    private PlanarImage createByteIndexedImage(RasterDataNode band, PlanarImage sourceImage, ImageInfo imageInfo, boolean invertRamp) {
        ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
        if (invertRamp) {
            return ImageManager.createByteIndexedImage(band, (RenderedImage)sourceImage, colorPaletteDef.getMaxDisplaySample(), colorPaletteDef.getMinDisplaySample(), 1.0);
        }
        return ImageManager.createByteIndexedImage(band, (RenderedImage)sourceImage, colorPaletteDef.getMinDisplaySample(), colorPaletteDef.getMaxDisplaySample(), 1.0);
    }

    public ImageInfo getImageInfo(RasterDataNode[] rasters) {
        Assert.notNull((Object)rasters, (String)"rasters");
        Assert.argument((rasters.length == 1 || rasters.length == 3 ? 1 : 0) != 0, (String)"rasters.length == 1 || rasters.length == 3");
        if (rasters.length == 1) {
            RasterDataNode raster = rasters[0];
            Assert.state((raster.getImageInfo() != null ? 1 : 0) != 0, (String)"raster.getImageInfo() != null");
            return raster.getImageInfo();
        }
        RGBChannelDef rgbChannelDef = new RGBChannelDef();
        for (int i = 0; i < rasters.length; ++i) {
            RasterDataNode raster = rasters[i];
            Assert.state((rasters[i].getImageInfo() != null ? 1 : 0) != 0, (String)"rasters[i].getImageInfo() != null");
            ImageInfo imageInfo = raster.getImageInfo();
            rgbChannelDef.setSourceName(i, raster.getName());
            rgbChannelDef.setMinDisplaySample(i, imageInfo.getColorPaletteDef().getMinDisplaySample());
            rgbChannelDef.setMaxDisplaySample(i, imageInfo.getColorPaletteDef().getMaxDisplaySample());
        }
        return new ImageInfo(rgbChannelDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareImageInfos(RasterDataNode[] rasterDataNodes, ProgressMonitor pm) {
        int numTaskSteps = 0;
        for (RasterDataNode raster : rasterDataNodes) {
            numTaskSteps += raster.getImageInfo() == null ? 1 : 0;
        }
        pm.beginTask("Computing image statistics", numTaskSteps);
        try {
            for (RasterDataNode raster : rasterDataNodes) {
                ImageInfo imageInfo = raster.getImageInfo();
                if (imageInfo != null) continue;
                raster.getImageInfo(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            }
        }
        finally {
            pm.done();
        }
    }

    public int getStatisticsLevel(RasterDataNode raster, int levelCount) {
        long imageSize = (long)raster.getRasterWidth() * (long)raster.getRasterHeight();
        int statisticsLevel = imageSize <= 65536L ? 0 : levelCount - 1;
        return statisticsLevel;
    }

    public PlanarImage createColoredMaskImage(Product product, String expression, Color color, boolean invertMask, int level) {
        MultiLevelImage maskImage = product.getMaskImage(expression, null);
        RenderedImage levelImage = maskImage.getImage(level);
        return ImageManager.createColoredMaskImage(color, levelImage, invertMask);
    }

    private static class Holder {
        private static final ImageManager instance = new ImageManager();

        private Holder() {
        }
    }

    private static class BorderSamplesAndColors {
        double sample1;
        double sample2;
        Color color1;
        Color color2;

        private BorderSamplesAndColors() {
        }
    }
}

