/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.ColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import javax.media.jai.ImageLayout;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.StreamDescriptor;
import org.esa.snap.core.util.ImageUtils;

public class ImageHeader {
    private final ImageLayout imageLayout;
    private final String tileFormat;

    public ImageHeader(RenderedImage image, String tileFormat) {
        this(new ImageLayout(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight(), image.getTileGridXOffset(), image.getTileGridYOffset(), image.getTileWidth(), image.getTileHeight(), image.getSampleModel(), image.getColorModel()), tileFormat);
    }

    public ImageHeader(ImageLayout imageLayout, String tileFormat) {
        this.imageLayout = imageLayout;
        this.tileFormat = tileFormat;
    }

    public static ImageHeader load(Path imageDir, Properties defaultImageProperties) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(imageDir.resolve("image.properties"));){
            ImageHeader imageHeader = ImageHeader.load(reader, defaultImageProperties, imageDir);
            return imageHeader;
        }
    }

    public static ImageHeader load(Reader reader, Properties defaultImageProperties, Path imageDir) throws IOException {
        Properties imageProperties = new Properties(defaultImageProperties);
        imageProperties.load(reader);
        return ImageHeader.load(imageProperties, imageDir);
    }

    public static ImageHeader load(Properties imageProperties, Path imageDir) throws IOException {
        ColorModel colorModel;
        SampleModel sampleModel;
        int dataType = Integer.parseInt(imageProperties.getProperty("dataType"));
        int minX = Integer.parseInt(imageProperties.getProperty("minX", "0"));
        int minY = Integer.parseInt(imageProperties.getProperty("minY", "0"));
        int width = Integer.parseInt(imageProperties.getProperty("width"));
        int height = Integer.parseInt(imageProperties.getProperty("height"));
        int tileGridXOffset = Integer.parseInt(imageProperties.getProperty("tileGridXOffset", "0"));
        int tileGridYOffset = Integer.parseInt(imageProperties.getProperty("tileGridYOffset", "0"));
        int tileWidth = Integer.parseInt(imageProperties.getProperty("tileWidth"));
        int tileHeight = Integer.parseInt(imageProperties.getProperty("tileHeight"));
        int numberOfBits = Integer.parseInt(imageProperties.getProperty("numberOfBits", "0"));
        String tileFormat = imageProperties.getProperty("tileFormat", "raw.zip");
        if (tileFormat.startsWith("raw")) {
            sampleModel = numberOfBits == 1 || numberOfBits == 2 || numberOfBits == 4 ? new MultiPixelPackedSampleModel(dataType, tileWidth, tileHeight, numberOfBits) : ImageUtils.createSingleBandedSampleModel(dataType, tileWidth, tileHeight);
            colorModel = null;
        } else {
            Path path = imageDir.resolve("0-0." + tileFormat);
            SeekableStream inputStream = SeekableStream.wrapInputStream((InputStream)Files.newInputStream(path, new OpenOption[0]), (boolean)true);
            RenderedOp tile00 = StreamDescriptor.create((SeekableStream)inputStream, null, null);
            sampleModel = tile00.getSampleModel().createCompatibleSampleModel(tileWidth, tileHeight);
            colorModel = tile00.getColorModel();
        }
        ImageLayout imageLayout = new ImageLayout(minX, minY, width, height, tileGridXOffset, tileGridYOffset, tileWidth, tileHeight, sampleModel, colorModel);
        return new ImageHeader(imageLayout, tileFormat);
    }

    public ImageLayout getImageLayout() {
        return this.imageLayout;
    }

    public String getTileFormat() {
        return this.tileFormat;
    }

    public void store(Writer writer, Properties defaultProperties) throws IOException {
        Properties properties = this.getAsProperties(defaultProperties);
        properties.store(writer, "SNAP tiled image header");
    }

    public Properties getAsProperties(Properties defaultProperties) {
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("dataType", "" + this.imageLayout.getSampleModel(null).getDataType());
        properties.setProperty("minX", "" + this.imageLayout.getMinX(null));
        properties.setProperty("minY", "" + this.imageLayout.getMinY(null));
        properties.setProperty("width", "" + this.imageLayout.getWidth(null));
        properties.setProperty("height", "" + this.imageLayout.getHeight(null));
        properties.setProperty("tileGridXOffset", "" + this.imageLayout.getTileGridXOffset(null));
        properties.setProperty("tileGridYOffset", "" + this.imageLayout.getTileGridYOffset(null));
        properties.setProperty("tileWidth", "" + this.imageLayout.getTileWidth(null));
        properties.setProperty("tileHeight", "" + this.imageLayout.getTileHeight(null));
        properties.setProperty("tileFormat", this.tileFormat);
        return properties;
    }
}

