/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import org.esa.snap.core.image.DataBufferUtils;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;

public final class FillConstantOpImage
extends PointOpImage {
    private final Number fillValue;
    private final RasterFormatTag maskFormatTag;
    private final RasterFormatTag[] srcDestFormatTags;

    public FillConstantOpImage(RenderedImage sourceImage, RenderedImage maskImage, Number fillValue) {
        super(sourceImage, maskImage, FillConstantOpImage.createImageLayout(sourceImage, fillValue), null, true);
        this.fillValue = fillValue;
        int compatibleTagId = RasterAccessor.findCompatibleTag(null, (SampleModel)maskImage.getSampleModel());
        this.maskFormatTag = new RasterFormatTag(maskImage.getSampleModel(), compatibleTagId);
        this.srcDestFormatTags = RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{sourceImage}, (RenderedImage)((Object)this));
    }

    private static ImageLayout createImageLayout(RenderedImage sourceImage, Number fillValue) {
        int targetDataType = Math.max(sourceImage.getSampleModel().getDataType(), DataBufferUtils.getDataBufferType(fillValue));
        SingleBandedSampleModel sampleModel = new SingleBandedSampleModel(targetDataType, sourceImage.getTileWidth(), sourceImage.getTileHeight());
        return new ImageLayout(sourceImage).setSampleModel((SampleModel)((Object)sampleModel));
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterAccessor s = new RasterAccessor(sources[0], destRect, this.srcDestFormatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor m = new RasterAccessor(sources[1], destRect, this.maskFormatTag, this.getSourceImage(1).getColorModel());
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, this.srcDestFormatTags[1], this.getColorModel());
        switch (d.getDataType()) {
            case 0: {
                this.computeRectByte(s, m, d, this.fillValue.byteValue());
                break;
            }
            case 1: 
            case 2: {
                this.computeRectShort(s, m, d, this.fillValue.shortValue());
                break;
            }
            case 3: {
                this.computeRectInt(s, m, d, this.fillValue.intValue());
                break;
            }
            case 4: {
                this.computeRectFloat(s, m, d, this.fillValue.floatValue());
                break;
            }
            case 5: {
                this.computeRectDouble(s, m, d, this.fillValue.doubleValue());
            }
        }
        d.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor mask, RasterAccessor dst, byte rValue) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        byte[][] sData = src.getByteDataArrays();
        int mLineStride = mask.getScanlineStride();
        int mPixelStride = mask.getPixelStride();
        int[] mBandOffsets = mask.getBandOffsets();
        byte[][] mData = mask.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        byte[] s = sData[0];
        byte[] m = mData[0];
        byte[] d = dData[0];
        int sLineOffset = sBandOffsets[0];
        int mLineOffset = mBandOffsets[0];
        int dLineOffset = dBandOffsets[0];
        for (int h = 0; h < dheight; ++h) {
            int sPixelOffset = sLineOffset;
            int mPixelOffset = mLineOffset;
            int dPixelOffset = dLineOffset;
            sLineOffset += sLineStride;
            mLineOffset += mLineStride;
            dLineOffset += dLineStride;
            for (int w = 0; w < dwidth; ++w) {
                d[dPixelOffset] = m[mPixelOffset] != 0 ? s[sPixelOffset] : rValue;
                sPixelOffset += sPixelStride;
                mPixelOffset += mPixelStride;
                dPixelOffset += dPixelStride;
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor mask, RasterAccessor dst, short rValue) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        short[][] sData = src.getShortDataArrays();
        int mLineStride = mask.getScanlineStride();
        int mPixelStride = mask.getPixelStride();
        int[] mBandOffsets = mask.getBandOffsets();
        byte[][] mData = mask.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        short[] s = sData[0];
        byte[] m = mData[0];
        short[] d = dData[0];
        int sLineOffset = sBandOffsets[0];
        int mLineOffset = mBandOffsets[0];
        int dLineOffset = dBandOffsets[0];
        for (int h = 0; h < dheight; ++h) {
            int sPixelOffset = sLineOffset;
            int mPixelOffset = mLineOffset;
            int dPixelOffset = dLineOffset;
            sLineOffset += sLineStride;
            mLineOffset += mLineStride;
            dLineOffset += dLineStride;
            for (int w = 0; w < dwidth; ++w) {
                d[dPixelOffset] = m[mPixelOffset] != 0 ? s[sPixelOffset] : rValue;
                sPixelOffset += sPixelStride;
                mPixelOffset += mPixelStride;
                dPixelOffset += dPixelStride;
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor mask, RasterAccessor dst, int rValue) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        int[][] sData = src.getIntDataArrays();
        int mLineStride = mask.getScanlineStride();
        int mPixelStride = mask.getPixelStride();
        int[] mBandOffsets = mask.getBandOffsets();
        byte[][] mData = mask.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        int[] s = sData[0];
        byte[] m = mData[0];
        int[] d = dData[0];
        int sLineOffset = sBandOffsets[0];
        int mLineOffset = mBandOffsets[0];
        int dLineOffset = dBandOffsets[0];
        for (int h = 0; h < dheight; ++h) {
            int sPixelOffset = sLineOffset;
            int mPixelOffset = mLineOffset;
            int dPixelOffset = dLineOffset;
            sLineOffset += sLineStride;
            mLineOffset += mLineStride;
            dLineOffset += dLineStride;
            for (int w = 0; w < dwidth; ++w) {
                d[dPixelOffset] = m[mPixelOffset] != 0 ? s[sPixelOffset] : rValue;
                sPixelOffset += sPixelStride;
                mPixelOffset += mPixelStride;
                dPixelOffset += dPixelStride;
            }
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor mask, RasterAccessor dst, float rValue) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        float[][] sData = src.getFloatDataArrays();
        int mLineStride = mask.getScanlineStride();
        int mPixelStride = mask.getPixelStride();
        int[] mBandOffsets = mask.getBandOffsets();
        byte[][] mData = mask.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        float[] s = sData[0];
        byte[] m = mData[0];
        float[] d = dData[0];
        int sLineOffset = sBandOffsets[0];
        int mLineOffset = mBandOffsets[0];
        int dLineOffset = dBandOffsets[0];
        for (int h = 0; h < dheight; ++h) {
            int sPixelOffset = sLineOffset;
            int mPixelOffset = mLineOffset;
            int dPixelOffset = dLineOffset;
            sLineOffset += sLineStride;
            mLineOffset += mLineStride;
            dLineOffset += dLineStride;
            for (int w = 0; w < dwidth; ++w) {
                d[dPixelOffset] = m[mPixelOffset] != 0 ? s[sPixelOffset] : rValue;
                sPixelOffset += sPixelStride;
                mPixelOffset += mPixelStride;
                dPixelOffset += dPixelStride;
            }
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor mask, RasterAccessor dst, double rValue) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        double[][] sData = src.getDoubleDataArrays();
        int mLineStride = mask.getScanlineStride();
        int mPixelStride = mask.getPixelStride();
        int[] mBandOffsets = mask.getBandOffsets();
        byte[][] mData = mask.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        double[] s = sData[0];
        byte[] m = mData[0];
        double[] d = dData[0];
        int sLineOffset = sBandOffsets[0];
        int mLineOffset = mBandOffsets[0];
        int dLineOffset = dBandOffsets[0];
        for (int h = 0; h < dheight; ++h) {
            int sPixelOffset = sLineOffset;
            int mPixelOffset = mLineOffset;
            int dPixelOffset = dLineOffset;
            sLineOffset += sLineStride;
            mLineOffset += mLineStride;
            dLineOffset += dLineStride;
            for (int w = 0; w < dwidth; ++w) {
                d[dPixelOffset] = m[mPixelOffset] != 0 ? s[sPixelOffset] : rValue;
                sPixelOffset += sPixelStride;
                mPixelOffset += mPixelStride;
                dPixelOffset += dPixelStride;
            }
        }
    }
}

