/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.CachedTile;
import javax.media.jai.TileCache;

public class FileTileCache
implements TileCache {
    private final File cacheDir;
    private long memoryCapacity;
    private long memoryInUse;
    private float memoryThreshold;
    private Comparator<Object> tileComparator;
    private Map<TileId, CachedTileImpl> tileMap;
    private Map<RenderedImage, String> idMap;

    public FileTileCache(File cacheDir) {
        this.cacheDir = cacheDir;
        this.tileMap = new HashMap<TileId, CachedTileImpl>(1024);
        this.idMap = new WeakHashMap<RenderedImage, String>(128);
        this.memoryCapacity = 0x6400000L;
        this.memoryThreshold = 0.75f;
    }

    public void add(RenderedImage owner, int tileX, int tileY, Raster tile) {
        this.add(owner, tileX, tileY, tile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RenderedImage owner, int tileX, int tileY, Raster tile, Object tileCacheMetric) {
        TileId tileId = this.createTileId(owner, tileX, tileY);
        FileTileCache fileTileCache = this;
        synchronized (fileTileCache) {
            CachedTileImpl cachedTile = this.tileMap.get(tileId);
            try {
                if (cachedTile != null) {
                    FileTileCache.writeTile(cachedTile.file, tile);
                    cachedTile.tileTimeStamp = System.currentTimeMillis();
                } else {
                    cachedTile = new CachedTileImpl(tileId, tile, tileCacheMetric);
                    if ((float)(this.memoryInUse + cachedTile.tileSize) > this.memoryThreshold) {
                        this.memoryControl();
                    }
                    if ((float)(this.memoryInUse + cachedTile.tileSize) <= this.memoryThreshold) {
                        FileTileCache.writeTile(cachedTile.file, tile);
                        this.tileMap.put(tileId, cachedTile);
                        this.memoryInUse += cachedTile.tileSize;
                    }
                }
            }
            catch (IOException e) {
                cachedTile.file.delete();
            }
        }
    }

    public void addTiles(RenderedImage owner, Point[] tileIndices, Raster[] tiles, Object tileCacheMetric) {
        for (int i = 0; i < tileIndices.length; ++i) {
            Point tileIndex = tileIndices[i];
            this.add(owner, tileIndex.x, tileIndex.y, tiles[i], tileCacheMetric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster getTile(RenderedImage owner, int tileX, int tileY) {
        TileId tileId = this.createTileId(owner, tileX, tileY);
        Raster tile = null;
        FileTileCache fileTileCache = this;
        synchronized (fileTileCache) {
            CachedTileImpl cachedTile = this.tileMap.get(tileId);
            if (cachedTile != null) {
                try {
                    DataBuffer dataBuffer = FileTileCache.readTileData(cachedTile.file, cachedTile.sampleModel);
                    tile = cachedTile.writable ? Raster.createWritableRaster(cachedTile.sampleModel, dataBuffer, cachedTile.location) : Raster.createRaster(cachedTile.sampleModel, dataBuffer, cachedTile.location);
                    cachedTile.tileTimeStamp = System.currentTimeMillis();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return tile;
    }

    public Raster[] getTiles(RenderedImage owner) {
        return this.getTiles(owner, FileTileCache.getTileIndices(owner));
    }

    public Raster[] getTiles(RenderedImage owner, Point[] tileIndices) {
        Raster[] tiles = new Raster[tileIndices.length];
        for (int i = 0; i < tiles.length; ++i) {
            Point tileIndex = tileIndices[i];
            tiles[i] = this.getTile(owner, tileIndex.x, tileIndex.y);
        }
        return tiles;
    }

    public void removeTiles(RenderedImage owner) {
        Point[] tileIndices;
        for (Point tileIndex : tileIndices = FileTileCache.getTileIndices(owner)) {
            this.remove(owner, tileIndex.x, tileIndex.y);
        }
    }

    public void remove(RenderedImage owner, int tileX, int tileY) {
        this.removeTile(this.createTileId(owner, tileX, tileY));
    }

    private synchronized TileId createTileId(RenderedImage owner, int tileX, int tileY) {
        return new TileId(owner, tileX, tileY);
    }

    public synchronized void flush() {
        TileId[] tileIds;
        for (TileId tileId : tileIds = this.tileMap.keySet().toArray(new TileId[this.tileMap.size()])) {
            this.removeTile(tileId);
        }
        this.tileMap.clear();
        this.idMap.clear();
    }

    public synchronized void memoryControl() {
        CachedTileImpl[] tiles = this.tileMap.values().toArray(new CachedTileImpl[this.tileMap.size()]);
        Arrays.sort(tiles, this.createTileComparator());
        for (CachedTileImpl tile : tiles) {
            if ((float)this.memoryInUse <= this.memoryThreshold * (float)this.memoryCapacity) break;
            this.removeTile(tile.tileId);
        }
    }

    @Deprecated
    public synchronized int getTileCapacity() {
        return 0;
    }

    @Deprecated
    public synchronized void setTileCapacity(int tileCapacity) {
    }

    public synchronized void setMemoryCapacity(long memoryCapacity) {
        long oldCapacity = this.memoryCapacity;
        this.memoryCapacity = memoryCapacity;
        if (this.memoryCapacity < oldCapacity) {
            this.memoryControl();
        }
    }

    public synchronized long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public synchronized void setMemoryThreshold(float memoryThreshold) {
        float oldThreshold = this.memoryThreshold;
        this.memoryThreshold = memoryThreshold;
        if (this.memoryThreshold < oldThreshold) {
            this.memoryControl();
        }
    }

    public synchronized float getMemoryThreshold() {
        return this.memoryCapacity;
    }

    public synchronized Comparator getTileComparator() {
        return this.tileComparator;
    }

    public synchronized void setTileComparator(Comparator comparator) {
        this.tileComparator = comparator;
    }

    private synchronized void removeTile(TileId tileId) {
        CachedTileImpl cachedTile = this.tileMap.get(tileId);
        if (cachedTile != null) {
            cachedTile.file.delete();
        }
        this.tileMap.remove(tileId);
        RenderedImage image = (RenderedImage)tileId.owner.get();
        if (image != null) {
            this.idMap.remove(image);
        }
    }

    static Point[] getTileIndices(RenderedImage owner) {
        int numXTiles = owner.getNumXTiles();
        int numYTiles = owner.getNumYTiles();
        Point[] tileIndices = new Point[numXTiles * numYTiles];
        int i = 0;
        for (int y = 0; y < numYTiles; ++y) {
            for (int x = 0; x < numXTiles; ++x) {
                tileIndices[i++] = new Point(x, y);
            }
        }
        return tileIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getImageId(RenderedImage owner) {
        String id = this.idMap.get(owner);
        if (id == null) {
            FileTileCache fileTileCache = this;
            synchronized (fileTileCache) {
                if (id == null) {
                    id = FileTileCache.createImageId(owner, this.idMap.size());
                    this.idMap.put(owner, id);
                }
            }
        }
        return id;
    }

    static String createImageId(RenderedImage owner, int index) {
        return owner.getClass().getSimpleName() + "-" + Long.toHexString(System.nanoTime()) + "-" + Integer.toHexString(index) + "-" + Integer.toHexString(owner.hashCode());
    }

    final Comparator<CachedTileImpl> createTileComparator() {
        return this.tileComparator != null ? new TileCacheMetricComparator(this.tileComparator) : new DefaultTileComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataBuffer readTileData(File file, SampleModel sampleModel) throws IOException {
        try (FileImageInputStream stream = new FileImageInputStream(file);){
            DataBuffer dataBuffer = FileTileCache.readTile(stream, sampleModel);
            return dataBuffer;
        }
    }

    static void writeTile(File file, Raster tile) throws IOException {
        try (FileImageOutputStream stream = new FileImageOutputStream(file);){
            FileTileCache.writeTile(stream, tile);
        }
    }

    static DataBuffer readTile(ImageInputStream stream, SampleModel sampleModel) throws IOException {
        int numDataElements = sampleModel.getNumDataElements();
        int dataType = sampleModel.getDataType();
        if (dataType == 0) {
            byte[] data = new byte[numDataElements];
            stream.readFully(data, 0, data.length);
            return new DataBufferByte(data, data.length);
        }
        if (dataType == 2 || dataType == 1) {
            short[] data = new short[numDataElements];
            stream.readFully(data, 0, data.length);
            return new DataBufferShort(data, data.length);
        }
        if (dataType == 3) {
            int[] data = new int[numDataElements];
            stream.readFully(data, 0, data.length);
            return new DataBufferInt(data, data.length);
        }
        if (dataType == 4) {
            float[] data = new float[numDataElements];
            stream.readFully(data, 0, data.length);
            return new DataBufferFloat(data, data.length);
        }
        if (dataType == 5) {
            double[] data = new double[numDataElements];
            stream.readFully(data, 0, data.length);
            return new DataBufferDouble(data, data.length);
        }
        throw new IllegalStateException();
    }

    static void writeTile(ImageOutputStream stream, Raster tile) throws IOException {
        if (tile.getSampleModel().getNumDataElements() != tile.getDataBuffer().getSize()) {
            throw new IllegalStateException();
        }
        DataBuffer dataBuffer = tile.getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            byte[] data = ((DataBufferByte)dataBuffer).getData();
            stream.write(data, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (dataBuffer instanceof DataBufferShort) {
            short[] data = ((DataBufferShort)dataBuffer).getData();
            stream.writeShorts(data, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (dataBuffer instanceof DataBufferInt) {
            int[] data = ((DataBufferInt)dataBuffer).getData();
            stream.writeInts(data, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (dataBuffer instanceof DataBufferFloat) {
            float[] data = ((DataBufferFloat)dataBuffer).getData();
            stream.writeFloats(data, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (dataBuffer instanceof DataBufferDouble) {
            double[] data = ((DataBufferDouble)dataBuffer).getData();
            stream.writeDoubles(data, dataBuffer.getOffset(), dataBuffer.getSize());
        } else {
            throw new IllegalStateException();
        }
    }

    private static int getHashCode(RenderedImage owner, int tileX, int tileY) {
        int result = owner.hashCode();
        result = 31 * result + tileY * owner.getNumXTiles() + tileX;
        return result;
    }

    final class CachedTileImpl
    implements CachedTile {
        final TileId tileId;
        final File file;
        final Object tileCacheMetric;
        final SampleModel sampleModel;
        final long tileSize;
        final Point location;
        final boolean writable;
        long tileTimeStamp;

        CachedTileImpl(TileId tileId, Raster tile, Object tileCacheMetric) {
            this.tileId = tileId;
            this.file = new File(FileTileCache.this.cacheDir, FileTileCache.this.getImageId((RenderedImage)tileId.owner.get()) + "-" + tileId.tileX + "-" + tileId.tileY);
            this.tileCacheMetric = tileCacheMetric;
            this.sampleModel = tile.getSampleModel();
            this.tileSize = this.sampleModel.getNumDataElements() * DataBuffer.getDataTypeSize(this.sampleModel.getTransferType());
            this.location = tile.getBounds().getLocation();
            this.writable = tile instanceof WritableRaster;
            this.tileTimeStamp = System.currentTimeMillis();
        }

        public RenderedImage getOwner() {
            return (RenderedImage)this.tileId.owner.get();
        }

        public Raster getTile() {
            return null;
        }

        public Object getTileCacheMetric() {
            return this.tileCacheMetric;
        }

        public long getTileTimeStamp() {
            return this.tileTimeStamp;
        }

        public long getTileSize() {
            return this.tileSize;
        }

        public int getAction() {
            return 0;
        }
    }

    final class TileId {
        final WeakReference<RenderedImage> owner;
        final int tileX;
        final int tileY;
        final int hash;

        TileId(RenderedImage owner, int tileX, int tileY) {
            this.owner = new WeakReference<RenderedImage>(owner);
            this.tileX = tileX;
            this.tileY = tileY;
            this.hash = FileTileCache.getHashCode(owner, tileX, tileY);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TileId tileId = (TileId)other;
            return this.owner.get() == tileId.owner.get() && this.hash == tileId.hash && this.tileX == tileId.tileX && this.tileY == tileId.tileY;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static final class DefaultTileComparator
    implements Comparator<CachedTileImpl> {
        DefaultTileComparator() {
        }

        @Override
        public int compare(CachedTileImpl o1, CachedTileImpl o2) {
            return (int)(o1.tileTimeStamp - o2.tileTimeStamp);
        }
    }

    static final class TileCacheMetricComparator
    implements Comparator<CachedTileImpl> {
        private Comparator<Object> tileComparator;

        TileCacheMetricComparator(Comparator<Object> tileComparator) {
            this.tileComparator = tileComparator;
        }

        @Override
        public int compare(CachedTileImpl o1, CachedTileImpl o2) {
            return this.tileComparator.compare(o1.tileCacheMetric, o2.tileCacheMetric);
        }
    }
}

