/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;

public class ColoredBandImageMultiLevelSource
extends AbstractMultiLevelSource {
    private final RasterDataNode[] rasterDataNodes;
    private ImageInfo imageInfo;

    public static ColoredBandImageMultiLevelSource create(RasterDataNode rasterDataNode, ProgressMonitor pm) {
        return ColoredBandImageMultiLevelSource.create(new RasterDataNode[]{rasterDataNode}, pm);
    }

    public static ColoredBandImageMultiLevelSource create(RasterDataNode[] rasterDataNodes, ProgressMonitor pm) {
        RasterDataNode rdn = rasterDataNodes[0];
        MultiLevelModel model = rdn.getMultiLevelModel();
        return ColoredBandImageMultiLevelSource.create(rasterDataNodes, model, pm);
    }

    public static ColoredBandImageMultiLevelSource create(RasterDataNode[] rasterDataNodes, MultiLevelModel model, ProgressMonitor pm) {
        ImageManager.getInstance().prepareImageInfos(rasterDataNodes, pm);
        return new ColoredBandImageMultiLevelSource(model, rasterDataNodes);
    }

    private ColoredBandImageMultiLevelSource(MultiLevelModel model, RasterDataNode[] rasterDataNodes) {
        super(model);
        this.rasterDataNodes = (RasterDataNode[])rasterDataNodes.clone();
        this.imageInfo = ImageManager.getInstance().getImageInfo(rasterDataNodes);
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public Shape getImageShape(int level) {
        return this.rasterDataNodes[0].getSourceImage().getImageShape(level);
    }

    public RenderedImage createImage(int level) {
        return ImageManager.getInstance().createColoredBandImage(this.rasterDataNodes, this.imageInfo, level);
    }
}

