/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.resamp;

import org.esa.snap.core.dataop.resamp.Resampling;

public final class BilinearInterpolationResampling
implements Resampling {
    @Override
    public String getName() {
        return "BILINEAR_INTERPOLATION";
    }

    @Override
    public final Resampling.Index createIndex() {
        return new Resampling.Index(2, 1);
    }

    @Override
    public final void computeIndex(double x, double y, int width, int height, Resampling.Index index) {
        int i1;
        index.x = x;
        index.y = y;
        index.width = width;
        index.height = height;
        int i0 = (int)Math.floor(x);
        int j0 = (int)Math.floor(y);
        double di = x - ((double)i0 + 0.5);
        double dj = y - ((double)j0 + 0.5);
        index.i0 = i0;
        index.j0 = j0;
        int iMax = width - 1;
        if (di >= 0.0) {
            i1 = i0 + 1;
            index.i[0] = i0 < 0 ? 0.0 : (i0 > iMax ? (double)iMax : (double)i0);
            index.i[1] = i1 < 0 ? 0.0 : (i1 > iMax ? (double)iMax : (double)i1);
            index.ki[0] = di;
        } else {
            i1 = i0 - 1;
            index.i[0] = i1 < 0 ? 0.0 : (i1 > iMax ? (double)iMax : (double)i1);
            index.i[1] = i0 < 0 ? 0.0 : (i0 > iMax ? (double)iMax : (double)i0);
            index.ki[0] = di + 1.0;
        }
        int jMax = height - 1;
        if (dj >= 0.0) {
            int j1 = j0 + 1;
            index.j[0] = j0 < 0 ? 0.0 : (j0 > jMax ? (double)jMax : (double)j0);
            index.j[1] = j1 < 0 ? 0.0 : (j1 > jMax ? (double)jMax : (double)j1);
            index.kj[0] = dj;
        } else {
            int j1 = j0 - 1;
            index.j[0] = j1 < 0 ? 0.0 : (j1 > jMax ? (double)jMax : (double)j1);
            index.j[1] = j0 < 0 ? 0.0 : (j0 > jMax ? (double)jMax : (double)j0);
            index.kj[0] = dj + 1.0;
        }
    }

    @Override
    public final double resample(Resampling.Raster raster, Resampling.Index index) throws Exception {
        int[] x = new int[]{(int)index.i[0], (int)index.i[1]};
        int[] y = new int[]{(int)index.j[0], (int)index.j[1]};
        double[][] samples = new double[2][2];
        if (!raster.getSamples(x, y, samples)) {
            return samples[0][0];
        }
        double ki = index.ki[0];
        double kj = index.kj[0];
        return samples[0][0] * (1.0 - ki) * (1.0 - kj) + samples[0][1] * ki * (1.0 - kj) + samples[1][0] * (1.0 - ki) * kj + samples[1][1] * ki * kj;
    }

    public String toString() {
        return "Bilinear interpolation resampling";
    }
}

