/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.resamp;

import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.dataop.resamp.BiCubicInterpolationResampling;
import org.esa.snap.core.dataop.resamp.Resampling;

class BiSincInterpolationResampling
implements Resampling {
    private static final double PI = Math.PI;
    private static final double DoublePI = Math.PI * 2;
    private final double kernelSizefraction;
    private final int kernelSize;
    private final int kernelSize1;
    private final int halfKernelSize;

    public BiSincInterpolationResampling(int kernelSize) {
        this.kernelSize = kernelSize;
        this.kernelSize1 = kernelSize - 1;
        this.halfKernelSize = kernelSize / 2;
        this.kernelSizefraction = Math.PI * 2 / (double)this.kernelSize1;
    }

    @Override
    public String getName() {
        return "BISINC_INTERPOLATION";
    }

    @Override
    public final Resampling.Index createIndex() {
        return new Resampling.Index(this.kernelSize, 1);
    }

    @Override
    public final void computeIndex(double x, double y, int width, int height, Resampling.Index index) {
        int j;
        int v;
        int i;
        index.x = x;
        index.y = y;
        index.width = width;
        index.height = height;
        int i0 = (int)Math.floor(x);
        int j0 = (int)Math.floor(y);
        double di = x - ((double)i0 + 0.5);
        double dj = y - ((double)j0 + 0.5);
        index.i0 = i0;
        index.j0 = j0;
        int iMax = width - 1;
        int jMax = height - 1;
        int size = this.kernelSize;
        int minI = i0 - this.halfKernelSize;
        int minJ = j0 - this.halfKernelSize;
        if (di >= 0.0) {
            for (i = 0; i < size; ++i) {
                v = minI + i;
                index.i[i] = Math.min(v >= 0 ? v : 0, iMax);
            }
            index.ki[0] = di;
        } else {
            for (i = 0; i < size; ++i) {
                v = minI - 1 + i;
                index.i[i] = Math.min(v >= 0 ? v : 0, iMax);
            }
            index.ki[0] = di + 1.0;
        }
        if (dj >= 0.0) {
            for (j = 0; j < size; ++j) {
                v = minJ + j;
                index.j[j] = Math.min(v >= 0 ? v : 0, jMax);
            }
            index.kj[0] = dj;
        } else {
            for (j = 0; j < size; ++j) {
                v = minJ - 1 + j;
                index.j[j] = Math.min(v >= 0 ? v : 0, jMax);
            }
            index.kj[0] = dj + 1.0;
        }
    }

    @Override
    public final double resample(Resampling.Raster raster, Resampling.Index index) throws Exception {
        double xxPI;
        double xx;
        int size = this.kernelSize;
        int halfSize = this.halfKernelSize;
        int nhalfSize = -halfSize;
        double kernelSizefract = this.kernelSizefraction;
        int[] x = new int[size];
        int[] y = new int[size];
        double[][] samples = new double[size][size];
        double[] winX = new double[size];
        double cx = index.ki[0] + (double)halfSize;
        double sumX = 0.0;
        for (int n = 0; n < size; ++n) {
            x[n] = (int)index.i[n];
            y[n] = (int)index.j[n];
            xx = cx - (double)n;
            xxPI = xx * Math.PI;
            winX[n] = xx >= (double)nhalfSize && xx <= (double)halfSize ? (xx == 0.0 ? 1.0 : FastMath.sin((double)xxPI) / xxPI * (0.5 * (1.0 + FastMath.cos((double)(kernelSizefract * xx))))) : 0.0;
            sumX += winX[n];
        }
        if (!raster.getSamples(x, y, samples)) {
            if (Double.isNaN(samples[halfSize][halfSize])) {
                return samples[halfSize][halfSize];
            }
            BiCubicInterpolationResampling.replaceNaNWithMean(samples);
        }
        double cy = index.kj[0] + (double)halfSize;
        double sumY = 0.0;
        double v = 0.0;
        for (int j = 0; j < size; ++j) {
            xx = cy - (double)j;
            xxPI = xx * Math.PI;
            double winY = xx >= (double)nhalfSize && xx <= (double)halfSize ? (xx == 0.0 ? 1.0 : FastMath.sin((double)xxPI) / xxPI * (0.5 * (1.0 + FastMath.cos((double)(kernelSizefract * xx))))) : 0.0;
            sumY += winY;
            for (int i = 0; i < size; ++i) {
                v += samples[j][i] * winX[i] * winY;
            }
        }
        return v /= sumX * sumY;
    }

    private double sincHanning(double x) {
        return x >= (double)(-this.halfKernelSize) && x <= (double)this.halfKernelSize ? (x == 0.0 ? 1.0 : FastMath.sin((double)(x * Math.PI)) / (x * Math.PI) * (0.5 * (1.0 + FastMath.cos((double)(this.kernelSizefraction * x))))) : 0.0;
    }

    @Override
    public int getKernelSize() {
        return this.kernelSize;
    }

    public String toString() {
        return "BiSinc interpolation resampling";
    }
}

