/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.maptransf.geotools;

import java.awt.geom.AffineTransform;
import org.esa.snap.core.dataop.maptransf.AffineTransformDescriptor;
import org.esa.snap.core.dataop.maptransf.AlbersEqualAreaConicDescriptor;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.IdentityTransformDescriptor;
import org.esa.snap.core.dataop.maptransf.LambertConformalConicDescriptor;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.StereographicDescriptor;
import org.esa.snap.core.dataop.maptransf.TransverseMercatorDescriptor;
import org.esa.snap.core.dataop.maptransf.UTMProjection;
import org.esa.snap.core.dataop.maptransf.geotools.GeodeticDatums;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;

@Deprecated
public class CoordinateReferenceSystems {
    private static final GeographicCRS ITRF97 = new DefaultGeographicCRS(GeodeticDatums.ITRF97, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
    private static final GeographicCRS WGS72 = new DefaultGeographicCRS(GeodeticDatums.WGS72, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
    private static final GeographicCRS WGS84 = DefaultGeographicCRS.WGS84;

    public static CoordinateReferenceSystem getCRS(MapProjection projection, Datum datum) {
        GeographicCRS result = WGS84;
        try {
            MapTransform mapTransform = projection.getMapTransform();
            if (mapTransform.getDescriptor() instanceof IdentityTransformDescriptor) {
                if (Datum.ITRF_97.equals(datum)) {
                    result = ITRF97;
                } else if (Datum.WGS_72.equals(datum)) {
                    result = WGS72;
                }
            } else if (projection instanceof UTMProjection && !Datum.ITRF_97.equals(datum)) {
                UTMProjection utmProjection = (UTMProjection)projection;
                int zone = utmProjection.getZone();
                if (zone >= 1 && zone <= 60) {
                    CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", null);
                    if (utmProjection.isNorth()) {
                        if (Datum.WGS_72.equals(datum)) {
                            int WGS72_UTM_zone_N_BASE = 32200;
                            result = factory.createProjectedCRS("EPSG:" + (32200 + zone));
                        } else if (Datum.WGS_84.equals(datum)) {
                            int WGS84_UTM_zone_N_BASE = 32600;
                            result = factory.createProjectedCRS("EPSG:" + (32600 + zone));
                        }
                    } else if (Datum.WGS_72.equals(datum)) {
                        int WGS72_UTM_zone_S_BASE = 32300;
                        result = factory.createProjectedCRS("EPSG:" + (32300 + zone));
                    } else if (Datum.WGS_84.equals(datum)) {
                        int WGS84_UTM_zone_S_BASE = 32700;
                        result = factory.createProjectedCRS("EPSG:" + (32700 + zone));
                    }
                }
            } else if (Datum.ITRF_97.equals(datum)) {
                String crsName = "ITRF 97 / " + mapTransform.getDescriptor().getName();
                MathTransform mathTransform = CoordinateReferenceSystems.getMathTransform(mapTransform);
                if (mathTransform != null) {
                    result = new DefaultProjectedCRS(crsName, ITRF97, mathTransform, (CartesianCS)DefaultCartesianCS.PROJECTED);
                }
            } else if (Datum.WGS_72.equals(datum)) {
                String crsName = "WGS 72 / " + mapTransform.getDescriptor().getName();
                MathTransform mathTransform = CoordinateReferenceSystems.getMathTransform(mapTransform);
                if (mathTransform != null) {
                    result = new DefaultProjectedCRS(crsName, WGS72, mathTransform, (CartesianCS)DefaultCartesianCS.PROJECTED);
                }
            } else if (Datum.WGS_84.equals(datum)) {
                String crsName = "WGS 84 / " + mapTransform.getDescriptor().getName();
                MathTransform mathTransform = CoordinateReferenceSystems.getMathTransform(mapTransform);
                if (mathTransform != null) {
                    result = new DefaultProjectedCRS(crsName, WGS84, mathTransform, (CartesianCS)DefaultCartesianCS.PROJECTED);
                }
            }
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        return result;
    }

    private static MathTransform getMathTransform(MapTransform mapTransform) throws FactoryException {
        if (mapTransform.getDescriptor() instanceof AffineTransformDescriptor) {
            return new AffineTransform2D(new AffineTransform(mapTransform.getParameterValues()));
        }
        if (mapTransform instanceof AlbersEqualAreaConicDescriptor.AEAC) {
            return CoordinateReferenceSystems.createAlbersConicEqualAreaMathTransform((AlbersEqualAreaConicDescriptor.AEAC)mapTransform);
        }
        if (mapTransform instanceof LambertConformalConicDescriptor.LCCT) {
            return CoordinateReferenceSystems.createLambertConformalConicMathTransform((LambertConformalConicDescriptor.LCCT)mapTransform);
        }
        if (mapTransform instanceof StereographicDescriptor.ST) {
            return CoordinateReferenceSystems.createStereographicMathTransform((StereographicDescriptor.ST)mapTransform);
        }
        if (mapTransform instanceof TransverseMercatorDescriptor.TMT) {
            return CoordinateReferenceSystems.createTransverseMercatorMathTransform((TransverseMercatorDescriptor.TMT)mapTransform);
        }
        return null;
    }

    private static MathTransform createAlbersConicEqualAreaMathTransform(AlbersEqualAreaConicDescriptor.AEAC t) throws FactoryException {
        MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = transformFactory.getDefaultParameters("EPSG:9822");
        parameters.parameter("semi_major").setValue(t.getSemiMajor());
        parameters.parameter("semi_minor").setValue(t.getSemiMinor());
        parameters.parameter("central_meridian").setValue(t.getCentralMeridian());
        parameters.parameter("latitude_of_origin").setValue(t.getLatitudeOfOrigin());
        parameters.parameter("standard_parallel_1").setValue(t.getStandardParallel1());
        parameters.parameter("standard_parallel_2").setValue(t.getStandardParallel2());
        parameters.parameter("false_easting").setValue(t.getFalseEasting());
        parameters.parameter("false_northing").setValue(t.getFalseNorthing());
        return transformFactory.createParameterizedTransform(parameters);
    }

    private static MathTransform createLambertConformalConicMathTransform(LambertConformalConicDescriptor.LCCT t) throws FactoryException {
        MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = transformFactory.getDefaultParameters("ESRI:Lambert_Conformal_Conic");
        parameters.parameter("semi_major").setValue(t.getSemiMajor());
        parameters.parameter("semi_minor").setValue(t.getSemiMinor());
        parameters.parameter("central_meridian").setValue(t.getCentralMeridian());
        parameters.parameter("latitude_of_origin").setValue(t.getLatitudeOfOrigin());
        parameters.parameter("standard_parallel_1").setValue(t.getStandardParallel1());
        parameters.parameter("standard_parallel_2").setValue(t.getStandardParallel2());
        parameters.parameter("scale_factor").setValue(t.getScaleFactor());
        parameters.parameter("false_easting").setValue(t.getFalseEasting());
        parameters.parameter("false_northing").setValue(t.getFalseNorthing());
        return transformFactory.createParameterizedTransform(parameters);
    }

    private static MathTransform createStereographicMathTransform(StereographicDescriptor.ST t) throws FactoryException {
        MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = t.isPolar() ? transformFactory.getDefaultParameters("EPSG:9810") : transformFactory.getDefaultParameters("EPSG:9809");
        parameters.parameter("semi_major").setValue(t.getSemiMajor());
        parameters.parameter("semi_minor").setValue(t.getSemiMinor());
        parameters.parameter("central_meridian").setValue(t.getCentralMeridian());
        parameters.parameter("latitude_of_origin").setValue(t.getLatitudeOfOrigin());
        parameters.parameter("scale_factor").setValue(t.getScaleFactor());
        parameters.parameter("false_easting").setValue(t.getFalseEasting());
        parameters.parameter("false_northing").setValue(t.getFalseNorthing());
        return transformFactory.createParameterizedTransform(parameters);
    }

    private static MathTransform createTransverseMercatorMathTransform(TransverseMercatorDescriptor.TMT t) throws FactoryException {
        MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = transformFactory.getDefaultParameters("EPSG:9807");
        parameters.parameter("semi_major").setValue(t.getSemiMajor());
        parameters.parameter("semi_minor").setValue(t.getSemiMinor());
        parameters.parameter("central_meridian").setValue(t.getCentralMeridian());
        parameters.parameter("latitude_of_origin").setValue(t.getLatitudeOfOrigin());
        parameters.parameter("scale_factor").setValue(t.getScaleFactor());
        parameters.parameter("false_easting").setValue(t.getFalseEasting());
        parameters.parameter("false_northing").setValue(t.getFalseNorthing());
        return transformFactory.createParameterizedTransform(parameters);
    }
}

