/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.barithm;

import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.RasterDataEvalEnv;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.EvalException;

public final class SingleFlagSymbol
extends RasterDataSymbol {
    private final int flagMask;
    private final int flagValue;

    public SingleFlagSymbol(String symbolName, RasterDataNode raster, int flagMask) {
        this(symbolName, raster, flagMask, flagMask);
    }

    public SingleFlagSymbol(String symbolName, RasterDataNode raster, int flagMask, int flagValue) {
        super(symbolName, raster, RAW);
        this.flagMask = flagMask;
        this.flagValue = flagValue;
    }

    @Override
    public final int getRetType() {
        return 1;
    }

    public final int getFlagMask() {
        return this.flagMask;
    }

    public final int getFlagValue() {
        return this.flagValue;
    }

    @Override
    public final boolean evalB(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return (this.data.getElemIntAt(elemIndex) & this.flagMask) == this.flagValue;
    }

    @Override
    public final int evalI(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return (this.data.getElemIntAt(elemIndex) & this.flagMask) == this.flagValue ? 1 : 0;
    }

    @Override
    public final double evalD(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return (this.data.getElemIntAt(elemIndex) & this.flagMask) == this.flagValue ? 1.0 : 0.0;
    }

    @Override
    public SingleFlagSymbol clone() {
        return (SingleFlagSymbol)super.clone();
    }
}

