/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.barithm;

import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.RasterDataEvalEnv;
import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.EvalException;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;

public class RasterDataSymbol
implements Symbol,
Cloneable {
    public static final Source RAW = Source.RAW;
    public static final Source GEOPHYSICAL = Source.GEOPHYSICAL;
    private final String symbolName;
    private final int symbolType;
    private final RasterDataNode raster;
    private final Source source;
    protected ProductData data;

    public RasterDataSymbol(String symbolName, Mask mask) {
        this(symbolName, 1, mask, RAW);
    }

    public RasterDataSymbol(String symbolName, RasterDataNode raster, Source source) {
        this(symbolName, RasterDataSymbol.computeSymbolType(raster, source), raster, source);
    }

    private RasterDataSymbol(String symbolName, int symbolType, RasterDataNode raster, Source source) {
        this.symbolName = symbolName;
        this.symbolType = symbolType;
        this.raster = raster;
        this.source = source;
    }

    private static int computeSymbolType(RasterDataNode raster, Source source) {
        if (raster instanceof Mask) {
            return 1;
        }
        int dataType = raster.getDataType();
        boolean isFloatingPointType = ProductData.isFloatingPointType(dataType);
        boolean isScaled = raster.isScalingApplied();
        switch (source) {
            case RAW: {
                return isFloatingPointType ? 3 : 2;
            }
            case GEOPHYSICAL: {
                return isScaled || isFloatingPointType ? 3 : 2;
            }
        }
        throw new IllegalArgumentException("Source not supported: " + source);
    }

    @Override
    public String getName() {
        return this.symbolName;
    }

    @Override
    public int getRetType() {
        return this.symbolType;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    public Source getSource() {
        return this.source;
    }

    public RasterDataNode getRaster() {
        return this.raster;
    }

    public void setData(Object data) {
        if (ProductData.class.isAssignableFrom(data.getClass())) {
            this.data = (ProductData)data;
        } else if (data instanceof float[]) {
            this.data = ProductData.createInstance((float[])data);
        } else if (data instanceof int[]) {
            this.data = ProductData.createInstance((int[])data);
        } else {
            throw new IllegalArgumentException("illegal data type");
        }
    }

    @Override
    public boolean evalB(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return Term.toB(this.data.getElemDoubleAt(elemIndex));
    }

    @Override
    public int evalI(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return this.data.getElemIntAt(elemIndex);
    }

    @Override
    public double evalD(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return this.data.getElemDoubleAt(elemIndex);
    }

    @Override
    public String evalS(EvalEnv env) throws EvalException {
        double value = this.evalD(env);
        return Double.toString(value);
    }

    public RasterDataSymbol clone() {
        try {
            return (RasterDataSymbol)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum Source {
        RAW,
        GEOPHYSICAL;

    }
}

