/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.barithm;

import com.bc.ceres.core.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.ProductNamespaceExtenderImpl;
import org.esa.snap.core.dataop.barithm.ProductNamespacePrefixProvider;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.jexp.Function;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.WritableNamespace;
import org.esa.snap.core.jexp.impl.DefaultNamespace;
import org.esa.snap.core.jexp.impl.NamespaceImpl;
import org.esa.snap.core.jexp.impl.ParserImpl;
import org.esa.snap.core.jexp.impl.Tokenizer;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;

public class BandArithmetic {
    private static final WritableNamespace DEFAULT_NAMESPACE = new DefaultNamespace();

    private BandArithmetic() {
    }

    public static void registerSymbol(Symbol s) {
        DEFAULT_NAMESPACE.registerSymbol(s);
    }

    public static void deregisterSymbol(Symbol s) {
        DEFAULT_NAMESPACE.deregisterSymbol(s);
    }

    public static void registerFunction(Function f) {
        DEFAULT_NAMESPACE.registerFunction(f);
    }

    public static void deregisterFunction(Function f) {
        DEFAULT_NAMESPACE.deregisterFunction(f);
    }

    public static Term parseExpression(String expression, Product contextProduct) throws ParseException {
        return BandArithmetic.parseExpression(expression, new Product[]{contextProduct}, 0);
    }

    public static Term parseExpression(String expression, Product[] products, int contextProductIndex) throws ParseException {
        Assert.notNull((Object)expression, null);
        WritableNamespace namespace = BandArithmetic.createDefaultNamespace(products, contextProductIndex);
        ParserImpl parser = new ParserImpl(namespace, false);
        Term term = parser.parse(expression);
        if (!BandArithmetic.areRastersEqualInSize(term)) {
            throw new ParseException("Referenced rasters must be of same size");
        }
        return term;
    }

    public static WritableNamespace createDefaultNamespace(Product[] products, int contextProductIndex) {
        return BandArithmetic.createDefaultNamespace(products, contextProductIndex, BandArithmetic::getProductNodeNamePrefix);
    }

    public static WritableNamespace createDefaultNamespace(Product[] products, int contextProductIndex, ProductNamespacePrefixProvider ... prefixProviders) {
        Assert.argument((products.length > 0 ? 1 : 0) != 0, (String)"products.length > 0");
        Assert.argument((contextProductIndex >= 0 ? 1 : 0) != 0, (String)"contextProductIndex >= 0");
        Assert.argument((contextProductIndex < products.length ? 1 : 0) != 0, (String)"contextProductIndex < products.length");
        NamespaceImpl namespace = new NamespaceImpl(DEFAULT_NAMESPACE);
        ProductNamespaceExtenderImpl namespaceExtender = new ProductNamespaceExtenderImpl();
        namespaceExtender.extendNamespace(products[contextProductIndex], "", namespace);
        if (products.length > 1) {
            boolean allSet = Arrays.stream(products).allMatch(p -> p.getRefNo() != 0);
            if (!allSet) {
                int cnt = 1;
                Product[] productArray = products;
                int n = productArray.length;
                for (int i = 0; i < n; ++i) {
                    Product product = productArray[i];
                    product.resetRefNo();
                    product.setRefNo(cnt++);
                }
            }
            for (Product product : products) {
                for (ProductNamespacePrefixProvider prefixProvider : prefixProviders) {
                    namespaceExtender.extendNamespace(product, prefixProvider.getPrefix(product), namespace);
                }
            }
        }
        return namespace;
    }

    public static RasterDataNode[] getRefRasters(String expression, Product ... products) throws ParseException {
        return BandArithmetic.getRefRasters(expression, products, 0);
    }

    public static RasterDataNode[] getRefRasters(String expression, Product[] products, int contextProductIndex) throws ParseException {
        Term term = BandArithmetic.parseExpression(expression, products, contextProductIndex);
        return BandArithmetic.getRefRasters(term);
    }

    public static RasterDataNode[] getRefRasters(Term ... terms) {
        RasterDataSymbol[] symbols = BandArithmetic.getRefRasterDataSymbols(terms);
        return BandArithmetic.getRefRasters(symbols);
    }

    public static RasterDataSymbol[] getRefRasterDataSymbols(Term ... terms) {
        ArrayList<RasterDataSymbol> list = new ArrayList<RasterDataSymbol>();
        HashSet<RasterDataSymbol> set = new HashSet<RasterDataSymbol>();
        for (Term term : terms) {
            if (term == null) continue;
            BandArithmetic.collectRefRasterDataSymbols(term, list, set);
        }
        return list.toArray(new RasterDataSymbol[list.size()]);
    }

    public static String getValidMaskExpression(String expression, Product product, String validMaskExpression) throws ParseException {
        return BandArithmetic.getValidMaskExpression(expression, new Product[]{product}, 0, validMaskExpression);
    }

    public static String getValidMaskExpression(String expression, Product[] products, int contextProductIndex, String validMaskExpression) throws ParseException {
        RasterDataNode[] rasters = BandArithmetic.getRefRasters(expression, products, contextProductIndex);
        if (rasters.length == 0) {
            return validMaskExpression;
        }
        Product contextProduct = products[contextProductIndex];
        if (StringUtils.isNullOrEmpty(validMaskExpression) && rasters.length == 1 && contextProduct == rasters[0].getProduct()) {
            return rasters[0].getValidMaskExpression();
        }
        ArrayList<String> vmes = new ArrayList<String>(rasters.length);
        for (RasterDataNode raster : rasters) {
            String vme = raster.getValidMaskExpression();
            if (vme == null) continue;
            if (raster.getProduct() != contextProduct) {
                int productIndex = BandArithmetic.getProductIndex(products, raster);
                Assert.state((productIndex >= 0 ? 1 : 0) != 0, (String)"productIndex >= 0");
                vme = BandArithmetic.createUnambiguousExpression(vme, products, productIndex);
            }
            if (vmes.contains(vme)) continue;
            vmes.add(vme);
        }
        if (vmes.isEmpty()) {
            return validMaskExpression;
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotNullAndNotEmpty(validMaskExpression)) {
            sb.append("(");
            sb.append(validMaskExpression);
            sb.append(")");
        }
        for (String vme : vmes) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append("(");
            sb.append(vme);
            sb.append(")");
        }
        return sb.toString();
    }

    public static String createExternalName(String name) {
        return Tokenizer.createExternalName(name);
    }

    public static String getProductNodeNamePrefix(Product product) {
        Guardian.assertNotNull("product", (Object)product);
        return "$" + product.getRefNo() + ".";
    }

    public static boolean areRastersEqualInSize(Term term) {
        RasterDataSymbol[] rasterDataSymbols = BandArithmetic.getRefRasterDataSymbols(term);
        if (rasterDataSymbols.length > 1) {
            int referenceWidth = rasterDataSymbols[0].getRaster().getRasterWidth();
            int referenceHeight = rasterDataSymbols[0].getRaster().getRasterHeight();
            for (int i = 1; i < rasterDataSymbols.length; ++i) {
                if (rasterDataSymbols[i].getRaster().getRasterWidth() == referenceWidth && rasterDataSymbols[i].getRaster().getRasterHeight() == referenceHeight) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areRastersEqualInSize(Product product, String ... expressions) throws ParseException {
        return BandArithmetic.areRastersEqualInSize(new Product[]{product}, 0, expressions);
    }

    public static boolean areRastersEqualInSize(Product[] products, int defaultProductIndex, String ... expressions) throws ParseException {
        if (expressions.length == 0) {
            return true;
        }
        int referenceWidth = -1;
        int referenceHeight = -1;
        for (String expression : expressions) {
            WritableNamespace namespace = BandArithmetic.createDefaultNamespace(products, defaultProductIndex);
            ParserImpl parser = new ParserImpl(namespace, false);
            Term term = parser.parse(expression);
            RasterDataNode[] refRasters = BandArithmetic.getRefRasters(term);
            if (refRasters.length <= 0) continue;
            if (!BandArithmetic.areRastersEqualInSize(term)) {
                return false;
            }
            if (referenceWidth == -1) {
                referenceWidth = refRasters[0].getRasterWidth();
                referenceHeight = refRasters[0].getRasterHeight();
                continue;
            }
            if (refRasters[0].getRasterWidth() == referenceWidth && refRasters[0].getRasterHeight() == referenceHeight) continue;
            return false;
        }
        return true;
    }

    private static void collectRefRasterDataSymbols(Term term, List<RasterDataSymbol> list, Set<RasterDataSymbol> set) {
        if (term == null) {
            return;
        }
        if (term instanceof Term.Ref) {
            RasterDataSymbol rds;
            Symbol symbol = ((Term.Ref)term).getSymbol();
            if (symbol instanceof RasterDataSymbol && !set.contains(rds = (RasterDataSymbol)symbol)) {
                list.add(rds);
                set.add(rds);
            }
        } else {
            Term[] children;
            for (Term child : children = term.getChildren()) {
                BandArithmetic.collectRefRasterDataSymbols(child, list, set);
            }
        }
    }

    private static RasterDataNode[] getRefRasters(RasterDataSymbol[] rasterDataSymbols) {
        HashSet<RasterDataNode> set = new HashSet<RasterDataNode>(rasterDataSymbols.length * 2);
        ArrayList<RasterDataNode> list = new ArrayList<RasterDataNode>(rasterDataSymbols.length);
        for (RasterDataSymbol symbol : rasterDataSymbols) {
            RasterDataNode raster = symbol.getRaster();
            if (set.contains(raster)) continue;
            list.add(raster);
            set.add(raster);
        }
        return list.toArray(new RasterDataNode[list.size()]);
    }

    private static boolean isNameChar(char c) {
        return Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c);
    }

    private static int getProductIndex(Product[] products, RasterDataNode raster) {
        int productIndex = -1;
        for (int i = 0; i < products.length; ++i) {
            Product product = products[i];
            if (product != raster.getProduct()) continue;
            productIndex = i;
            break;
        }
        return productIndex;
    }

    private static String createUnambiguousExpression(String vme, Product[] products, int productIndex) throws ParseException {
        RasterDataNode[] rasters;
        for (RasterDataNode raster : rasters = BandArithmetic.getRefRasters((String)vme, products, productIndex)) {
            boolean changed;
            String name = raster.getName();
            int namePos = 0;
            do {
                char c2;
                changed = false;
                if ((namePos = ((String)vme).indexOf(name, namePos)) == 0) {
                    String prefix = BandArithmetic.getProductNodeNamePrefix(raster.getProduct());
                    vme = prefix + (String)vme;
                    namePos += name.length() + prefix.length();
                    changed = true;
                    continue;
                }
                if (namePos <= 0) continue;
                int i1 = namePos - 1;
                int i2 = namePos + name.length();
                char c1 = ((String)vme).charAt(i1);
                char c = c2 = i2 < ((String)vme).length() ? ((String)vme).charAt(i2) : (char)'\u0000';
                if (c1 == '.' || BandArithmetic.isNameChar(c1) || BandArithmetic.isNameChar(c2)) continue;
                String prefix = BandArithmetic.getProductNodeNamePrefix(raster.getProduct());
                vme = ((String)vme).substring(0, namePos) + prefix + ((String)vme).substring(namePos);
                namePos += name.length() + prefix.length();
                changed = true;
            } while (changed);
        }
        return vme;
    }
}

