/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel.quicklooks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Timer;
import java.util.TimerTask;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;

public class QuicklookDB {
    public static final String PREFERENCE_KEY_QUICKLOOKS_CACHE_DIR = "quicklooks.cachedir";
    public static final int QL_NOT_FOUND = -1;
    private static final String QUICKLOOK_PROPERTY_MAP_FILENAME = "qlPropertyMap.db";
    private static final String QUICKLOOK_PROPERTY_MAP_LAST_INDEX = "last.index";
    private static QuicklookDB theInstance = null;
    private static final Path qlCacheDir = QuicklookDB.getQuicklookCacheDir();
    private final Path propertyMapFile;
    private final PropertyMap propertyMap;
    private boolean needsSaving;
    private int index;
    private Timer timer;

    public static QuicklookDB instance() {
        if (theInstance == null) {
            theInstance = new QuicklookDB();
        }
        return theInstance;
    }

    private QuicklookDB() {
        File cacheDir = qlCacheDir.toFile();
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            SystemUtils.LOG.severe("Unable to create quicklook cache folder: " + qlCacheDir);
        }
        this.propertyMap = new DefaultPropertyMap();
        this.propertyMapFile = qlCacheDir.resolve(QUICKLOOK_PROPERTY_MAP_FILENAME);
        try {
            if (this.propertyMapFile.toFile().exists()) {
                this.propertyMap.load(this.propertyMapFile);
                this.index = this.propertyMap.getPropertyInt(QUICKLOOK_PROPERTY_MAP_LAST_INDEX);
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to load quicklook property map: " + this.propertyMapFile);
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new SavePropertiesTask(), 30000L, 30000L);
    }

    public static Path getQuicklookCacheDir() {
        String cacheDirPath = Config.instance().preferences().get(PREFERENCE_KEY_QUICKLOOKS_CACHE_DIR, null);
        if (cacheDirPath != null) {
            return new File(cacheDirPath).toPath();
        }
        return QuicklookDB.getDefaultQuicklookCacheDir();
    }

    private static Path getDefaultQuicklookCacheDir() {
        return SystemUtils.getApplicationDataDir().toPath().resolve("var").resolve("quicklooks_cache");
    }

    public int getQuicklookId(File file) {
        return this.propertyMap.getPropertyInt(file.getAbsolutePath(), -1);
    }

    public synchronized int addQuickLookId(File file) {
        ++this.index;
        this.propertyMap.setPropertyInt(file.getAbsolutePath(), this.index);
        this.propertyMap.setPropertyInt(QUICKLOOK_PROPERTY_MAP_LAST_INDEX, this.index);
        this.needsSaving = true;
        return this.index;
    }

    private synchronized void saveProperties() {
        try {
            this.propertyMap.store(this.propertyMapFile, "");
            this.needsSaving = false;
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to save quicklook property map: " + this.propertyMapFile);
        }
    }

    private class SavePropertiesTask
    extends TimerTask {
        private SavePropertiesTask() {
        }

        @Override
        public void run() {
            if (QuicklookDB.this.needsSaving) {
                QuicklookDB.this.saveProperties();
            }
        }
    }
}

