/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.GenericPlacemarkDescriptor;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.core.util.ObservableFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class VectorDataNode
extends ProductNode {
    public static final String PROPERTY_NAME_FEATURE_COLLECTION = "featureCollection";
    public static final String PROPERTY_NAME_STYLE_CSS = "styleCss";
    public static final String PROPERTY_NAME_DEFAULT_STYLE_CSS = "defaultStyleCss";
    private static final String DEFAULT_STYLE_FORMAT = "fill:%s; fill-opacity:0.5; stroke:#ffffff; stroke-opacity:1.0; stroke-width:1.0; symbol:cross";
    private static final String[] FILL_COLORS = new String[]{"#ff0000", "#00ff00", "#0000ff", "#aaff00", "#00aaff", "#ffaa00", "#ff00aa", "#aa00ff", "#00ffaa"};
    private static int fillColorIndex;
    private final SimpleFeatureType featureType;
    private final ObservableFeatureCollection featureCollection;
    private final PlacemarkDescriptor placemarkDescriptor;
    private PlacemarkGroup placemarkGroup;
    private String defaultStyleCss;
    private String styleCss;
    private boolean permanent;

    public VectorDataNode(String name, SimpleFeatureType featureType) {
        this(name, (FeatureCollection<SimpleFeatureType, SimpleFeature>)new DefaultFeatureCollection(name, featureType), VectorDataNode.getPlacemarkDescriptor(featureType));
    }

    public VectorDataNode(String name, FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        this(name, featureCollection, VectorDataNode.getPlacemarkDescriptor((SimpleFeatureType)featureCollection.getSchema()));
    }

    public VectorDataNode(String name, FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, PlacemarkDescriptor placemarkDescriptor) {
        super(name, "");
        this.featureType = (SimpleFeatureType)featureCollection.getSchema();
        this.featureCollection = new ObservableFeatureCollection(featureCollection);
        this.featureCollection.addListener(this::fireCollectionEvent);
        this.defaultStyleCss = String.format(DEFAULT_STYLE_FORMAT, FILL_COLORS[fillColorIndex++ % FILL_COLORS.length]);
        this.placemarkDescriptor = placemarkDescriptor;
        Debug.trace(String.format("VectorDataNode created: name=%s, featureType.typeName=%s, placemarkDescriptor.class=%s", name, this.featureType.getTypeName(), placemarkDescriptor.getClass()));
    }

    private void fireCollectionEvent(ObservableFeatureCollection.EVENT_TYPE type, SimpleFeature[] changedFeatures) {
        if (type == ObservableFeatureCollection.EVENT_TYPE.ADDED) {
            this._fireFeaturesAdded(changedFeatures);
        } else if (type == ObservableFeatureCollection.EVENT_TYPE.REMOVED) {
            this._fireFeaturesRemoved(changedFeatures);
        }
    }

    @Override
    public synchronized void setOwner(ProductNode owner) {
        super.setOwner(owner);
        if (this.getProduct() != null) {
            this.updateFeatureCollectionByPlacemarkGroup();
        }
    }

    public PlacemarkDescriptor getPlacemarkDescriptor() {
        return this.placemarkDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlacemarkGroup getPlacemarkGroup() {
        if (this.placemarkGroup == null) {
            VectorDataNode vectorDataNode = this;
            synchronized (vectorDataNode) {
                if (this.placemarkGroup == null) {
                    this.placemarkGroup = new PlacemarkGroup(this.getProduct(), this.getName(), this);
                }
            }
        }
        return this.placemarkGroup;
    }

    @Override
    public synchronized void setModified(boolean modified) {
        super.setModified(modified);
        if (this.placemarkGroup != null) {
            this.placemarkGroup.setModified(modified);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public DefaultFeatureCollection getFeatureCollection() {
        return this.featureCollection;
    }

    public ReferencedEnvelope getEnvelope() {
        return this.featureCollection.getBounds();
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return this.featureType.getAttributeCount() * this.featureCollection.size() * 256;
    }

    public String getDefaultStyleCss() {
        return this.defaultStyleCss;
    }

    public void setDefaultStyleCss(String defaultStyleCss) {
        Assert.notNull((Object)this.defaultStyleCss, (String)PROPERTY_NAME_DEFAULT_STYLE_CSS);
        if (!ObjectUtils.equalObjects(this.defaultStyleCss, defaultStyleCss)) {
            String oldValue = this.defaultStyleCss;
            this.defaultStyleCss = defaultStyleCss;
            this.fireProductNodeChanged(PROPERTY_NAME_DEFAULT_STYLE_CSS, oldValue, this.defaultStyleCss);
        }
    }

    public String getStyleCss() {
        return this.styleCss;
    }

    public void setStyleCss(String styleCss) {
        if (!ObjectUtils.equalObjects(this.styleCss, styleCss)) {
            String oldValue = this.styleCss;
            this.styleCss = styleCss;
            this.fireProductNodeChanged(PROPERTY_NAME_STYLE_CSS, oldValue, this.styleCss);
        }
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        if (this.placemarkGroup != null) {
            this.placemarkGroup.acceptVisitor(visitor);
        }
        visitor.visit(this);
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    private void updateFeatureCollectionByPlacemarkGroup() {
        try (SimpleFeatureIterator iterator = this.featureCollection.features();){
            while (iterator.hasNext()) {
                this.generatePlacemarkForFeature((SimpleFeature)iterator.next());
            }
        }
    }

    private void generatePlacemarkForFeature(SimpleFeature feature) {
        Placemark placemark = this.getPlacemarkGroup().getPlacemark(feature);
        if (placemark == null) {
            this.placemarkGroup.add(this.placemarkDescriptor.createPlacemark(feature));
        }
    }

    private static PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType featureType) {
        PlacemarkDescriptorRegistry registry = PlacemarkDescriptorRegistry.getInstance();
        PlacemarkDescriptor placemarkDescriptor = registry.getPlacemarkDescriptor(featureType);
        if (placemarkDescriptor == null) {
            return new GenericPlacemarkDescriptor(featureType);
        }
        return placemarkDescriptor;
    }

    private void _fireFeaturesAdded(SimpleFeature[] features) {
        this.fireProductNodeChanged(PROPERTY_NAME_FEATURE_COLLECTION, null, features);
    }

    private void _fireFeaturesRemoved(SimpleFeature[] features) {
        this.fireProductNodeChanged(PROPERTY_NAME_FEATURE_COLLECTION, features, null);
    }

    private void _fireFeaturesChanged(SimpleFeature[] features) {
        this.fireProductNodeChanged(PROPERTY_NAME_FEATURE_COLLECTION, features, features);
    }

    @Deprecated
    public boolean isInternalNode() {
        return this.getFeatureType().getTypeName().startsWith("org.esa.snap.");
    }

    @Deprecated
    public String getDefaultCSS() {
        return this.getDefaultStyleCss();
    }

    @Deprecated
    public void setDefaultCSS(String defaultCSS) {
        this.setDefaultStyleCss(defaultCSS);
    }

    @Deprecated
    public void fireFeaturesAdded(SimpleFeature ... features) {
        this._fireFeaturesAdded(features);
    }

    @Deprecated
    public void fireFeaturesRemoved(SimpleFeature ... features) {
        this._fireFeaturesRemoved(features);
    }

    public void fireFeaturesChanged(SimpleFeature ... features) {
        this._fireFeaturesChanged(features);
    }
}

