/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.binding.PropertyContainer;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.AbstractMaskPersistenceConverter;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.VectorDataNode;

public class VectorDataMaskPersistenceConverter
extends AbstractMaskPersistenceConverter {
    public static final String ID_VERSION_1 = "VD_MASK:1";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    protected Mask.ImageType createImageType() {
        return Mask.VectorDataType.INSTANCE;
    }

    @Override
    protected void configureMask(Mask mask, Container root, final Product product) {
        final PropertyContainer imageConfig = mask.getImageConfig();
        String propertyName = "vectorData";
        final String vectorDataNodeName = root.getProperty("vectorData").getValueString();
        VectorDataNode vectorDataNode = product.getVectorDataGroup().get(vectorDataNodeName);
        if (vectorDataNode == null) {
            product.addProductNodeListener(new ProductNodeListenerAdapter(){

                @Override
                public void nodeAdded(ProductNodeEvent event) {
                    ProductNode sourceNode = event.getSourceNode();
                    String sourceNodeName = sourceNode.getName();
                    if (!vectorDataNodeName.equals(sourceNodeName)) {
                        return;
                    }
                    if (!(sourceNode instanceof VectorDataNode)) {
                        return;
                    }
                    product.removeProductNodeListener(this);
                    imageConfig.setValue("vectorData", (Object)sourceNode);
                }
            });
        } else {
            imageConfig.setValue("vectorData", (Object)vectorDataNode);
        }
    }

    @Override
    protected void configureContainer(Container root, Mask mask) {
        String propertyName = "vectorData";
        VectorDataNode vectorDataNode = (VectorDataNode)((Object)mask.getImageConfig().getValue("vectorData"));
        root.add(new Property<String>("vectorData", vectorDataNode.getName()));
    }
}

