/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Arrays;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ShapeRasterizer;
import org.esa.snap.core.util.math.MathUtils;

public class TransectProfileData {
    public static final GeoPos NO_GEO_POS = new GeoPos(Double.NaN, Double.NaN);
    private final Point2D[] shapeVertices;
    private final int[] shapeVertexIndexes;
    private final Point2D[] pixelPositions;
    private final GeoPos[] geoPositions;
    private final float[] sampleValues;
    private final float[] sampleSigmas;
    private float sampleMin;
    private float sampleMax;
    Config config;

    @Deprecated
    public static TransectProfileData create(RasterDataNode raster, Shape path) throws IOException {
        Config config = new Config();
        config.raster = raster;
        config.path = path;
        config.boxSize = 1;
        config.useRoiMask = false;
        config.roiMask = null;
        config.connectVertices = true;
        return new TransectProfileData(config);
    }

    TransectProfileData(Config config) throws IOException {
        this.config = config;
        ShapeRasterizer rasterizer = new ShapeRasterizer();
        GeoCoding geoCoding = config.raster.getGeoCoding();
        AffineTransform i2m = Product.findImageToModelTransform(geoCoding);
        if (!i2m.isIdentity()) {
            try {
                rasterizer.setTransform(i2m.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        this.shapeVertices = rasterizer.getVertices(config.path);
        this.shapeVertexIndexes = new int[this.shapeVertices.length];
        this.pixelPositions = rasterizer.rasterize(this.shapeVertices, this.shapeVertexIndexes);
        this.sampleValues = new float[this.pixelPositions.length];
        Arrays.fill(this.sampleValues, Float.NaN);
        this.sampleSigmas = new float[this.pixelPositions.length];
        Arrays.fill(this.sampleSigmas, Float.NaN);
        this.sampleMin = Float.MAX_VALUE;
        this.sampleMax = -3.4028235E38f;
        if (geoCoding != null) {
            this.geoPositions = new GeoPos[this.pixelPositions.length];
            Arrays.fill(this.geoPositions, NO_GEO_POS);
        } else {
            this.geoPositions = new GeoPos[0];
        }
        Rectangle sceneRect = new Rectangle(config.raster.getRasterWidth(), config.raster.getRasterHeight());
        PixelPos pixelPos = new PixelPos();
        int k = 0;
        for (int i = 0; i < this.pixelPositions.length; ++i) {
            Rectangle box;
            int xC = MathUtils.floorInt(this.pixelPositions[i].getX() + 0.5);
            int yC = MathUtils.floorInt(this.pixelPositions[i].getY() + 0.5);
            if (i == this.shapeVertexIndexes[k]) {
                ++k;
            } else if (!config.connectVertices) continue;
            if (!sceneRect.contains(xC, yC) || (box = sceneRect.intersection(new Rectangle(xC - config.boxSize / 2, yC - config.boxSize / 2, config.boxSize, config.boxSize))).isEmpty()) continue;
            float[] sampleBuffer = new float[box.width * box.height];
            config.raster.readPixels(box.x, box.y, box.width, box.height, sampleBuffer, ProgressMonitor.NULL);
            int[] maskBuffer = null;
            if (config.useRoiMask && config.roiMask != null) {
                maskBuffer = new int[box.width * box.height];
                config.roiMask.readPixels(box.x, box.y, box.width, box.height, maskBuffer, ProgressMonitor.NULL);
            }
            double sum = 0.0;
            double sumSqr = 0.0;
            int n = 0;
            for (int y = 0; y < box.height; ++y) {
                for (int x = 0; x < box.width; ++x) {
                    int index = y * box.width + x;
                    if (!config.raster.isPixelValid(box.x + x, box.y + y) || maskBuffer != null && maskBuffer[index] == 0) continue;
                    float v = sampleBuffer[index];
                    sum += (double)v;
                    sumSqr += (double)(v * v);
                    ++n;
                    if (v < this.sampleMin) {
                        this.sampleMin = v;
                    }
                    if (!(v > this.sampleMax)) continue;
                    this.sampleMax = v;
                }
            }
            if (n > 0) {
                double mean = sum / (double)n;
                double variance = n > 1 ? (sumSqr - sum * sum / (double)n) / (double)(n - 1) : 0.0;
                this.sampleValues[i] = (float)mean;
                this.sampleSigmas[i] = (float)(variance > 0.0 ? Math.sqrt(variance) : 0.0);
            }
            if (geoCoding == null) continue;
            pixelPos.x = (float)this.pixelPositions[i].getX() + 0.5f;
            pixelPos.y = (float)this.pixelPositions[i].getY() + 0.5f;
            this.geoPositions[i] = geoCoding.getGeoPos(pixelPos, null);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public int getNumPixels() {
        return this.pixelPositions.length;
    }

    public int getNumShapeVertices() {
        return this.shapeVertices.length;
    }

    public Point2D[] getShapeVertices() {
        return this.shapeVertices;
    }

    public int[] getShapeVertexIndexes() {
        return this.shapeVertexIndexes;
    }

    public Point2D[] getPixelPositions() {
        return this.pixelPositions;
    }

    public GeoPos[] getGeoPositions() {
        return this.geoPositions;
    }

    public float[] getSampleValues() {
        return this.sampleValues;
    }

    public float[] getSampleSigmas() {
        return this.sampleSigmas;
    }

    public float getSampleMin() {
        return this.sampleMin;
    }

    public float getSampleMax() {
        return this.sampleMax;
    }

    public static class Config {
        public RasterDataNode raster;
        public Shape path;
        public int boxSize;
        public boolean useRoiMask;
        public Mask roiMask;
        public boolean connectVertices;
    }
}

