/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.GeoCodingPersistenceHelper;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.maptransf.Datum;

public class TiePointGeoCodingPersistenceConverter
extends PersistenceConverter<TiePointGeoCoding> {
    public static final String ID_VERSION_1 = "TiePointGC:1";
    private static final String NAME_TIE_POINT_GEO_CODING = "TiePointGeoCoding";
    private static final String NAME_GEOPOSITION = "Geoposition";
    private static final String NAME_GEOPOSITION_POINTS = "Geoposition_Points";
    private static final String NAME_TIE_POINT_GRID_NAME_LAT = "TIE_POINT_GRID_NAME_LAT";
    private static final String NAME_TIE_POINT_GRID_NAME_LON = "TIE_POINT_GRID_NAME_LON";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    public Item encode(TiePointGeoCoding gc) {
        Container root = this.createRootContainer(NAME_TIE_POINT_GEO_CODING);
        root.add(GeoCodingPersistenceHelper.createDatumContainer(gc));
        Container geoPosPoints = new Container(NAME_GEOPOSITION_POINTS);
        geoPosPoints.add(new Property<String>(NAME_TIE_POINT_GRID_NAME_LAT, gc.getLatGrid().getName()));
        geoPosPoints.add(new Property<String>(NAME_TIE_POINT_GRID_NAME_LON, gc.getLonGrid().getName()));
        Container geoPosContainer = new Container(NAME_GEOPOSITION);
        geoPosContainer.add(geoPosPoints);
        root.add(geoPosContainer);
        return root;
    }

    @Override
    public TiePointGeoCoding decodeImpl(Item item, Product product) {
        Container root = item.asContainer();
        Container CRS2 = root.getContainer("Coordinate_Reference_System");
        Datum datum = GeoCodingPersistenceHelper.createDatum(CRS2);
        Container geoPosContainer = root.getContainer(NAME_GEOPOSITION);
        Container geoPointsContainer = geoPosContainer.getContainer(NAME_GEOPOSITION_POINTS);
        String latName = geoPointsContainer.getProperty(NAME_TIE_POINT_GRID_NAME_LAT).getValueString();
        String lonName = geoPointsContainer.getProperty(NAME_TIE_POINT_GRID_NAME_LON).getValueString();
        TiePointGrid latGrid = product.getTiePointGrid(latName);
        TiePointGrid lonGrid = product.getTiePointGrid(lonName);
        return new TiePointGeoCoding(latGrid, lonGrid, datum);
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[0];
    }
}

