/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.awt.geom.AffineTransform;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;

public class RasterDataNodePersistenceHelper {
    public static final String NAME_ANCILLARY_RELATIONS = "ANCILLARY_RELATIONS";
    public static final String NAME_ANCILLARY_VARIABLES = "ANCILLARY_VARIABLES";
    public static final String NAME_IMAGE_TO_MODEL_TRANSFORM = "IMAGE_TO_MODEL_TRANSFORM";

    public static void addAncillaryElements(Container root, RasterDataNode rasterDataNode) {
        RasterDataNode[] ancillaryVariables;
        String[] ancillaryRelations = rasterDataNode.getAncillaryRelations();
        if (ancillaryRelations != null && ancillaryRelations.length > 0) {
            root.add(new Property<String[]>(NAME_ANCILLARY_RELATIONS, ancillaryRelations));
        }
        if ((ancillaryVariables = rasterDataNode.getAncillaryVariables(new String[0])) != null && ancillaryVariables.length > 0) {
            String[] variableNames = new String[ancillaryVariables.length];
            for (int i = 0; i < ancillaryVariables.length; ++i) {
                variableNames[i] = ancillaryVariables[i].getName();
            }
            root.add(new Property<String[]>(NAME_ANCILLARY_VARIABLES, variableNames));
        }
    }

    public static void setAncillaryVariables(Container container, final RasterDataNode rasterDataNode, final Product product) {
        Property<?> ancVars = container.getProperty(NAME_ANCILLARY_VARIABLES);
        if (ancVars == null) {
            return;
        }
        String[] variableNames = ancVars.getValueStrings();
        if (variableNames == null || variableNames.length == 0) {
            return;
        }
        for (final String variableName : variableNames) {
            RasterDataNode variable = product.getRasterDataNode(variableName);
            if (variable != null) {
                rasterDataNode.addAncillaryVariable(variable, new String[0]);
                continue;
            }
            product.addProductNodeListener(new ProductNodeListenerAdapter(){

                @Override
                public void nodeAdded(ProductNodeEvent event) {
                    ProductNode sourceNode = event.getSourceNode();
                    String sourceNodeName = sourceNode.getName();
                    if (!variableName.equals(sourceNodeName)) {
                        return;
                    }
                    if (!(sourceNode instanceof RasterDataNode)) {
                        return;
                    }
                    product.removeProductNodeListener(this);
                    rasterDataNode.addAncillaryVariable((RasterDataNode)sourceNode, new String[0]);
                }
            });
        }
    }

    public static void setAncillaryRelations(Container element, RasterDataNode rasterDataNode) {
        Property<?> relationsProp = element.getProperty(NAME_ANCILLARY_RELATIONS);
        if (relationsProp == null) {
            return;
        }
        String[] relations = relationsProp.getValueStrings();
        if (relations == null || relations.length == 0) {
            return;
        }
        rasterDataNode.setAncillaryRelations(relations);
    }

    public static void addImageToModelTransformElement(Container root, RasterDataNode rasterDataNode) {
        AffineTransform imageToModelTransform = rasterDataNode.getImageToModelTransform();
        if (!imageToModelTransform.isIdentity()) {
            double[] matrix = new double[6];
            imageToModelTransform.getMatrix(matrix);
            root.add(new Property<double[]>(NAME_IMAGE_TO_MODEL_TRANSFORM, matrix));
        }
    }

    public static void setImageToModelTransform(Container container, RasterDataNode rasterDataNode) {
        Property<?> transformProp = container.getProperty(NAME_IMAGE_TO_MODEL_TRANSFORM);
        if (transformProp == null) {
            return;
        }
        Double[] matrix = transformProp.getValueDoubles();
        if (matrix != null && matrix.length > 0) {
            double[] doubles = new double[matrix.length];
            for (int i = 0; i < matrix.length; ++i) {
                doubles[i] = matrix[i];
            }
            AffineTransform transform = new AffineTransform(doubles);
            rasterDataNode.setImageToModelTransform(transform);
        }
    }
}

